/*
 * Decompiled with CFR 0.152.
 */
package tfar.darkness;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.potion.Effects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="totaldarkness")
public class Darkness {
    public static Logger LOG = LogManager.getLogger((String)"Darkness");
    public static final String MODID = "totaldarkness";
    public static final Config CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static boolean enabled;
    private static final float[][] LUMINANCE;

    public Darkness() {
        if (FMLEnvironment.dist.isClient()) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigChange);
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        }
    }

    private void onConfigChange(ModConfig.ModConfigEvent e) {
        Darkness.bake();
    }

    public static void bake() {
        Config.darkNetherFogEffective = (Boolean)Config.darkNether.get() != false ? (Double)Config.darkNetherFogConfigured.get() : 1.0;
        Config.darkEndFogEffective = (Boolean)Config.darkEnd.get() != false ? (Double)Config.darkEndFogConfigured.get() : 1.0;
    }

    public static boolean blockLightOnly() {
        return (Boolean)Config.blockLightOnly.get();
    }

    public static double darkNetherFog() {
        return Config.darkNetherFogEffective;
    }

    public static double darkEndFog() {
        return Config.darkEndFogEffective;
    }

    private static boolean isDark(World world) {
        RegistryKey dimType = world.func_234923_W_();
        if (dimType == World.field_234918_g_) {
            return (Boolean)Config.darkOverworld.get();
        }
        if (dimType == World.field_234919_h_) {
            return (Boolean)Config.darkNether.get();
        }
        if (dimType == World.field_234920_i_) {
            return (Boolean)Config.darkEnd.get();
        }
        if (world.func_230315_m_().func_218272_d()) {
            return (Boolean)Config.darkDefault.get();
        }
        return (Boolean)Config.darkSkyless.get();
    }

    private static float skyFactor(World world) {
        if (!((Boolean)Config.blockLightOnly.get()).booleanValue() && Darkness.isDark(world)) {
            if (world.func_230315_m_().func_218272_d()) {
                float angle = world.func_242415_f(0.0f);
                if (angle > 0.25f && angle < 0.75f) {
                    float oldWeight = Math.max(0.0f, Math.abs(angle - 0.5f) - 0.2f) * 20.0f;
                    float moon = (Boolean)Config.ignoreMoonPhase.get() != false ? 0.0f : world.func_242413_ae();
                    return MathHelper.func_219799_g((float)(oldWeight * oldWeight * oldWeight), (float)(moon * moon), (float)1.0f);
                }
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public static int darken(int c, int blockIndex, int skyIndex) {
        float lTarget = LUMINANCE[blockIndex][skyIndex];
        float r = (float)(c & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c >> 16 & 0xFF) / 255.0f;
        float l = Darkness.luminance(r, g, b);
        float f = l > 0.0f ? Math.min(1.0f, lTarget / l) : 0.0f;
        return f == 1.0f ? c : 0xFF000000 | Math.round(f * r * 255.0f) | Math.round(f * g * 255.0f) << 8 | Math.round(f * b * 255.0f) << 16;
    }

    public static float luminance(float r, float g, float b) {
        return r * 0.2126f + g * 0.7152f + b * 0.0722f;
    }

    public static void updateLuminance(float tickDelta, Minecraft client, GameRenderer worldRenderer, float prevFlicker) {
        ClientWorld world = client.field_71441_e;
        if (world != null) {
            if (!Darkness.isDark((World)world) || client.field_71439_g.func_70644_a(Effects.field_76439_r) || client.field_71439_g.func_70644_a(Effects.field_205136_C) && client.field_71439_g.func_203719_J() > 0.0f || world.func_228332_n_() > 0) {
                enabled = false;
                return;
            }
            enabled = true;
            float dimSkyFactor = Darkness.skyFactor((World)world);
            float ambient = world.func_228326_g_(1.0f);
            DimensionType dim = world.func_230315_m_();
            boolean blockAmbient = !Darkness.isDark((World)world);
            for (int skyIndex = 0; skyIndex < 16; ++skyIndex) {
                float v;
                float skyFactor = 1.0f - (float)skyIndex / 15.0f;
                skyFactor = 1.0f - skyFactor * skyFactor * skyFactor * skyFactor;
                float min = (skyFactor *= dimSkyFactor) * 0.05f;
                float rawAmbient = ambient * skyFactor;
                float minAmbient = rawAmbient * (1.0f - min) + min;
                float skyBase = dim.func_236021_a_(skyIndex) * minAmbient;
                min = 0.35f * skyFactor;
                float skyRed = v = skyBase * (rawAmbient * (1.0f - min) + min);
                float skyGreen = v;
                float skyBlue = skyBase;
                if (worldRenderer.func_205002_d(tickDelta) > 0.0f) {
                    float skyDarkness = worldRenderer.func_205002_d(tickDelta);
                    skyRed = skyRed * (1.0f - skyDarkness) + skyRed * 0.7f * skyDarkness;
                    skyGreen = skyGreen * (1.0f - skyDarkness) + skyGreen * 0.6f * skyDarkness;
                    skyBlue = skyBlue * (1.0f - skyDarkness) + skyBlue * 0.6f * skyDarkness;
                }
                for (int blockIndex = 0; blockIndex < 16; ++blockIndex) {
                    float blockFactor = 1.0f;
                    if (!blockAmbient) {
                        blockFactor = 1.0f - (float)blockIndex / 15.0f;
                        blockFactor = 1.0f - blockFactor * blockFactor * blockFactor * blockFactor;
                    }
                    float blockBase = blockFactor * dim.func_236021_a_(blockIndex) * (prevFlicker * 0.1f + 1.5f);
                    min = 0.4f * blockFactor;
                    float blockGreen = blockBase * ((blockBase * (1.0f - min) + min) * (1.0f - min) + min);
                    float blockBlue = blockBase * (blockBase * blockBase * (1.0f - min) + min);
                    float red = skyRed + blockBase;
                    float green = skyGreen + blockGreen;
                    float blue = skyBlue + blockBlue;
                    float f = Math.max(skyFactor, blockFactor);
                    min = 0.03f * f;
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (world.func_234923_W_() == World.field_234920_i_) {
                        red = skyFactor * 0.22f + blockBase * 0.75f;
                        green = skyFactor * 0.28f + blockGreen * 0.75f;
                        blue = skyFactor * 0.25f + blockBlue * 0.75f;
                    }
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    float gamma = (float)client.field_71474_y.field_74333_Y * f;
                    float invRed = 1.0f - red;
                    float invGreen = 1.0f - green;
                    float invBlue = 1.0f - blue;
                    invRed = 1.0f - invRed * invRed * invRed * invRed;
                    invGreen = 1.0f - invGreen * invGreen * invGreen * invGreen;
                    invBlue = 1.0f - invBlue * invBlue * invBlue * invBlue;
                    red = red * (1.0f - gamma) + invRed * gamma;
                    green = green * (1.0f - gamma) + invGreen * gamma;
                    blue = blue * (1.0f - gamma) + invBlue * gamma;
                    min = 0.03f * f;
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    if (red < 0.0f) {
                        red = 0.0f;
                    }
                    if (green < 0.0f) {
                        green = 0.0f;
                    }
                    if (blue < 0.0f) {
                        blue = 0.0f;
                    }
                    Darkness.LUMINANCE[blockIndex][skyIndex] = Darkness.luminance(red, green, blue);
                }
            }
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Config)specPair.getLeft();
        enabled = false;
        LUMINANCE = new float[16][16];
    }

    public static class Config {
        static double darkNetherFogEffective;
        static ForgeConfigSpec.DoubleValue darkNetherFogConfigured;
        static ForgeConfigSpec.BooleanValue darkEnd;
        static double darkEndFogEffective;
        static ForgeConfigSpec.DoubleValue darkEndFogConfigured;
        static ForgeConfigSpec.BooleanValue darkSkyless;
        static ForgeConfigSpec.BooleanValue blockLightOnly;
        static ForgeConfigSpec.BooleanValue ignoreMoonPhase;
        static ForgeConfigSpec.BooleanValue darkOverworld;
        static ForgeConfigSpec.BooleanValue darkDefault;
        static ForgeConfigSpec.BooleanValue darkNether;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            blockLightOnly = builder.define("only_affect_block_light", false);
            ignoreMoonPhase = builder.define("ignore_moon_phase", false);
            darkOverworld = builder.define("dark_overworld", true);
            darkDefault = builder.define("dark_default", true);
            darkNether = builder.define("dark_nether", true);
            darkNetherFogConfigured = builder.defineInRange("dark_nether_fog", 0.5, 0.0, 1.0);
            darkEnd = builder.define("dark_end", true);
            darkEndFogConfigured = builder.defineInRange("dark_end_fog", 0.0, 0.0, 1.0);
            darkSkyless = builder.define("dark_skyless", true);
            builder.pop();
        }
    }
}

