/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.config;

import deerangle.treemendous.tree.RegisteredTree;
import deerangle.treemendous.tree.TreeRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;

public class TreemendousConfig {
    public static BiomeSpawnRate biomeSpawnRateConfig;
    public static final ForgeConfigSpec CONFIG_SPEC;

    private static ForgeConfigSpec makeConfigSpec() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        biomeSpawnRateConfig = new BiomeSpawnRate(builder);
        return builder.build();
    }

    static {
        CONFIG_SPEC = TreemendousConfig.makeConfigSpec();
    }

    public static class BiomeSpawnRate {
        public final ForgeConfigSpec.ConfigValue<Integer> mixedMapleForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mixedForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mixedForestVanillaWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> needleForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> needleForestSnowWeight;
        public final Map<RegistryKey<Biome>, ForgeConfigSpec.ConfigValue<Integer>> treeWeights;

        public BiomeSpawnRate(ForgeConfigSpec.Builder builder) {
            builder.push("biomes");
            this.treeWeights = new HashMap<RegistryKey<Biome>, ForgeConfigSpec.ConfigValue<Integer>>();
            this.mixedMapleForestWeight = builder.comment("Spawn weight of mixed maple forest biome (higher number means more frequent)").define("mixed_maple_forest_weight", (Object)6);
            this.mixedForestWeight = builder.comment("Spawn weight of mixed forest biome (higher number means more frequent)").define("mixed_forest_weight", (Object)6);
            this.mixedForestVanillaWeight = builder.comment("Spawn weight of mixed forest biome with vanilla trees (higher number means more frequent)").define("mixed_forest_vanilla_weight", (Object)6);
            this.needleForestWeight = builder.comment("Spawn weight of needle forest biome (higher number means more frequent)").define("needle_forest_weight", (Object)6);
            this.needleForestSnowWeight = builder.comment("Spawn weight of needle forest biome with snow (higher number means more frequent)").define("needle_forest_snow_weight", (Object)6);
            builder.push("single_tree");
            for (RegisteredTree tree : TreeRegistry.TREES) {
                for (RegistryKey<Biome> registryKey : tree.getFrostyBiomes()) {
                    this.treeWeights.put(registryKey, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Spawn weight of " + tree.getEnglishName() + " (" + registryKey.func_240901_a_() + ") biome with snow (higher number means more frequent)").define(registryKey.func_240901_a_().func_110623_a() + "_weight", (Object)8));
                }
                for (RegistryKey<Biome> registryKey : tree.getBiomes()) {
                    this.treeWeights.put(registryKey, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Spawn weight of " + tree.getEnglishName() + " (" + registryKey.func_240901_a_() + ") biome (higher number means more frequent)").define(registryKey.func_240901_a_().func_110623_a() + "_weight", (Object)8));
                }
            }
            builder.pop();
            builder.pop();
        }
    }
}

