/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.data;

import deerangle.treemendous.main.Treemendous;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.IResource;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class AbstractTextureProvider
implements IDataProvider {
    protected final ExistingFileHelper existingFileHelper;
    protected final DataGenerator generator;
    protected final String modid;
    protected final Map<ResourceLocation, Texture> textures;

    public AbstractTextureProvider(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        this.generator = generator;
        this.modid = modid;
        this.existingFileHelper = existingFileHelper;
        this.textures = new HashMap<ResourceLocation, Texture>();
    }

    protected Texture loadTexture(String path) throws IOException {
        return this.loadTexture(path, "templates");
    }

    protected Texture loadTexture(String path, String folder) throws IOException {
        IResource res = this.existingFileHelper.getResource(new ResourceLocation("base", path), ResourcePackType.CLIENT_RESOURCES, ".png", folder);
        NativeImage img = NativeImage.func_195713_a((InputStream)res.func_199027_b());
        byte[] data = new byte[img.func_195714_b() * img.func_195702_a() * 4];
        for (int y = 0; y < img.func_195714_b(); ++y) {
            for (int x = 0; x < img.func_195702_a(); ++x) {
                int color = img.func_195709_a(x, y);
                byte a = (byte)(color >> 24 & 0xFF);
                byte b = (byte)(color >> 16 & 0xFF);
                byte g = (byte)(color >> 8 & 0xFF);
                byte r = (byte)(color & 0xFF);
                data[(y * img.func_195702_a() + x) * 4] = a;
                data[(y * img.func_195702_a() + x) * 4 + 1] = b;
                data[(y * img.func_195702_a() + x) * 4 + 2] = g;
                data[(y * img.func_195702_a() + x) * 4 + 3] = r;
            }
        }
        return new Texture(img.func_195702_a(), img.func_195714_b(), data);
    }

    protected abstract void processTextures() throws IOException;

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.processTextures();
        this.textures.forEach((location, texture) -> {
            Path texturePath = this.generator.func_200391_b().resolve("assets/" + location.func_110624_b() + "/textures/" + location.func_110623_a() + ".png");
            byte[] data = ((Texture)texture).getData();
            try {
                String hash = field_208307_a.hashBytes(data).toString();
                if (!Objects.equals(cache.func_208323_a(texturePath), hash) || !Files.exists(texturePath, new LinkOption[0])) {
                    Files.createDirectories(texturePath.getParent(), new FileAttribute[0]);
                    try {
                        ((Texture)texture).getNativeImage().func_209270_a(texturePath);
                    }
                    catch (IOException e) {
                        Treemendous.LOGGER.error((Object)e.getStackTrace());
                    }
                }
                cache.func_208316_a(texturePath, hash);
            }
            catch (IOException e) {
                Treemendous.LOGGER.error("Couldn't write loot table {}", (Object)texturePath, (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return "Wood Textures";
    }

    protected ResourceLocation blockTexture(ResourceLocation id) {
        return new ResourceLocation(id.func_110624_b(), "block/" + id.func_110623_a());
    }

    protected ResourceLocation itemTexture(ResourceLocation id) {
        return new ResourceLocation(id.func_110624_b(), "item/" + id.func_110623_a());
    }

    class Texture {
        private final int width;
        private final int height;
        private final byte[] data;

        private Texture(int width, int height, byte[] data) {
            assert (data.length == width * height * 4);
            this.data = data;
            this.width = width;
            this.height = height;
        }

        private byte[] getData() {
            return this.data;
        }

        public Texture multiply(int color) {
            Texture newTex = this.copy();
            newTex.multiplyArea(color, 0, 0, this.width, this.height);
            return newTex;
        }

        public Texture copy() {
            return new Texture(this.width, this.height, (byte[])this.data.clone());
        }

        public void multiplyArea(int color, int x, int y, int areaWidth, int areaHeight) {
            float colorR = (float)(color >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(color >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(color & 0xFF) / 255.0f;
            for (int ity = y; ity < y + areaHeight; ++ity) {
                for (int itx = x; itx < x + areaWidth; ++itx) {
                    int i = (this.width * ity + itx) * 4;
                    float pixelR = (float)(this.data[i + 3] & 0xFF) / 255.0f;
                    float pixelG = (float)(this.data[i + 2] & 0xFF) / 255.0f;
                    float pixelB = (float)(this.data[i + 1] & 0xFF) / 255.0f;
                    this.data[i + 3] = (byte)(255.0f * colorR * pixelR);
                    this.data[i + 2] = (byte)(255.0f * colorG * pixelG);
                    this.data[i + 1] = (byte)(255.0f * colorB * pixelB);
                }
            }
        }

        private NativeImage getNativeImage() {
            NativeImage img = new NativeImage(this.width, this.height, false);
            for (int y = 0; y < img.func_195714_b(); ++y) {
                for (int x = 0; x < img.func_195702_a(); ++x) {
                    int value = (this.data[(y * img.func_195702_a() + x) * 4] & 0xFF) << 24;
                    int j = (this.data[(y * img.func_195702_a() + x) * 4 + 1] & 0xFF) << 16;
                    value |= j;
                    int k = (this.data[(y * img.func_195702_a() + x) * 4 + 2] & 0xFF) << 8;
                    value |= k;
                    byte l = this.data[(y * img.func_195702_a() + x) * 4 + 3];
                    img.func_195700_a(x, y, value |= l & 0xFF);
                }
            }
            return img;
        }
    }
}

