/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.main;

import deerangle.treemendous.config.TreemendousConfig;
import deerangle.treemendous.data.BlockStateProvider;
import deerangle.treemendous.data.BlockTagsProvider;
import deerangle.treemendous.data.ItemModelProvider;
import deerangle.treemendous.data.ItemTagsProvider;
import deerangle.treemendous.data.LanguageProvider;
import deerangle.treemendous.data.LootTableProvider;
import deerangle.treemendous.data.RecipeProvider;
import deerangle.treemendous.data.TextureProvider;
import deerangle.treemendous.main.ClientProxy;
import deerangle.treemendous.main.ExtraRegistry;
import deerangle.treemendous.main.Proxy;
import deerangle.treemendous.main.ServerProxy;
import deerangle.treemendous.tree.TreeRegistry;
import deerangle.treemendous.world.BiomeMaker;
import deerangle.treemendous.world.TreeWorldGenRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="treemendous")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Treemendous {
    public static final String MODID = "treemendous";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup ITEM_GROUP = new ItemGroup("treemendous"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)TreeRegistry.rainbow_eucalyptus.sapling_item.get());
        }
    };
    private final Proxy proxy = (Proxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public Treemendous() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, TreemendousConfig.CONFIG_SPEC);
        ExtraRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ExtraRegistry.TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ExtraRegistry.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        TreeRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TreeRegistry.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TreeRegistry.BIOMES.register(FMLJavaModLoadingContext.get().getModEventBus());
        BiomeMaker.BIOMES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        TreeWorldGenRegistry.register();
    }

    @SubscribeEvent
    public static void registerDataGens(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        boolean genTextures = Boolean.parseBoolean(System.getProperty("generate_textures"));
        if (genTextures) {
            if (event.includeClient()) {
                generator.func_200390_a((IDataProvider)new TextureProvider(generator, MODID, event.getExistingFileHelper()));
            }
        } else {
            if (event.includeServer()) {
                generator.func_200390_a((IDataProvider)new RecipeProvider(generator));
                generator.func_200390_a((IDataProvider)new LootTableProvider(generator, MODID));
                generator.func_200390_a((IDataProvider)new ItemTagsProvider(generator, MODID, event.getExistingFileHelper()));
                generator.func_200390_a((IDataProvider)new BlockTagsProvider(generator, MODID, event.getExistingFileHelper()));
            }
            if (event.includeClient()) {
                generator.func_200390_a((IDataProvider)new LanguageProvider(generator, MODID, "en_us"));
                generator.func_200390_a((IDataProvider)new ItemModelProvider(generator, MODID, event.getExistingFileHelper()));
                generator.func_200390_a((IDataProvider)new BlockStateProvider(generator, MODID, event.getExistingFileHelper()));
            }
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        this.proxy.clientSetup();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BiomeMaker.addBiomesToOverworld();
    }
}

