/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.tree;

import com.google.common.collect.ImmutableList;
import deerangle.treemendous.api.TreemendousBlocks;
import deerangle.treemendous.api.WoodColors;
import deerangle.treemendous.block.CustomStandingSignBlock;
import deerangle.treemendous.block.CustomWallSignBlock;
import deerangle.treemendous.block.StrippableBlock;
import deerangle.treemendous.entity.CustomBoatType;
import deerangle.treemendous.item.CustomBoatItem;
import deerangle.treemendous.main.Treemendous;
import deerangle.treemendous.tree.CustomTree;
import deerangle.treemendous.tree.ILeavesColor;
import deerangle.treemendous.world.BiomeMaker;
import deerangle.treemendous.world.BiomeSettings;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.trees.Tree;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.SignItem;
import net.minecraft.item.TallBlockItem;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class RegisteredTree {
    public final ITag.INamedTag<Item> logsItemTag;
    public final ITag.INamedTag<Block> logsBlockTag;
    public final RegistryObject<Block> planks;
    public final RegistryObject<Block> sapling;
    public final RegistryObject<Block> log;
    public final RegistryObject<Block> stripped_log;
    public final RegistryObject<Block> wood;
    public final RegistryObject<Block> stripped_wood;
    public final RegistryObject<Block> leaves;
    public final RegistryObject<Block> pressure_plate;
    public final RegistryObject<Block> trapdoor;
    public final RegistryObject<Block> potted_sapling;
    public final RegistryObject<Block> button;
    public final RegistryObject<Block> stairs;
    public final RegistryObject<Block> slab;
    public final RegistryObject<Block> fence_gate;
    public final RegistryObject<Block> fence;
    public final RegistryObject<Block> door;
    public final RegistryObject<Block> sign;
    public final RegistryObject<Block> wall_sign;
    public final RegistryObject<Item> planks_item;
    public final RegistryObject<Item> sapling_item;
    public final RegistryObject<Item> log_item;
    public final RegistryObject<Item> stripped_log_item;
    public final RegistryObject<Item> wood_item;
    public final RegistryObject<Item> stripped_wood_item;
    public final RegistryObject<Item> leaves_item;
    public final RegistryObject<Item> pressure_plate_item;
    public final RegistryObject<Item> trapdoor_item;
    public final RegistryObject<Item> button_item;
    public final RegistryObject<Item> stairs_item;
    public final RegistryObject<Item> slab_item;
    public final RegistryObject<Item> fence_gate_item;
    public final RegistryObject<Item> fence_item;
    public final RegistryObject<Item> door_item;
    public final RegistryObject<Item> sign_item;
    public final RegistryObject<Item> boat_item;
    private final ILeavesColor leavesColor;
    private final String name;
    private final String englishName;
    private final boolean inherited;
    private final WoodType woodType;
    private final CustomBoatType boatType;
    private final Supplier<IItemProvider> apple;
    private final Collection<RegistryKey<Biome>> biomes;
    private final Collection<RegistryKey<Biome>> frostyBiomes;
    private final int treeDensity;
    private final BiFunction<Block, Block, ConfiguredFeature<BaseTreeFeatureConfig, ?>> featureBiFunction;
    private ConfiguredFeature<BaseTreeFeatureConfig, ?> singleTreeFeature;
    private ConfiguredFeature<?, ?> treesFeature;
    private final int woodColor;
    private final int logColor;
    private final int plankType;

    RegisteredTree(DeferredRegister<Block> BLOCKS, DeferredRegister<Item> ITEMS, DeferredRegister<Biome> BIOMES, String name, String englishName, int woodColorVal, int barkColorVal, int plankType, ILeavesColor leavesColor, Supplier<IItemProvider> apple, RegisteredTree inherit, BiFunction<Block, Block, ConfiguredFeature<BaseTreeFeatureConfig, ?>> feature, BiomeSettings biomeSettings) {
        this.apple = apple;
        this.englishName = englishName;
        this.name = name;
        this.leavesColor = leavesColor;
        this.featureBiFunction = feature;
        this.singleTreeFeature = null;
        this.treeDensity = biomeSettings.getTreeDensity();
        this.woodColor = woodColorVal;
        this.logColor = barkColorVal;
        this.plankType = plankType;
        this.sapling = this.registerBlock(BLOCKS, name + "_sapling", () -> new SaplingBlock((Tree)new CustomTree(() -> this.singleTreeFeature), AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        this.leaves = this.registerBlock(BLOCKS, name + "_leaves", () -> new LeavesBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c).func_226896_b_().func_235827_a_(RegisteredTree::allowsSpawnOnLeaves).func_235842_b_(RegisteredTree::isntSolid).func_235847_c_(RegisteredTree::isntSolid)));
        this.potted_sapling = this.registerBlock(BLOCKS, "potted_" + name + "_sapling", () -> new FlowerPotBlock((Block)this.sapling.get(), AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200946_b().func_226896_b_()));
        this.sapling_item = ITEMS.register(name + "_sapling", () -> new BlockItem((Block)this.sapling.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
        this.leaves_item = ITEMS.register(name + "_leaves", () -> new BlockItem((Block)this.leaves.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
        BIOMES.register(name + "_forest", () -> {
            this.registerFeature();
            return BiomeMaker.makeForestBiome(0.1f, 0.2f, biomeSettings.getTemperature(), false, biomeSettings.isDry(), this.treesFeature);
        });
        BIOMES.register(name + "_forest_hills", () -> {
            this.registerFeature();
            return BiomeMaker.makeForestBiome(0.55f, 0.4f, biomeSettings.getTemperature(), false, biomeSettings.isDry(), this.treesFeature);
        });
        this.biomes = ImmutableList.of(BiomeMaker.makeBiomeKey(name + "_forest"), BiomeMaker.makeBiomeKey(name + "_forest_hills"));
        if (biomeSettings.isSnowy()) {
            BIOMES.register(name + "_forest_snow", () -> {
                this.registerFeature();
                return BiomeMaker.makeForestBiome(0.1f, 0.2f, biomeSettings.getTemperature(), true, false, this.treesFeature);
            });
            BIOMES.register(name + "_forest_hills_snow", () -> {
                this.registerFeature();
                return BiomeMaker.makeForestBiome(0.55f, 0.4f, biomeSettings.getTemperature(), true, false, this.treesFeature);
            });
            this.frostyBiomes = ImmutableList.of(BiomeMaker.makeBiomeKey(name + "_forest_snow"), BiomeMaker.makeBiomeKey(name + "_forest_hills_snow"));
        } else {
            this.frostyBiomes = ImmutableList.of();
        }
        if (inherit == null) {
            MaterialColor woodColor = WoodColors.getClosestMaterialColor(woodColorVal);
            MaterialColor barkColor = WoodColors.getClosestMaterialColor(barkColorVal);
            this.inherited = false;
            this.logsItemTag = ItemTags.func_199901_a((String)("treemendous:" + name + "_logs"));
            this.logsBlockTag = BlockTags.func_199894_a((String)("treemendous:" + name + "_logs"));
            this.woodType = new WoodType(name);
            WoodType.field_227044_g_.add(this.woodType);
            this.planks = this.registerBlock(BLOCKS, name + "_planks", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
            this.stripped_log = this.registerBlock(BLOCKS, "stripped_" + name + "_log", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_235836_a_((Material)Material.field_151575_d, p_235431_2_ -> woodColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
            this.log = this.registerBlock(BLOCKS, name + "_log", () -> new StrippableBlock(AbstractBlock.Properties.func_235836_a_((Material)Material.field_151575_d, blockState -> blockState.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? woodColor : barkColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a), (Supplier<Block>)this.stripped_log));
            this.stripped_wood = this.registerBlock(BLOCKS, "stripped_" + name + "_wood", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
            this.wood = this.registerBlock(BLOCKS, name + "_wood", () -> new StrippableBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)barkColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a), (Supplier<Block>)this.stripped_wood));
            this.sign = this.registerBlock(BLOCKS, name + "_sign", () -> new CustomStandingSignBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a), this.woodType));
            this.wall_sign = this.registerBlock(BLOCKS, name + "_wall_sign", () -> new CustomWallSignBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a).func_222379_b((Block)this.sign.get()), this.woodType));
            this.pressure_plate = this.registerBlock(BLOCKS, name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
            this.trapdoor = this.registerBlock(BLOCKS, name + "_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(RegisteredTree::neverAllowSpawn)));
            this.button = this.registerBlock(BLOCKS, name + "_button", () -> new WoodButtonBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
            this.stairs = this.registerBlock(BLOCKS, name + "_stairs", () -> new StairsBlock(() -> ((Block)this.planks.get()).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)this.planks.get()))));
            this.slab = this.registerBlock(BLOCKS, name + "_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
            this.fence_gate = this.registerBlock(BLOCKS, name + "_fence_gate", () -> new FenceGateBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
            this.fence = this.registerBlock(BLOCKS, name + "_fence", () -> new FenceBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
            this.door = this.registerBlock(BLOCKS, name + "_door", () -> new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
            this.planks_item = ITEMS.register(name + "_planks", () -> new BlockItem((Block)this.planks.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.log_item = ITEMS.register(name + "_log", () -> new BlockItem((Block)this.log.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.stripped_log_item = ITEMS.register("stripped_" + name + "_log", () -> new BlockItem((Block)this.stripped_log.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.stripped_wood_item = ITEMS.register("stripped_" + name + "_wood", () -> new BlockItem((Block)this.stripped_wood.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.wood_item = ITEMS.register(name + "_wood", () -> new BlockItem((Block)this.wood.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.slab_item = ITEMS.register(name + "_slab", () -> new BlockItem((Block)this.slab.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.pressure_plate_item = ITEMS.register(name + "_pressure_plate", () -> new BlockItem((Block)this.pressure_plate.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.fence_item = ITEMS.register(name + "_fence", () -> new BlockItem((Block)this.fence.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.trapdoor_item = ITEMS.register(name + "_trapdoor", () -> new BlockItem((Block)this.trapdoor.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.fence_gate_item = ITEMS.register(name + "_fence_gate", () -> new BlockItem((Block)this.fence_gate.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.button_item = ITEMS.register(name + "_button", () -> new BlockItem((Block)this.button.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.stairs_item = ITEMS.register(name + "_stairs", () -> new BlockItem((Block)this.stairs.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.door_item = ITEMS.register(name + "_door", () -> new TallBlockItem((Block)this.door.get(), new Item.Properties().func_200916_a(Treemendous.ITEM_GROUP)));
            this.sign_item = ITEMS.register(name + "_sign", () -> new SignItem(new Item.Properties().func_200917_a(16).func_200916_a(Treemendous.ITEM_GROUP), (Block)this.sign.get(), (Block)this.wall_sign.get()));
            this.boatType = CustomBoatType.register(name, new ResourceLocation("treemendous", name), () -> this.planks_item.get());
            this.boat_item = ITEMS.register(name + "_boat", () -> new CustomBoatItem(this.boatType, new Item.Properties().func_200917_a(1).func_200916_a(Treemendous.ITEM_GROUP)));
        } else {
            this.inherited = true;
            this.boatType = inherit.boatType;
            this.logsItemTag = inherit.logsItemTag;
            this.logsBlockTag = inherit.logsBlockTag;
            this.woodType = inherit.woodType;
            this.planks = inherit.planks;
            this.log = inherit.log;
            this.stripped_log = inherit.stripped_log;
            this.wood = inherit.wood;
            this.stripped_wood = inherit.stripped_wood;
            this.pressure_plate = inherit.pressure_plate;
            this.trapdoor = inherit.trapdoor;
            this.button = inherit.button;
            this.stairs = inherit.stairs;
            this.slab = inherit.slab;
            this.fence_gate = inherit.fence_gate;
            this.fence = inherit.fence;
            this.door = inherit.door;
            this.sign = inherit.sign;
            this.wall_sign = inherit.wall_sign;
            this.planks_item = inherit.planks_item;
            this.log_item = inherit.log_item;
            this.stripped_log_item = inherit.stripped_log_item;
            this.wood_item = inherit.wood_item;
            this.stripped_wood_item = inherit.stripped_wood_item;
            this.pressure_plate_item = inherit.pressure_plate_item;
            this.trapdoor_item = inherit.trapdoor_item;
            this.button_item = inherit.button_item;
            this.stairs_item = inherit.stairs_item;
            this.slab_item = inherit.slab_item;
            this.fence_gate_item = inherit.fence_gate_item;
            this.fence_item = inherit.fence_item;
            this.door_item = inherit.door_item;
            this.sign_item = inherit.sign_item;
            this.boat_item = inherit.boat_item;
        }
    }

    private static Boolean neverAllowSpawn(BlockState state, IBlockReader world, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    private static Boolean allowsSpawnOnLeaves(BlockState state, IBlockReader world, BlockPos pos, EntityType<?> entity) {
        return entity == EntityType.field_200781_U || entity == EntityType.field_200783_W;
    }

    private static boolean isntSolid(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    private RegistryObject<Block> registerBlock(DeferredRegister<Block> registry, String name, Supplier<Block> blockSupplier) {
        return registry.register(name, () -> {
            Block b = (Block)blockSupplier.get();
            try {
                this.storeInAPI(name, b);
            }
            catch (ReflectiveOperationException e) {
                Treemendous.LOGGER.error("Missing field in API: " + name);
            }
            return b;
        });
    }

    private void storeInAPI(String name, Block block) throws NoSuchFieldException, IllegalAccessException {
        Field f = TreemendousBlocks.class.getDeclaredField(name);
        f.set(null, block);
    }

    public ConfiguredFeature<BaseTreeFeatureConfig, ?> getSingleTreeFeature() {
        return this.singleTreeFeature;
    }

    public String getName() {
        return this.name;
    }

    public Collection<? extends RegistryKey<Biome>> getBiomes() {
        return this.biomes;
    }

    public Collection<? extends RegistryKey<Biome>> getFrostyBiomes() {
        return this.frostyBiomes;
    }

    public ILeavesColor getLeavesColor() {
        return this.leavesColor;
    }

    public void registerFeature() {
        if (this.singleTreeFeature == null) {
            this.singleTreeFeature = BiomeMaker.registerConfiguredFeature(this.name, this.featureBiFunction.apply((Block)this.log.get(), (Block)this.leaves.get()));
            this.treesFeature = BiomeMaker.registerConfiguredFeature("trees_" + this.name, this.singleTreeFeature.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(this.treeDensity, 0.1f, this.treeDensity / 4))));
        }
    }

    public boolean isNotInherited() {
        return !this.inherited;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public Supplier<IItemProvider> getApple() {
        return this.apple;
    }

    public int getWoodColor() {
        return this.woodColor;
    }

    public int getLogColor() {
        return this.logColor;
    }

    public int getPlankType() {
        return this.plankType;
    }
}

