/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.tree;

import deerangle.treemendous.main.ExtraRegistry;
import deerangle.treemendous.tree.RegisteredTree;
import deerangle.treemendous.tree.TreeBuilder;
import deerangle.treemendous.tree.TreeMaker;
import deerangle.treemendous.world.BiomeSettings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TreeRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"treemendous");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"treemendous");
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"treemendous");
    public static final List<RegisteredTree> TREES = new ArrayList<RegisteredTree>();
    public static final RegisteredTree douglas = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "douglas", "Douglas Fir").wood(12683385).log(10458000).leaves(7906909).feature((log, leaves) -> TreeMaker.makeNeedleTree(log, leaves, 1, 6, 2)).biome(new BiomeSettings.Builder().temperature(0.4f).snow()).build());
    public static final RegisteredTree pine = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "pine", "Pine").wood(12688237).log(9528652).leaves(4745538).feature(TreeMaker::makePineTree).biome(new BiomeSettings.Builder().temperature(0.4f).snow()).build());
    public static final RegisteredTree larch = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "larch", "Larch").wood(15379559).log(4865574).leaves(4745538).feature((log, leaves) -> TreeMaker.makeNeedleTree(log, leaves, 2, 7, 3)).biome(new BiomeSettings.Builder().temperature(0.4f).snow()).build());
    public static final RegisteredTree fir = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "fir", "Fir").wood(11436370).log(7300942).leaves(5935438).feature((log, leaves) -> TreeMaker.makeNeedleTree(log, leaves, 1, 6, 2)).biome(new BiomeSettings.Builder().temperature(0.4f).snow()).build());
    public static final RegisteredTree maple = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "maple", "Maple").wood(14457201).log(5255213).leaves(10213725).feature(TreeMaker::makeMapleTree).build());
    public static final RegisteredTree red_maple = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "red_maple", "Red Maple").inheritWood(maple).leaves(13399630).feature(TreeMaker::makeMapleTree).build());
    public static final RegisteredTree brown_maple = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "brown_maple", "Brown Maple").inheritWood(maple).leaves(14271069).feature(TreeMaker::makeMapleTree).build());
    public static final RegisteredTree japanese = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "japanese", "Japanese Maple").wood(15700101).log(5452850).leaves(11881526).feature(TreeMaker::makeLeafTree).build());
    public static final RegisteredTree beech = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "beech", "Beech").wood(9541491).log(9275507).leaves(11197289).feature((log, leaves) -> TreeMaker.makeRoundedLeafTree(log, leaves, 5, 2, 3)).build());
    public static final RegisteredTree cherry = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "cherry", "Cherry").wood(12800585).log(6902348).plankType(1).leaves(8501846).feature((log, leaves) -> TreeMaker.makeRoundedLeafTree(log, leaves, 6, 2, 4)).build());
    public static final RegisteredTree alder = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "alder", "Alder").wood(11582360).log(11578534).leaves(5806374).feature((log, leaves) -> TreeMaker.makeRoundedLeafTree(log, leaves, 5, 2, 2)).build());
    public static final RegisteredTree chestnut = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "chestnut", "Chestnut").wood(4661284).log(3745561).plankType(1).leaves(6986070).biome(new BiomeSettings.Builder().temperature(0.5f).snow()).feature((log, leaves) -> TreeMaker.makeSmallLeafTree(log, leaves, 5, 3, 2, 4)).build());
    public static final RegisteredTree plane = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "plane", "Plane").wood(5918292).log(6376282).leaves(9222230).plankType(1).biome(new BiomeSettings.Builder().temperature(0.8f)).feature(TreeMaker::makePlaneTree).build());
    public static final RegisteredTree ash = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "ash", "Ash").wood(15239756).log(4735808).leaves(7971656).plankType(1).feature((log, leaves) -> TreeMaker.makeAshTree(log, leaves, 7, 5, FeatureSpread.func_242253_a((int)1, (int)1), FeatureSpread.func_242253_a((int)4, (int)2), FeatureSpread.func_242253_a((int)2, (int)1))).build());
    public static final RegisteredTree linden = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "linden", "Linden").wood(6633515).log(13675603).leaves(7971656).plankType(2).feature(TreeMaker::makeFancyLeafTree).build());
    public static final RegisteredTree robinia = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "robinia", "Robinia").wood(9987336).log(9535327).leaves(9944912).feature(TreeMaker::makeAcaciaLeafTree).biome(new BiomeSettings.Builder().temperature(1.0f).dry()).build());
    public static final RegisteredTree willow = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "willow", "Willow").wood(16767909).log(4799561).leaves(7713620).feature(TreeMaker::makeWillowLeafTree).biome(new BiomeSettings.Builder().temperature(0.6f)).build());
    public static final RegisteredTree pomegranate = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "pomegranate", "Pomegranate").wood(13608572).log(12029568).leaves(8235848).feature((log, leaves) -> TreeMaker.makeAshTree(log, leaves, 4, 2, FeatureSpread.func_242253_a((int)0, (int)2), FeatureSpread.func_242253_a((int)3, (int)1), FeatureSpread.func_242253_a((int)2, (int)1))).apple(() -> ExtraRegistry.POMEGRANATE.get()).biome(new BiomeSettings.Builder().temperature(1.0f).dry()).build());
    public static final RegisteredTree magnolia = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "magnolia", "Magnolia").leaves(0xFFFFFF).feature((log, leaves) -> TreeMaker.makeCrossBlobTree(log, leaves, 6, 3, 2, 3)).build());
    public static final RegisteredTree walnut = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "walnut", "Walnut").wood(13733455).leaves(7053639).plankType(3).feature((log, leaves) -> TreeMaker.makeCrossRoundTree(log, leaves, 6, 3, 3, FeatureSpread.func_242253_a((int)1, (int)1), 3)).build());
    public static final RegisteredTree cedar = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "cedar", "Cedar").leaves(6201672).wood(16282749).log(3873040).plankType(1).feature((log, leaves) -> TreeMaker.makePointyTree(log, leaves, FeatureSpread.func_242252_a((int)37), FeatureSpread.func_242252_a((int)100), 1, 8, 5)).biome(new BiomeSettings.Builder().density(8).temperature(0.5f).snow()).build());
    public static final RegisteredTree poplar = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "poplar", "Poplar").leaves(8501846).wood(8296627).log(6978405).plankType(1).feature((log, leaves) -> TreeMaker.makeAshTree(log, leaves, 8, 6, FeatureSpread.func_242253_a((int)0, (int)1), FeatureSpread.func_242253_a((int)4, (int)2), FeatureSpread.func_242253_a((int)3, (int)1))).biome(new BiomeSettings.Builder().density(8)).build());
    public static final RegisteredTree elm = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "elm", "Elm").wood(14532445).log(4941121).leaves(11456866).plankType(2).feature(TreeMaker::makeBallTree).biome(new BiomeSettings.Builder().density(5)).build());
    public static final RegisteredTree rainbow_eucalyptus = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "rainbow_eucalyptus", "Rainbow Eucalyptus").leaves(blockPos -> blockPos != null ? Color.HSBtoRGB((float)(Math.pow((float)(blockPos.func_177958_n() % 32) / 32.0f, 2.0) + Math.pow((float)(blockPos.func_177956_o() % 32) / 32.0f, 2.0) + Math.pow((float)(blockPos.func_177952_p() % 32) / 32.0f, 2.0)), 0.7f, 0.8f) : Color.HSBtoRGB(0.0f, 1.0f, 1.0f)).feature(TreeMaker::makeBallTree).biome(new BiomeSettings.Builder().density(5)).build());
    public static final RegisteredTree juniper = TreeRegistry.registerTree(TreeBuilder.create(BLOCKS, ITEMS, BIOMES, "juniper", "Juniper").leaves(6204757).wood(3430748).plankType(1).log(9009525).feature((log, leaves) -> TreeMaker.makeJuniperTree(log, leaves, FeatureSpread.func_242252_a((int)42), FeatureSpread.func_242252_a((int)100), 2, 12, 6)).biome(new BiomeSettings.Builder().density(8).temperature(0.5f).snow()).build());

    private static RegisteredTree registerTree(RegisteredTree tree) {
        TREES.add(tree);
        return tree;
    }
}

