/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.tree.trunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import deerangle.treemendous.world.TreeWorldGenRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class CrossTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<CrossTrunkPlacer> CODEC = RecordCodecBuilder.create(placerInstance -> CrossTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)placerInstance).and((App)FeatureSpread.func_242254_a((int)0, (int)8, (int)8).fieldOf("branch").forGetter(placerInstance2 -> placerInstance2.branchLength)).and((App)FeatureSpread.func_242254_a((int)0, (int)8, (int)8).fieldOf("branch_offset").forGetter(placerInstance2 -> placerInstance2.branchTopOffset)).and((App)FeatureSpread.func_242254_a((int)-6, (int)5, (int)12).fieldOf("crown_offset").forGetter(placerInstance2 -> placerInstance2.crownOffset)).and((App)Codec.intRange((int)0, (int)1).fieldOf("leaves_at_end").forGetter(placerInstance2 -> placerInstance2.leavesAtEnd ? 1 : 0)).apply((Applicative)placerInstance, CrossTrunkPlacer::new));
    private final FeatureSpread branchLength;
    private final FeatureSpread branchTopOffset;
    private final FeatureSpread crownOffset;
    private final boolean leavesAtEnd;

    public CrossTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, FeatureSpread branchLength, FeatureSpread branchTopOffset, FeatureSpread crownOffset, boolean leavesAtEnd) {
        super(baseHeight, heightRandA, heightRandB);
        this.branchLength = branchLength;
        this.branchTopOffset = branchTopOffset;
        this.crownOffset = crownOffset;
        this.leavesAtEnd = leavesAtEnd;
    }

    public CrossTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, FeatureSpread branchLength, FeatureSpread branchTopOffset, FeatureSpread crownOffset, int leavesAtEnd) {
        this(baseHeight, heightRandA, heightRandB, branchLength, branchTopOffset, crownOffset, leavesAtEnd > 0);
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return TreeWorldGenRegistry.CROSS_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader generationReader, Random random, int height, BlockPos pos, Set<BlockPos> resultingBlocks, MutableBoundingBox boundingBox, BaseTreeFeatureConfig featureConfig) {
        CrossTrunkPlacer.func_236909_a_((IWorldGenerationReader)generationReader, (BlockPos)pos.func_177977_b());
        ArrayList<FoliagePlacer.Foliage> foliages = new ArrayList<FoliagePlacer.Foliage>();
        int crownHeightOffset = this.crownOffset.func_242259_a(random);
        int[] branchOffsets = new int[]{this.branchTopOffset.func_242259_a(random), this.branchTopOffset.func_242259_a(random), this.branchTopOffset.func_242259_a(random), this.branchTopOffset.func_242259_a(random)};
        for (int i = 0; i < height; ++i) {
            CrossTrunkPlacer.func_236911_a_((IWorldGenerationReader)generationReader, (Random)random, (BlockPos)pos.func_177981_b(i), resultingBlocks, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)featureConfig);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (i + 1 + branchOffsets[dir.func_176736_b()] != height) continue;
                int thisBranchLen = this.branchLength.func_242259_a(random);
                for (int branch = 1; branch <= thisBranchLen; ++branch) {
                    BlockPos p = pos.func_177981_b(i).func_177967_a(dir, branch);
                    CrossTrunkPlacer.func_236913_a_((IWorldWriter)generationReader, (BlockPos)p, (BlockState)((BlockState)featureConfig.field_227368_m_.func_225574_a_(random, p).func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)dir.func_176740_k())), (MutableBoundingBox)boundingBox);
                    if (branch != thisBranchLen || !this.leavesAtEnd) continue;
                    foliages.add(new FoliagePlacer.Foliage(p.func_177981_b(crownHeightOffset), 0, false));
                }
            }
        }
        foliages.add(new FoliagePlacer.Foliage(pos.func_177981_b(height + crownHeightOffset - 1), 0, false));
        return foliages;
    }
}

