/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.world;

import com.google.common.collect.ImmutableList;
import deerangle.treemendous.config.TreemendousConfig;
import deerangle.treemendous.tree.RegisteredTree;
import deerangle.treemendous.tree.TreeRegistry;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BiomeMaker {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"treemendous");
    public static final RegistryKey<Biome> MIXED_MAPLE_FOREST = BiomeMaker.makeBiomeKey("mixed_maple_forest");
    public static final RegistryKey<Biome> MIXED_FOREST = BiomeMaker.makeBiomeKey("mixed_forest");
    public static final RegistryKey<Biome> MIXED_FOREST_VANILLA = BiomeMaker.makeBiomeKey("mixed_forest_vanilla");
    public static final RegistryKey<Biome> NEEDLE_FOREST = BiomeMaker.makeBiomeKey("needle_forest");
    public static final RegistryKey<Biome> NEEDLE_FOREST_SNOW = BiomeMaker.makeBiomeKey("needle_forest_snow");
    private static ConfiguredFeature<?, ?> needleTreesFeature;

    public static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> registerConfiguredFeature(String key, ConfiguredFeature<FC, ?> configuredFeature) {
        return (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)("treemendous:" + key), configuredFeature);
    }

    public static Biome makeForestBiome(float depth, float scale, float temperature, boolean snowy, boolean dry, ConfiguredFeature<?, ?> tree) {
        MobSpawnInfo.Builder mobSpawnInfo = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)mobSpawnInfo);
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)mobSpawnInfo);
        BiomeGenerationSettings.Builder genSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)genSettings);
        genSettings.func_242516_a(StructureFeatures.field_244159_y);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243700_N((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)genSettings);
        genSettings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, tree);
        return new Biome.Builder().func_205415_a(snowy ? Biome.RainType.SNOW : (dry ? Biome.RainType.NONE : Biome.RainType.RAIN)).func_205419_a(Biome.Category.FOREST).func_205421_a(depth).func_205420_b(scale).func_205414_c(snowy ? -0.5f : temperature).func_205417_d(snowy ? 0.4f : (dry ? 0.0f : 0.8f)).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(snowy ? 4020182 : 4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(MathHelper.func_181758_c((float)0.6105556f, (float)0.5233333f, (float)1.0f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(mobSpawnInfo.func_242577_b()).func_242457_a(genSettings.func_242508_a()).func_242455_a();
    }

    public static void addBiomesToOverworld() {
        TreemendousConfig.BiomeSpawnRate spawnRateConfig = TreemendousConfig.biomeSpawnRateConfig;
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(MIXED_MAPLE_FOREST, ((Integer)spawnRateConfig.mixedMapleForestWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(MIXED_FOREST, ((Integer)spawnRateConfig.mixedForestWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(MIXED_FOREST_VANILLA, ((Integer)spawnRateConfig.mixedForestVanillaWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(NEEDLE_FOREST, ((Integer)spawnRateConfig.needleForestWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(NEEDLE_FOREST_SNOW, ((Integer)spawnRateConfig.needleForestSnowWeight.get()).intValue()));
        for (RegisteredTree tree : TreeRegistry.TREES) {
            for (RegistryKey<Biome> registryKey : tree.getFrostyBiomes()) {
                BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(registryKey, ((Integer)spawnRateConfig.treeWeights.get(registryKey).get()).intValue()));
            }
            for (RegistryKey<Biome> registryKey : tree.getBiomes()) {
                BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(registryKey, ((Integer)spawnRateConfig.treeWeights.get(registryKey).get()).intValue()));
            }
        }
    }

    public static RegistryKey<Biome> makeBiomeKey(String name) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("treemendous", name));
    }

    static {
        BIOMES.register("mixed_maple_forest", () -> {
            TreeRegistry.maple.registerFeature();
            TreeRegistry.red_maple.registerFeature();
            TreeRegistry.brown_maple.registerFeature();
            ConfiguredFeature treesFeature = BiomeMaker.registerConfiguredFeature("trees_mixed_maple", Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)TreeRegistry.red_maple.getSingleTreeFeature().func_227227_a_(0.3f), (Object)TreeRegistry.brown_maple.getSingleTreeFeature().func_227227_a_(0.3f)), TreeRegistry.maple.getSingleTreeFeature())).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 2))));
            return BiomeMaker.makeForestBiome(0.2f, 0.4f, 0.6f, false, false, treesFeature);
        });
        BIOMES.register("mixed_forest", () -> {
            for (RegisteredTree tree2 : TreeRegistry.TREES) {
                tree2.registerFeature();
            }
            ConfiguredFeature treesFeature = BiomeMaker.registerConfiguredFeature("trees_mixed", Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature(TreeRegistry.TREES.stream().map(tree -> tree::getSingleTreeFeature).collect(Collectors.toList()))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 2))));
            return BiomeMaker.makeForestBiome(0.2f, 0.4f, 0.6f, false, false, treesFeature);
        });
        BIOMES.register("mixed_forest_vanilla", () -> {
            for (RegisteredTree tree2 : TreeRegistry.TREES) {
                tree2.registerFeature();
            }
            ConfiguredFeature treesFeature = BiomeMaker.registerConfiguredFeature("trees_mixed_vanilla", Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature(Stream.concat(TreeRegistry.TREES.stream().map(tree -> tree::getSingleTreeFeature), ImmutableList.of((Object)Features.field_243862_bH, (Object)Features.field_243866_bL, (Object)Features.field_243864_bJ, (Object)Features.field_243868_bN, (Object)Features.field_243865_bK, (Object)Features.field_243863_bI).stream().map(tree -> () -> tree)).collect(Collectors.toList()))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 2))));
            return BiomeMaker.makeForestBiome(0.2f, 0.4f, 0.6f, false, false, treesFeature);
        });
        BIOMES.register("needle_forest", () -> {
            TreeRegistry.fir.registerFeature();
            TreeRegistry.douglas.registerFeature();
            TreeRegistry.larch.registerFeature();
            TreeRegistry.pine.registerFeature();
            TreeRegistry.cedar.registerFeature();
            TreeRegistry.juniper.registerFeature();
            if (needleTreesFeature == null) {
                needleTreesFeature = BiomeMaker.registerConfiguredFeature("trees_needle", Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of(TreeRegistry.fir::getSingleTreeFeature, TreeRegistry.douglas::getSingleTreeFeature, TreeRegistry.larch::getSingleTreeFeature, TreeRegistry.juniper::getSingleTreeFeature, TreeRegistry.cedar::getSingleTreeFeature, TreeRegistry.pine::getSingleTreeFeature, () -> Features.field_243866_bL, () -> Features.field_243867_bM))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 2))));
            }
            return BiomeMaker.makeForestBiome(0.2f, 0.4f, 0.4f, false, false, needleTreesFeature);
        });
        BIOMES.register("needle_forest_snow", () -> {
            TreeRegistry.fir.registerFeature();
            TreeRegistry.douglas.registerFeature();
            TreeRegistry.larch.registerFeature();
            TreeRegistry.pine.registerFeature();
            TreeRegistry.cedar.registerFeature();
            TreeRegistry.juniper.registerFeature();
            if (needleTreesFeature == null) {
                needleTreesFeature = BiomeMaker.registerConfiguredFeature("trees_needle", Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of(TreeRegistry.fir::getSingleTreeFeature, TreeRegistry.douglas::getSingleTreeFeature, TreeRegistry.larch::getSingleTreeFeature, TreeRegistry.juniper::getSingleTreeFeature, TreeRegistry.cedar::getSingleTreeFeature, TreeRegistry.pine::getSingleTreeFeature, () -> Features.field_243866_bL, () -> Features.field_243867_bM))).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 2))));
            }
            return BiomeMaker.makeForestBiome(0.2f, 0.4f, 0.4f, true, false, needleTreesFeature);
        });
    }
}

