/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.world;

public class BiomeSettings {
    private final float temperature;
    private final boolean snowy;
    private final boolean dry;
    private final int treeDensity;

    private BiomeSettings(float temp, boolean snowy, boolean dry, int treeDensity) {
        this.temperature = temp;
        this.snowy = snowy;
        this.dry = dry;
        this.treeDensity = treeDensity;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public boolean isSnowy() {
        return this.snowy;
    }

    public boolean isDry() {
        return this.dry;
    }

    public int getTreeDensity() {
        return this.treeDensity;
    }

    public static class Builder {
        private float temperature = 0.7f;
        private boolean snowy = false;
        private boolean dry = false;
        private int treeDensity = 10;

        public Builder temperature(float temp) {
            this.temperature = temp;
            return this;
        }

        public Builder snow() {
            this.snowy = true;
            return this;
        }

        public Builder dry() {
            this.snowy = false;
            this.dry = true;
            return this;
        }

        public BiomeSettings build() {
            return new BiomeSettings(this.temperature, this.snowy, this.dry, this.treeDensity);
        }

        public Builder density(int density) {
            this.treeDensity = density;
            return this;
        }
    }
}

