/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Items;
import net.minecraft.loot.AlternativesLootEntry;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.Alternative;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.Inverted;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLootTableProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;
    private final String modid;
    private final Map<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();

    public AbstractLootTableProvider(DataGenerator gen, String modid) {
        this.modid = modid;
        this.generator = gen;
    }

    protected abstract void addLootTables();

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.addLootTables();
        this.tables.forEach((location, table) -> {
            Path lootTablePath = this.generator.func_200391_b().resolve("data/" + location.func_110624_b() + "/loot_tables/" + location.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)lootTablePath);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't write loot table {}", (Object)lootTablePath, (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return "LootTables: " + this.modid;
    }

    private String name(Block block) {
        return block.getRegistryName().func_110623_a();
    }

    public void regularBlock(Block block) {
        this.regularBlock(this.name(block), block);
    }

    public void regularBlock(String name, Block block) {
        this.tables.put(new ResourceLocation(this.modid, "blocks/" + name), LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(SurvivesExplosion.func_215968_b()).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block))).func_216038_b());
    }

    public void slabBlock(SlabBlock slabBlock) {
        this.slabBlock(this.name((Block)slabBlock), slabBlock);
    }

    public void slabBlock(String name, SlabBlock slabBlock) {
        this.tables.put(new ResourceLocation(this.modid, "blocks/" + name), LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)slabBlock).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)slabBlock).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()))).func_216038_b());
    }

    public void doorBlock(DoorBlock doorBlock) {
        this.doorBlock(this.name((Block)doorBlock), doorBlock);
    }

    public void doorBlock(String name, DoorBlock doorBlock) {
        this.tables.put(new ResourceLocation(this.modid, "blocks/" + name), LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)doorBlock).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)doorBlock).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER)))).func_212840_b_(SurvivesExplosion.func_215968_b())).func_216038_b());
    }

    public void leavesBlock(LeavesBlock block, SaplingBlock saplingBlock, Supplier<IItemProvider> apple) {
        this.leavesBlock(this.name((Block)block), block, saplingBlock, apple);
    }

    public void leavesBlock(String name, LeavesBlock block, SaplingBlock sapling, Supplier<IItemProvider> apple) {
        LootTable.Builder builder = LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_((ILootCondition.IBuilder)Alternative.func_215960_a((ILootCondition.IBuilder[])new ILootCondition.IBuilder[]{MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ)), MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))))})), ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)sapling).func_212840_b_(SurvivesExplosion.func_215968_b())).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}))}))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151055_y).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b())).func_212840_b_(Inverted.func_215979_a((ILootCondition.IBuilder)Alternative.func_215960_a((ILootCondition.IBuilder[])new ILootCondition.IBuilder[]{MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ)), MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))))}))));
        if (apple != null) {
            builder.func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(Inverted.func_215979_a((ILootCondition.IBuilder)Alternative.func_215960_a((ILootCondition.IBuilder[])new ILootCondition.IBuilder[]{MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ)), MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))))}))).func_216045_a(((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)apple.get()).func_212840_b_(SurvivesExplosion.func_215968_b())).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
        }
        this.tables.put(new ResourceLocation(this.modid, "blocks/" + name), builder.func_216038_b());
    }
}

