/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.data;

import deerangle.treemendous.main.TreeRegistry;
import deerangle.treemendous.tree.RegisteredTree;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStateProvider
extends net.minecraftforge.client.model.generators.BlockStateProvider {
    private final String modid;

    public BlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
        this.modid = modid;
    }

    private String name(Block block) {
        return block.getRegistryName().func_110623_a();
    }

    public void woodBlock(RotatedPillarBlock block, Block textureBlock) {
        ResourceLocation tex = this.blockTexture(textureBlock);
        this.axisBlock(block, (ModelFile)this.models().cubeColumn(this.name((Block)block), tex, tex), (ModelFile)this.models().cubeColumnHorizontal(this.name((Block)block), tex, tex));
    }

    public void pressurePlate(PressurePlateBlock block, Block textureBlock) {
        ModelBuilder up = this.models().singleTexture(this.name((Block)block), new ResourceLocation("block/pressure_plate_up"), "texture", this.blockTexture(textureBlock));
        ModelBuilder down = this.models().singleTexture(this.name((Block)block) + "_down", new ResourceLocation("block/pressure_plate_down"), "texture", this.blockTexture(textureBlock));
        this.getVariantBuilder((Block)block).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)up)}).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)down)});
    }

    public void sapling(SaplingBlock block, FlowerPotBlock block2) {
        this.simpleBlock((Block)block, (ModelFile)this.models().cross(this.name((Block)block), this.blockTexture((Block)block)));
        this.simpleBlock((Block)block2, (ModelFile)this.models().singleTexture(this.name((Block)block2), new ResourceLocation("block/flower_pot_cross"), "plant", this.blockTexture((Block)block)));
    }

    public void leaves(LeavesBlock block) {
        this.simpleBlock((Block)block, (ModelFile)this.models().singleTexture(this.name((Block)block), new ResourceLocation("block/leaves"), "all", this.blockTexture((Block)block)));
    }

    public void buttonBlock(AbstractButtonBlock block, Block textureBlock) {
        ModelBuilder normal = this.models().singleTexture(this.name((Block)block), new ResourceLocation("block/button"), "texture", this.blockTexture(textureBlock));
        ModelBuilder pressed = this.models().singleTexture(this.name((Block)block) + "_pressed", new ResourceLocation("block/button_pressed"), "texture", this.blockTexture(textureBlock));
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            for (AttachFace f : AttachFace.values()) {
                int rotX = 0;
                switch (f) {
                    case CEILING: {
                        rotX = 180;
                        break;
                    }
                    case WALL: {
                        rotX = 90;
                    }
                }
                int rotY = 180;
                switch (d) {
                    case EAST: {
                        rotY = 90;
                        break;
                    }
                    case WEST: {
                        rotY = 270;
                        break;
                    }
                    case NORTH: {
                        rotY = 0;
                    }
                }
                ((VariantBlockStateBuilder)builder.partialState().with((Property)AbstractButtonBlock.field_196366_M, (Comparable)f).with((Property)AbstractButtonBlock.field_185512_D, (Comparable)d).with((Property)AbstractButtonBlock.field_176584_b, (Comparable)Boolean.valueOf(true)).modelForState().rotationX(rotX).rotationY(rotY).modelFile((ModelFile)pressed).addModel()).partialState().with((Property)AbstractButtonBlock.field_196366_M, (Comparable)f).with((Property)AbstractButtonBlock.field_185512_D, (Comparable)d).with((Property)AbstractButtonBlock.field_176584_b, (Comparable)Boolean.valueOf(false)).modelForState().rotationX(rotX).rotationY(rotY).modelFile((ModelFile)normal).addModel();
            }
        }
    }

    public void signBlock(StandingSignBlock sign, WallSignBlock wallSign, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)this.models().getBuilder(this.name((Block)sign))).texture("particle", texture);
        this.simpleBlock((Block)sign, (ModelFile)model);
        this.simpleBlock((Block)wallSign, (ModelFile)model);
    }

    public void basicBlockItem(Block block) {
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(new ResourceLocation(this.modid, this.name(block))));
    }

    public void basicBlockItem(Block block, String suffix) {
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(new ResourceLocation(this.modid, this.name(block) + suffix)));
    }

    public void generatedItem(IItemProvider block, ResourceLocation texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(block.func_199767_j().getRegistryName().func_110623_a())).parent((ModelFile)this.itemModels().getExistingFile(new ResourceLocation("item/generated")))).texture("layer0", texture);
    }

    public ResourceLocation itemTexture(IItemProvider block) {
        ResourceLocation name = block.func_199767_j().getRegistryName();
        return new ResourceLocation(name.func_110624_b(), "item/" + name.func_110623_a());
    }

    public void buttonItem(AbstractButtonBlock block, Block textureBlock) {
        ModelBuilder inventory = this.models().singleTexture(this.name((Block)block) + "_inventory", new ResourceLocation("block/button_inventory"), "texture", this.blockTexture(textureBlock));
        this.simpleBlockItem((Block)block, (ModelFile)inventory);
    }

    public void fenceBlockWithItem(FenceBlock block, ResourceLocation texture) {
        this.fenceBlock(block, texture);
        ModelBuilder inventory = this.models().singleTexture(this.name((Block)block) + "_inventory", new ResourceLocation("block/fence_inventory"), "texture", texture);
        this.simpleBlockItem((Block)block, (ModelFile)inventory);
    }

    protected void registerStatesAndModels() {
        for (RegisteredTree tree : TreeRegistry.trees) {
            this.sapling((SaplingBlock)tree.sapling.get(), (FlowerPotBlock)tree.potted_sapling.get());
            this.leaves((LeavesBlock)tree.leaves.get());
            this.generatedItem((IItemProvider)tree.sapling.get(), this.blockTexture((Block)tree.sapling.get()));
            this.basicBlockItem((Block)tree.leaves.get());
            if (!tree.isNotInherited()) continue;
            this.simpleBlock((Block)tree.planks.get());
            this.logBlock((RotatedPillarBlock)tree.log.get());
            this.logBlock((RotatedPillarBlock)tree.stripped_log.get());
            this.woodBlock((RotatedPillarBlock)tree.wood.get(), (Block)tree.log.get());
            this.woodBlock((RotatedPillarBlock)tree.stripped_wood.get(), (Block)tree.stripped_log.get());
            this.pressurePlate((PressurePlateBlock)tree.pressure_plate.get(), (Block)tree.planks.get());
            this.trapdoorBlock((TrapDoorBlock)tree.trapdoor.get(), this.blockTexture((Block)tree.trapdoor.get()), true);
            this.buttonBlock((AbstractButtonBlock)tree.button.get(), (Block)tree.planks.get());
            this.stairsBlock((StairsBlock)tree.stairs.get(), this.blockTexture((Block)tree.planks.get()));
            this.slabBlock((SlabBlock)tree.slab.get(), new ResourceLocation(this.modid, this.name((Block)tree.planks.get())), this.blockTexture((Block)tree.planks.get()));
            this.fenceGateBlock((FenceGateBlock)tree.fence_gate.get(), this.blockTexture((Block)tree.planks.get()));
            this.fenceBlockWithItem((FenceBlock)tree.fence.get(), this.blockTexture((Block)tree.planks.get()));
            String door_name = this.blockTexture((Block)tree.door.get()).toString();
            this.doorBlock((DoorBlock)tree.door.get(), new ResourceLocation(door_name + "_bottom"), new ResourceLocation(door_name + "_top"));
            this.signBlock((StandingSignBlock)tree.sign.get(), (WallSignBlock)tree.wall_sign.get(), this.blockTexture((Block)tree.planks.get()));
            this.basicBlockItem((Block)tree.planks.get());
            this.basicBlockItem((Block)tree.log.get());
            this.basicBlockItem((Block)tree.stripped_log.get());
            this.basicBlockItem((Block)tree.wood.get());
            this.basicBlockItem((Block)tree.stripped_wood.get());
            this.basicBlockItem((Block)tree.pressure_plate.get());
            this.basicBlockItem((Block)tree.trapdoor.get(), "_bottom");
            this.buttonItem((AbstractButtonBlock)tree.button.get(), (Block)tree.planks.get());
            this.basicBlockItem((Block)tree.stairs.get());
            this.basicBlockItem((Block)tree.slab.get());
            this.basicBlockItem((Block)tree.fence_gate.get());
            this.generatedItem((IItemProvider)tree.door.get(), this.itemTexture((IItemProvider)tree.door.get()));
            this.generatedItem((IItemProvider)tree.sign_item.get(), this.itemTexture((IItemProvider)tree.sign_item.get()));
            this.generatedItem((IItemProvider)tree.boat_item.get(), this.itemTexture((IItemProvider)tree.boat_item.get()));
        }
    }
}

