/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.main;

import com.mojang.serialization.Codec;
import deerangle.treemendous.block.entity.CustomSignTileEntity;
import deerangle.treemendous.entity.CustomBoatEntity;
import deerangle.treemendous.main.ExtraRegistry;
import deerangle.treemendous.tree.RegisteredTree;
import deerangle.treemendous.tree.TreeMaker;
import deerangle.treemendous.tree.foliage.BallFoliagePlacer;
import deerangle.treemendous.tree.foliage.ParabolaFoliagePlacer;
import deerangle.treemendous.tree.foliage.PointyFoliagePlacer;
import deerangle.treemendous.tree.foliage.RoundedFoliagePlacer;
import deerangle.treemendous.tree.foliage.WillowFoliagePlacer;
import deerangle.treemendous.tree.trunk.AshTrunkPlacer;
import deerangle.treemendous.tree.trunk.CrossTrunkPlacer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TreeRegistry {
    public static final FoliagePlacerType<RoundedFoliagePlacer> ROUNDED_FOLIAGE_PLACER = TreeRegistry.registerFoliagePlacerType("rounded_foliage_placer", RoundedFoliagePlacer.CODEC);
    public static final FoliagePlacerType<WillowFoliagePlacer> WILLOW_FOLIAGE_PLACER = TreeRegistry.registerFoliagePlacerType("willow_foliage_placer", WillowFoliagePlacer.CODEC);
    public static final FoliagePlacerType<ParabolaFoliagePlacer> PARABOLA_FOLIAGE_PLACER = TreeRegistry.registerFoliagePlacerType("parabola_foliage_placer", ParabolaFoliagePlacer.CODEC);
    public static final FoliagePlacerType<PointyFoliagePlacer> POINTY_FOLIAGE_PLACER = TreeRegistry.registerFoliagePlacerType("pointy_foliage_placer", PointyFoliagePlacer.CODEC);
    public static final FoliagePlacerType<BallFoliagePlacer> BALL_FOLIAGE_PLACER = TreeRegistry.registerFoliagePlacerType("ball_foliage_placer", BallFoliagePlacer.CODEC);
    public static final TrunkPlacerType<CrossTrunkPlacer> CROSS_TRUNK_PLACER = TreeRegistry.registerTrunkPlacerType("cross_trunk_placer", CrossTrunkPlacer.CODEC);
    public static final TrunkPlacerType<AshTrunkPlacer> ASH_TRUNK_PLACER = TreeRegistry.registerTrunkPlacerType("ash_trunk_placer", AshTrunkPlacer.CODEC);
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"treemendous");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"treemendous");
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"treemendous");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"treemendous");
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"treemendous");
    public static final List<RegisteredTree> trees = new ArrayList<RegisteredTree>();
    public static final RegisteredTree douglas = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "douglas", "Douglas Fir").wood(MaterialColor.field_151664_l).log(MaterialColor.field_151665_m).leaves(7906909).feature((log, leaves) -> TreeMaker.makeNeedleTree(log, leaves, 1, 6, 2)).biome(new RegisteredTree.BiomeSettings.Builder().temperature(0.4f).snow()).build());
    public static final RegisteredTree pine = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "pine", "Pine").wood(MaterialColor.field_151658_d).leaves(4745538).feature(TreeMaker::makePineTree).biome(new RegisteredTree.BiomeSettings.Builder().temperature(0.4f).snow()).build());
    public static final RegisteredTree larch = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "larch", "Larch").leaves(4745538).feature((log, leaves) -> TreeMaker.makeNeedleTree(log, leaves, 2, 7, 3)).biome(new RegisteredTree.BiomeSettings.Builder().temperature(0.4f).snow()).build());
    public static final RegisteredTree fir = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "fir", "Fir").log(MaterialColor.field_151654_J).leaves(5935438).feature((log, leaves) -> TreeMaker.makeNeedleTree(log, leaves, 1, 6, 2)).biome(new RegisteredTree.BiomeSettings.Builder().temperature(0.4f).snow()).build());
    public static final RegisteredTree maple = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "maple", "Maple").wood(MaterialColor.field_151664_l).leaves(10213725).feature(TreeMaker::makeMapleTree).build());
    public static final RegisteredTree red_maple = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "red_maple", "Red Maple").inheritWood(maple).wood(MaterialColor.field_151664_l).leaves(13399630).feature(TreeMaker::makeMapleTree).build());
    public static final RegisteredTree brown_maple = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "brown_maple", "Brown Maple").inheritWood(maple).wood(MaterialColor.field_151664_l).leaves(14271069).feature(TreeMaker::makeMapleTree).build());
    public static final RegisteredTree japanese = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "japanese", "Japanese Maple").wood(MaterialColor.field_151671_v).leaves(11881526).feature(TreeMaker::makeLeafTree).build());
    public static final RegisteredTree beech = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "beech", "Beech").wood(MaterialColor.field_151651_C).log(MaterialColor.field_151665_m).leaves(11197289).feature((log, leaves) -> TreeMaker.makeRoundedLeafTree(log, leaves, 5, 2, 3)).build());
    public static final RegisteredTree cherry = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "cherry", "Cherry").wood(MaterialColor.field_151645_D).log(MaterialColor.field_151665_m).leaves(8501846).feature((log, leaves) -> TreeMaker.makeRoundedLeafTree(log, leaves, 6, 2, 4)).build());
    public static final RegisteredTree alder = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "alder", "Alder").wood(MaterialColor.field_151665_m).log(MaterialColor.field_151665_m).leaves(5806374).feature((log, leaves) -> TreeMaker.makeRoundedLeafTree(log, leaves, 5, 2, 2)).build());
    public static final RegisteredTree chestnut = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "chestnut", "Chestnut").wood(MaterialColor.field_151650_B).log(MaterialColor.field_151654_J).leaves(6986070).biome(new RegisteredTree.BiomeSettings.Builder().temperature(0.5f).snow()).feature((log, leaves) -> TreeMaker.makeSmallLeafTree(log, leaves, 5, 3, 2, 4)).build());
    public static final RegisteredTree plane = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "plane", "Plane").wood(MaterialColor.field_193570_V).log(MaterialColor.field_151678_z).leaves(9222230).biome(new RegisteredTree.BiomeSettings.Builder().temperature(0.8f)).feature(TreeMaker::makePlaneTree).build());
    public static final RegisteredTree ash = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "ash", "Ash").wood(MaterialColor.field_193562_N).log(MaterialColor.field_151646_E).leaves(7971656).feature((log, leaves) -> TreeMaker.makeAshTree(log, leaves, 7, 5, FeatureSpread.func_242253_a((int)1, (int)1), FeatureSpread.func_242253_a((int)4, (int)2), FeatureSpread.func_242253_a((int)2, (int)1))).build());
    public static final RegisteredTree linden = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "linden", "Linden").wood(MaterialColor.field_193562_N).log(MaterialColor.field_151646_E).leaves(7971656).feature(TreeMaker::makeFancyLeafTree).build());
    public static final RegisteredTree robinia = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "robinia", "Robinia").wood(MaterialColor.field_151647_F).leaves(9944912).feature(TreeMaker::makeAcaciaLeafTree).biome(new RegisteredTree.BiomeSettings.Builder().temperature(1.0f).dry()).build());
    public static final RegisteredTree willow = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "willow", "Willow").log(MaterialColor.field_151646_E).wood(MaterialColor.field_193561_M).leaves(7713620).feature(TreeMaker::makeWillowLeafTree).biome(new RegisteredTree.BiomeSettings.Builder().temperature(0.6f)).build());
    public static final RegisteredTree pomegranate = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "pomegranate", "Pomegranate").log(MaterialColor.field_193568_T).wood(MaterialColor.field_193561_M).leaves(8235848).feature((log, leaves) -> TreeMaker.makeAshTree(log, leaves, 4, 2, FeatureSpread.func_242253_a((int)0, (int)2), FeatureSpread.func_242253_a((int)3, (int)1), FeatureSpread.func_242253_a((int)2, (int)1))).apple(() -> ExtraRegistry.POMEGRANATE.get()).biome(new RegisteredTree.BiomeSettings.Builder().temperature(1.0f).dry()).build());
    public static final RegisteredTree magnolia = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "magnolia", "Magnolia").log(MaterialColor.field_197656_x).wood(MaterialColor.field_151650_B).leaves(0xFFFFFF).feature((log, leaves) -> TreeMaker.makeCrossBlobTree(log, leaves, 6, 3, 2, 3)).build());
    public static final RegisteredTree walnut = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "walnut", "Walnut").leaves(7053639).feature((log, leaves) -> TreeMaker.makeCrossRoundTree(log, leaves, 6, 3, 3, FeatureSpread.func_242253_a((int)1, (int)1), 3)).build());
    public static final RegisteredTree cedar = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "cedar", "Cedar").leaves(6201672).wood(MaterialColor.field_151671_v).feature((log, leaves) -> TreeMaker.makePointyTree(log, leaves, FeatureSpread.func_242252_a((int)37), FeatureSpread.func_242252_a((int)100), 1, 8, 5)).biome(new RegisteredTree.BiomeSettings.Builder().density(8).temperature(0.5f).snow()).build());
    public static final RegisteredTree poplar = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "poplar", "Poplar").leaves(8501846).wood(MaterialColor.field_151671_v).feature((log, leaves) -> TreeMaker.makeAshTree(log, leaves, 8, 6, FeatureSpread.func_242253_a((int)0, (int)1), FeatureSpread.func_242253_a((int)4, (int)2), FeatureSpread.func_242253_a((int)3, (int)1))).biome(new RegisteredTree.BiomeSettings.Builder().density(8)).build());
    public static final RegisteredTree elm = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "elm", "Elm").leaves(11456866).feature(TreeMaker::makeBallTree).biome(new RegisteredTree.BiomeSettings.Builder().density(5)).build());
    public static final RegisteredTree rainbow_eucalyptus = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "rainbow_eucalyptus", "Rainbow Eucalyptus").leaves(blockPos -> blockPos != null ? Color.HSBtoRGB((float)(Math.pow((float)(blockPos.func_177958_n() % 32) / 32.0f, 2.0) + Math.pow((float)(blockPos.func_177956_o() % 32) / 32.0f, 2.0) + Math.pow((float)(blockPos.func_177952_p() % 32) / 32.0f, 2.0)), 0.7f, 0.8f) : Color.HSBtoRGB(0.0f, 1.0f, 1.0f)).feature(TreeMaker::makeBallTree).biome(new RegisteredTree.BiomeSettings.Builder().density(5)).build());
    public static final RegisteredTree juniper = TreeRegistry.registerTree(RegisteredTree.Builder.create(BLOCKS, ITEMS, BIOMES, "juniper", "Juniper").leaves(6204757).wood(MaterialColor.field_151679_y).feature((log, leaves) -> TreeMaker.makeJuniperTree(log, leaves, FeatureSpread.func_242252_a((int)42), FeatureSpread.func_242252_a((int)100), 2, 12, 6)).biome(new RegisteredTree.BiomeSettings.Builder().density(8).temperature(0.5f).snow()).build());
    public static final RegistryObject<TileEntityType<CustomSignTileEntity>> SIGN = TILE_ENTITIES.register("sign", () -> {
        Block[] signs = new Block[trees.size() * 2];
        for (int i = 0; i < trees.size(); ++i) {
            signs[2 * i] = (Block)TreeRegistry.trees.get((int)i).sign.get();
            signs[2 * i + 1] = (Block)TreeRegistry.trees.get((int)i).wall_sign.get();
        }
        return TileEntityType.Builder.func_223042_a(CustomSignTileEntity::new, (Block[])signs).func_206865_a(null);
    });
    public static final RegistryObject<EntityType<CustomBoatEntity>> BOAT = ENTITIES.register("boat", () -> EntityType.Builder.func_220322_a(CustomBoatEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.375f, 0.5625f).func_233606_a_(10).setCustomClientFactory((spawnEntity, world) -> new CustomBoatEntity((World)world)).func_206830_a("boat"));

    private static <P extends FoliagePlacer> FoliagePlacerType<P> registerFoliagePlacerType(String name, Codec<P> codec) {
        return (FoliagePlacerType)Registry.func_218325_a((Registry)Registry.field_229389_v_, (String)("treemendous:" + name), (Object)new FoliagePlacerType(codec));
    }

    private static <P extends AbstractTrunkPlacer> TrunkPlacerType<P> registerTrunkPlacerType(String name, Codec<P> codec) {
        return (TrunkPlacerType)Registry.func_218325_a((Registry)Registry.field_239701_aw_, (String)("treemendous:" + name), (Object)new TrunkPlacerType(codec));
    }

    private static RegisteredTree registerTree(RegisteredTree tree) {
        trees.add(tree);
        return tree;
    }
}

