/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.tree;

import com.google.common.collect.ImmutableList;
import deerangle.treemendous.block.CustomStandingSignBlock;
import deerangle.treemendous.block.CustomWallSignBlock;
import deerangle.treemendous.block.StrippableBlock;
import deerangle.treemendous.entity.CustomBoatType;
import deerangle.treemendous.item.CustomBoatItem;
import deerangle.treemendous.tree.BiomeMaker;
import deerangle.treemendous.tree.CustomTree;
import deerangle.treemendous.tree.ILeavesColor;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.trees.Tree;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SignItem;
import net.minecraft.item.TallBlockItem;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class RegisteredTree {
    private final ILeavesColor leavesColor;
    private final String name;
    private final String englishName;
    private final boolean inherited;
    public final RegistryObject<Block> planks;
    public final RegistryObject<Block> sapling;
    public final RegistryObject<Block> log;
    public final RegistryObject<Block> stripped_log;
    public final RegistryObject<Block> wood;
    public final RegistryObject<Block> stripped_wood;
    public final RegistryObject<Block> leaves;
    public final RegistryObject<Block> pressure_plate;
    public final RegistryObject<Block> trapdoor;
    public final RegistryObject<Block> potted_sapling;
    public final RegistryObject<Block> button;
    public final RegistryObject<Block> stairs;
    public final RegistryObject<Block> slab;
    public final RegistryObject<Block> fence_gate;
    public final RegistryObject<Block> fence;
    public final RegistryObject<Block> door;
    public final RegistryObject<Block> sign;
    public final RegistryObject<Block> wall_sign;
    public final RegistryObject<Item> planks_item;
    public final RegistryObject<Item> sapling_item;
    public final RegistryObject<Item> log_item;
    public final RegistryObject<Item> stripped_log_item;
    public final RegistryObject<Item> wood_item;
    public final RegistryObject<Item> stripped_wood_item;
    public final RegistryObject<Item> leaves_item;
    public final RegistryObject<Item> pressure_plate_item;
    public final RegistryObject<Item> trapdoor_item;
    public final RegistryObject<Item> button_item;
    public final RegistryObject<Item> stairs_item;
    public final RegistryObject<Item> slab_item;
    public final RegistryObject<Item> fence_gate_item;
    public final RegistryObject<Item> fence_item;
    public final RegistryObject<Item> door_item;
    public final RegistryObject<Item> sign_item;
    public final RegistryObject<Item> boat_item;
    private final Supplier<IItemProvider> apple;
    public final ITag.INamedTag<Item> logsItemTag;
    public final ITag.INamedTag<Block> logsBlockTag;
    private final WoodType woodType;
    private final CustomBoatType boatType;
    private final BiFunction<Block, Block, ConfiguredFeature<BaseTreeFeatureConfig, ?>> featureBiFunction;
    private ConfiguredFeature<BaseTreeFeatureConfig, ?> singleTreeFeature;
    private ConfiguredFeature<?, ?> treesFeature;
    private final Collection<RegistryKey<Biome>> biomes;
    private final Collection<RegistryKey<Biome>> frostyBiomes;
    private final int treeDensity;

    private static Boolean neverAllowSpawn(BlockState p_235427_0_, IBlockReader p_235427_1_, BlockPos p_235427_2_, EntityType<?> p_235427_3_) {
        return false;
    }

    private static Boolean allowsSpawnOnLeaves(BlockState p_235441_0_, IBlockReader p_235441_1_, BlockPos p_235441_2_, EntityType<?> p_235441_3_) {
        return p_235441_3_ == EntityType.field_200781_U || p_235441_3_ == EntityType.field_200783_W;
    }

    private static boolean isntSolid(BlockState p_235436_0_, IBlockReader p_235436_1_, BlockPos p_235436_2_) {
        return false;
    }

    private RegisteredTree(DeferredRegister<Block> BLOCKS, DeferredRegister<Item> ITEMS, DeferredRegister<Biome> BIOMES, String name, String englishName, MaterialColor woodColor, MaterialColor barkColor, ILeavesColor leavesColor, Supplier<IItemProvider> apple, RegisteredTree inherit, BiFunction<Block, Block, ConfiguredFeature<BaseTreeFeatureConfig, ?>> feature, BiomeSettings biomeSettings) {
        this.apple = apple;
        this.englishName = englishName;
        this.name = name;
        this.leavesColor = leavesColor;
        this.featureBiFunction = feature;
        this.singleTreeFeature = null;
        this.treeDensity = biomeSettings.getTreeDensity();
        this.sapling = BLOCKS.register(name + "_sapling", () -> new SaplingBlock((Tree)new CustomTree(() -> this.singleTreeFeature), AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        this.leaves = BLOCKS.register(name + "_leaves", () -> new LeavesBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c).func_226896_b_().func_235827_a_(RegisteredTree::allowsSpawnOnLeaves).func_235842_b_(RegisteredTree::isntSolid).func_235847_c_(RegisteredTree::isntSolid)));
        this.potted_sapling = BLOCKS.register("potted_" + name + "_sapling", () -> new FlowerPotBlock((Block)this.sapling.get(), AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200946_b().func_226896_b_()));
        this.sapling_item = ITEMS.register(name + "_sapling", () -> new BlockItem((Block)this.sapling.get(), new Item.Properties().func_200916_a(ItemGroup.field_78031_c)));
        this.leaves_item = ITEMS.register(name + "_leaves", () -> new BlockItem((Block)this.leaves.get(), new Item.Properties().func_200916_a(ItemGroup.field_78031_c)));
        BIOMES.register(name + "_forest", () -> {
            this.registerFeature();
            return BiomeMaker.makeForestBiome(0.1f, 0.2f, biomeSettings.getTemperature(), false, biomeSettings.isDry(), new MobSpawnInfo.Builder(), this.treesFeature);
        });
        BIOMES.register(name + "_forest_hills", () -> {
            this.registerFeature();
            return BiomeMaker.makeForestBiome(0.55f, 0.4f, biomeSettings.getTemperature(), false, biomeSettings.isDry(), new MobSpawnInfo.Builder(), this.treesFeature);
        });
        this.biomes = ImmutableList.of(BiomeMaker.makeBiomeKey(name + "_forest"), BiomeMaker.makeBiomeKey(name + "_forest_hills"));
        if (biomeSettings.isSnowy()) {
            BIOMES.register(name + "_forest_snow", () -> {
                this.registerFeature();
                return BiomeMaker.makeForestBiome(0.1f, 0.2f, biomeSettings.getTemperature(), true, false, new MobSpawnInfo.Builder(), this.treesFeature);
            });
            BIOMES.register(name + "_forest_hills_snow", () -> {
                this.registerFeature();
                return BiomeMaker.makeForestBiome(0.55f, 0.4f, biomeSettings.getTemperature(), true, false, new MobSpawnInfo.Builder(), this.treesFeature);
            });
            this.frostyBiomes = ImmutableList.of(BiomeMaker.makeBiomeKey(name + "_forest_snow"), BiomeMaker.makeBiomeKey(name + "_forest_hills_snow"));
        } else {
            this.frostyBiomes = ImmutableList.of();
        }
        if (inherit == null) {
            this.inherited = false;
            this.logsItemTag = ItemTags.func_199901_a((String)("treemendous:" + name + "_logs"));
            this.logsBlockTag = BlockTags.func_199894_a((String)("treemendous:" + name + "_logs"));
            this.woodType = new WoodType(name);
            WoodType.field_227044_g_.add(this.woodType);
            this.planks = BLOCKS.register(name + "_planks", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
            this.stripped_log = BLOCKS.register("stripped_" + name + "_log", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_235836_a_((Material)Material.field_151575_d, p_235431_2_ -> woodColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
            this.log = BLOCKS.register(name + "_log", () -> new StrippableBlock(AbstractBlock.Properties.func_235836_a_((Material)Material.field_151575_d, blockState -> blockState.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? woodColor : barkColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a), (Supplier<Block>)this.stripped_log));
            this.stripped_wood = BLOCKS.register("stripped_" + name + "_wood", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
            this.wood = BLOCKS.register(name + "_wood", () -> new StrippableBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)barkColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a), (Supplier<Block>)this.stripped_wood));
            this.sign = BLOCKS.register(name + "_sign", () -> new CustomStandingSignBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a), this.woodType));
            this.wall_sign = BLOCKS.register(name + "_wall_sign", () -> new CustomWallSignBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a).func_222379_b((Block)this.sign.get()), this.woodType));
            this.pressure_plate = BLOCKS.register(name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
            this.trapdoor = BLOCKS.register(name + "_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(RegisteredTree::neverAllowSpawn)));
            this.button = BLOCKS.register(name + "_button", () -> new WoodButtonBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
            this.stairs = BLOCKS.register(name + "_stairs", () -> new StairsBlock(() -> ((Block)this.planks.get()).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)this.planks.get()))));
            this.slab = BLOCKS.register(name + "_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
            this.fence_gate = BLOCKS.register(name + "_fence_gate", () -> new FenceGateBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
            this.fence = BLOCKS.register(name + "_fence", () -> new FenceBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
            this.door = BLOCKS.register(name + "_door", () -> new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
            this.planks_item = ITEMS.register(name + "_planks", () -> new BlockItem((Block)this.planks.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
            this.log_item = ITEMS.register(name + "_log", () -> new BlockItem((Block)this.log.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
            this.stripped_log_item = ITEMS.register("stripped_" + name + "_log", () -> new BlockItem((Block)this.stripped_log.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
            this.stripped_wood_item = ITEMS.register("stripped_" + name + "_wood", () -> new BlockItem((Block)this.stripped_wood.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
            this.wood_item = ITEMS.register(name + "_wood", () -> new BlockItem((Block)this.wood.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
            this.slab_item = ITEMS.register(name + "_slab", () -> new BlockItem((Block)this.slab.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
            this.pressure_plate_item = ITEMS.register(name + "_pressure_plate", () -> new BlockItem((Block)this.pressure_plate.get(), new Item.Properties().func_200916_a(ItemGroup.field_78028_d)));
            this.fence_item = ITEMS.register(name + "_fence", () -> new BlockItem((Block)this.fence.get(), new Item.Properties().func_200916_a(ItemGroup.field_78031_c)));
            this.trapdoor_item = ITEMS.register(name + "_trapdoor", () -> new BlockItem((Block)this.trapdoor.get(), new Item.Properties().func_200916_a(ItemGroup.field_78028_d)));
            this.fence_gate_item = ITEMS.register(name + "_fence_gate", () -> new BlockItem((Block)this.fence_gate.get(), new Item.Properties().func_200916_a(ItemGroup.field_78028_d)));
            this.button_item = ITEMS.register(name + "_button", () -> new BlockItem((Block)this.button.get(), new Item.Properties().func_200916_a(ItemGroup.field_78028_d)));
            this.stairs_item = ITEMS.register(name + "_stairs", () -> new BlockItem((Block)this.stairs.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
            this.door_item = ITEMS.register(name + "_door", () -> new TallBlockItem((Block)this.door.get(), new Item.Properties().func_200916_a(ItemGroup.field_78028_d)));
            this.sign_item = ITEMS.register(name + "_sign", () -> new SignItem(new Item.Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c), (Block)this.sign.get(), (Block)this.wall_sign.get()));
            this.boatType = CustomBoatType.register(name, new ResourceLocation("treemendous", name), () -> this.planks_item.get());
            this.boat_item = ITEMS.register(name + "_boat", () -> new CustomBoatItem(this.boatType, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e)));
        } else {
            this.inherited = true;
            this.boatType = inherit.boatType;
            this.logsItemTag = inherit.logsItemTag;
            this.logsBlockTag = inherit.logsBlockTag;
            this.woodType = inherit.woodType;
            this.planks = inherit.planks;
            this.log = inherit.log;
            this.stripped_log = inherit.stripped_log;
            this.wood = inherit.wood;
            this.stripped_wood = inherit.stripped_wood;
            this.pressure_plate = inherit.pressure_plate;
            this.trapdoor = inherit.trapdoor;
            this.button = inherit.button;
            this.stairs = inherit.stairs;
            this.slab = inherit.slab;
            this.fence_gate = inherit.fence_gate;
            this.fence = inherit.fence;
            this.door = inherit.door;
            this.sign = inherit.sign;
            this.wall_sign = inherit.wall_sign;
            this.planks_item = inherit.planks_item;
            this.log_item = inherit.log_item;
            this.stripped_log_item = inherit.stripped_log_item;
            this.wood_item = inherit.wood_item;
            this.stripped_wood_item = inherit.stripped_wood_item;
            this.pressure_plate_item = inherit.pressure_plate_item;
            this.trapdoor_item = inherit.trapdoor_item;
            this.button_item = inherit.button_item;
            this.stairs_item = inherit.stairs_item;
            this.slab_item = inherit.slab_item;
            this.fence_gate_item = inherit.fence_gate_item;
            this.fence_item = inherit.fence_item;
            this.door_item = inherit.door_item;
            this.sign_item = inherit.sign_item;
            this.boat_item = inherit.boat_item;
        }
    }

    public ConfiguredFeature<BaseTreeFeatureConfig, ?> getSingleTreeFeature() {
        return this.singleTreeFeature;
    }

    public String getName() {
        return this.name;
    }

    public Collection<? extends RegistryKey<Biome>> getBiomes() {
        return this.biomes;
    }

    public Collection<? extends RegistryKey<Biome>> getFrostyBiomes() {
        return this.frostyBiomes;
    }

    public ILeavesColor getLeavesColor() {
        return this.leavesColor;
    }

    public void registerFeature() {
        if (this.singleTreeFeature == null) {
            this.singleTreeFeature = BiomeMaker.registerConfiguredFeature(this.name, this.featureBiFunction.apply((Block)this.log.get(), (Block)this.leaves.get()));
            this.treesFeature = BiomeMaker.registerConfiguredFeature("trees_" + this.name, this.singleTreeFeature.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(this.treeDensity, 0.1f, this.treeDensity / 4))));
        }
    }

    public boolean isNotInherited() {
        return !this.inherited;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public Supplier<IItemProvider> getApple() {
        return this.apple;
    }

    public static class BiomeSettings {
        private final float temperature;
        private final boolean snowy;
        private final boolean dry;
        private final int treeDensity;

        private BiomeSettings(float temp, boolean snowy, boolean dry, int treeDensity) {
            this.temperature = temp;
            this.snowy = snowy;
            this.dry = dry;
            this.treeDensity = treeDensity;
        }

        private float getTemperature() {
            return this.temperature;
        }

        public boolean isSnowy() {
            return this.snowy;
        }

        public boolean isDry() {
            return this.dry;
        }

        public int getTreeDensity() {
            return this.treeDensity;
        }

        public static class Builder {
            private float temperature = 0.7f;
            private boolean snowy = false;
            private boolean dry = false;
            private int treeDensity = 10;

            public Builder temperature(float temp) {
                this.temperature = temp;
                return this;
            }

            public Builder snow() {
                this.snowy = true;
                return this;
            }

            public Builder dry() {
                this.snowy = false;
                this.dry = true;
                return this;
            }

            public BiomeSettings build() {
                return new BiomeSettings(this.temperature, this.snowy, this.dry, this.treeDensity);
            }

            public Builder density(int density) {
                this.treeDensity = density;
                return this;
            }
        }
    }

    public static class Builder {
        private final DeferredRegister<Item> itemRegistry;
        private final DeferredRegister<Block> blockRegistry;
        private final DeferredRegister<Biome> biomeRegistry;
        private final String name;
        private final String englishName;
        private MaterialColor woodColor;
        private MaterialColor logColor;
        private ILeavesColor leavesColor;
        private Supplier<IItemProvider> apple;
        private RegisteredTree inherit;
        private BiFunction<Block, Block, ConfiguredFeature<BaseTreeFeatureConfig, ?>> feature;
        private BiomeSettings biomeSettings;

        private Builder(DeferredRegister<Block> BLOCKS, DeferredRegister<Item> ITEMS, DeferredRegister<Biome> BIOMES, String name, String englishName) {
            this.biomeRegistry = BIOMES;
            this.itemRegistry = ITEMS;
            this.blockRegistry = BLOCKS;
            this.name = name;
            this.englishName = englishName;
            this.woodColor = MaterialColor.field_151663_o;
            this.logColor = MaterialColor.field_151650_B;
            this.leavesColor = blockPos -> 8431445;
            this.apple = null;
            this.inherit = null;
            this.feature = (log, leaves) -> null;
            this.biomeSettings = new BiomeSettings.Builder().build();
        }

        public Builder wood(MaterialColor color) {
            this.woodColor = color;
            return this;
        }

        public Builder log(MaterialColor color) {
            this.logColor = color;
            return this;
        }

        public Builder leaves(int color) {
            this.leavesColor = blockPos -> color;
            return this;
        }

        public Builder leaves(ILeavesColor color) {
            this.leavesColor = color;
            return this;
        }

        public Builder apple(Supplier<IItemProvider> apple) {
            this.apple = apple;
            return this;
        }

        public static Builder create(DeferredRegister<Block> BLOCKS, DeferredRegister<Item> ITEMS, DeferredRegister<Biome> BIOMES, String id, String name) {
            return new Builder(BLOCKS, ITEMS, BIOMES, id, name);
        }

        public RegisteredTree build() {
            return new RegisteredTree(this.blockRegistry, this.itemRegistry, this.biomeRegistry, this.name, this.englishName, this.woodColor, this.logColor, this.leavesColor, this.apple, this.inherit, this.feature, this.biomeSettings);
        }

        public Builder biome(BiomeSettings.Builder settings) {
            this.biomeSettings = settings.build();
            return this;
        }

        public Builder inheritWood(RegisteredTree inherit) {
            this.inherit = inherit;
            return this;
        }

        public Builder feature(BiFunction<Block, Block, ConfiguredFeature<BaseTreeFeatureConfig, ?>> feature) {
            this.feature = feature;
            return this;
        }
    }
}

