/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.tree;

import deerangle.treemendous.tree.foliage.BallFoliagePlacer;
import deerangle.treemendous.tree.foliage.ParabolaFoliagePlacer;
import deerangle.treemendous.tree.foliage.PointyFoliagePlacer;
import deerangle.treemendous.tree.foliage.RoundedFoliagePlacer;
import deerangle.treemendous.tree.foliage.WillowFoliagePlacer;
import deerangle.treemendous.tree.trunk.AshTrunkPlacer;
import deerangle.treemendous.tree.trunk.CrossTrunkPlacer;
import java.util.OptionalInt;
import net.minecraft.block.Block;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.AcaciaFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.PineFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.SpruceFoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.ForkyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;

public class TreeMaker {
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeNeedleTree(Block log, Block leaves, int trunkBase, int baseHeight, int extraHeight) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new SpruceFoliagePlacer(FeatureSpread.func_242253_a((int)2, (int)1), FeatureSpread.func_242253_a((int)0, (int)2), FeatureSpread.func_242253_a((int)trunkBase, (int)1)), (AbstractTrunkPlacer)new StraightTrunkPlacer(baseHeight, extraHeight, 1), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makePineTree(Block log, Block leaves) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new PineFoliagePlacer(FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242253_a((int)3, (int)1)), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 3, 2), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeSmallLeafTree(Block log, Block leaves, int baseHeight, int extraHeight, int crownWidth, int crownHeight) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)crownWidth), FeatureSpread.func_242252_a((int)0), crownHeight), (AbstractTrunkPlacer)new StraightTrunkPlacer(baseHeight, extraHeight, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeCrossBlobTree(Block log, Block leaves, int baseHeight, int extraHeight, int crownWidth, int crownHeight) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)crownWidth), FeatureSpread.func_242252_a((int)0), crownHeight), (AbstractTrunkPlacer)new CrossTrunkPlacer(baseHeight, extraHeight, 0, FeatureSpread.func_242253_a((int)2, (int)1), FeatureSpread.func_242253_a((int)1, (int)1), FeatureSpread.func_242252_a((int)1), true), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeCrossRoundTree(Block log, Block leaves, int baseHeight, int extraHeight, int crownWidth, FeatureSpread branchLength, int roundIndex) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new RoundedFoliagePlacer(FeatureSpread.func_242252_a((int)crownWidth), FeatureSpread.func_242252_a((int)0), roundIndex), (AbstractTrunkPlacer)new CrossTrunkPlacer(baseHeight, extraHeight, 0, branchLength, FeatureSpread.func_242253_a((int)2, (int)1), FeatureSpread.func_242253_a((int)1, (int)2), true), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeRoundedLeafTree(Block log, Block leaves, int baseHeight, int extraHeight, int roundedIndex) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new RoundedFoliagePlacer(FeatureSpread.func_242252_a((int)4), FeatureSpread.func_242252_a((int)0), roundedIndex), (AbstractTrunkPlacer)new StraightTrunkPlacer(baseHeight, extraHeight, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeAcaciaLeafTree(Block log, Block leaves) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new AcaciaFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0)), (AbstractTrunkPlacer)new ForkyTrunkPlacer(4, 1, 2), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 2)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeLeafTree(Block log, Block leaves) {
        return TreeMaker.makeSmallLeafTree(log, leaves, 5, 2, 2, 3);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeMapleTree(Block log, Block leaves) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new ParabolaFoliagePlacer(FeatureSpread.func_242252_a((int)3), FeatureSpread.func_242253_a((int)0, (int)1), 4, 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(6, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeFancyLeafTree(Block log, Block leaves) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(5, 3, 1), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeAshTree(Block log, Block leaves, int baseHeight, int extraHeight, FeatureSpread leavesSideOffset, FeatureSpread minLeavesHeight, FeatureSpread leavesSize) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new BallFoliagePlacer(leavesSize), (AbstractTrunkPlacer)new AshTrunkPlacer(baseHeight, extraHeight, 1, leavesSideOffset, minLeavesHeight), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makePlaneTree(Block log, Block leaves) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new CrossTrunkPlacer(7, 3, 0, FeatureSpread.func_242253_a((int)1, (int)2), FeatureSpread.func_242253_a((int)1, (int)1), FeatureSpread.func_242252_a((int)-2), true), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeWillowLeafTree(Block log, Block leaves) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new WillowFoliagePlacer(FeatureSpread.func_242252_a((int)3), FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242253_a((int)2, (int)1)), (AbstractTrunkPlacer)new CrossTrunkPlacer(6, 2, 0, FeatureSpread.func_242253_a((int)1, (int)1), FeatureSpread.func_242253_a((int)1, (int)1), FeatureSpread.func_242252_a((int)1), false), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makePointyTree(Block log, Block leaves, FeatureSpread topSpread, FeatureSpread bottomSpread, int bottomOffset, int baseHeight, int extraHeight) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new PointyFoliagePlacer(FeatureSpread.func_242252_a((int)3), FeatureSpread.func_242252_a((int)2), topSpread, bottomSpread, FeatureSpread.func_242253_a((int)bottomOffset, (int)1)), (AbstractTrunkPlacer)new StraightTrunkPlacer(baseHeight, extraHeight, 1), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeJuniperTree(Block log, Block leaves, FeatureSpread topSpread, FeatureSpread bottomSpread, int bottomOffset, int baseHeight, int extraHeight) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new PointyFoliagePlacer(FeatureSpread.func_242252_a((int)3), FeatureSpread.func_242252_a((int)2), topSpread, bottomSpread, FeatureSpread.func_242253_a((int)bottomOffset, (int)1)), (AbstractTrunkPlacer)new CrossTrunkPlacer(baseHeight, extraHeight, 1, FeatureSpread.func_242252_a((int)1), FeatureSpread.func_242252_a((int)6), FeatureSpread.func_242252_a((int)0), false), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> makeBallTree(Block log, Block leaves) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), (FoliagePlacer)new BallFoliagePlacer(FeatureSpread.func_242253_a((int)2, (int)2)), (AbstractTrunkPlacer)new CrossTrunkPlacer(9, 2, 1, FeatureSpread.func_242253_a((int)2, (int)2), FeatureSpread.func_242253_a((int)1, (int)2), FeatureSpread.func_242252_a((int)0), true), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }
}

