/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.tree.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import deerangle.treemendous.main.TreeRegistry;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;

public class PointyFoliagePlacer
extends FoliagePlacer {
    public static final Codec<PointyFoliagePlacer> CODEC = RecordCodecBuilder.create(placerInstance -> PointyFoliagePlacer.func_242830_b((RecordCodecBuilder.Instance)placerInstance).and((App)FeatureSpread.func_242254_a((int)0, (int)100, (int)100).fieldOf("outward_speed").forGetter(inst -> inst.outwardSpeedX100)).and((App)FeatureSpread.func_242254_a((int)0, (int)100, (int)100).fieldOf("inward_speed").forGetter(inst -> inst.inwardSpeedX100)).and((App)FeatureSpread.func_242254_a((int)0, (int)16, (int)16).fieldOf("target_height").forGetter(inst -> inst.bottomOffset)).apply((Applicative)placerInstance, PointyFoliagePlacer::new));
    private final FeatureSpread outwardSpeedX100;
    private final FeatureSpread inwardSpeedX100;
    private final FeatureSpread bottomOffset;
    private float currentWidth;

    public PointyFoliagePlacer(FeatureSpread radius, FeatureSpread offset, FeatureSpread outwardSpeedX100, FeatureSpread inwardSpeedX100, FeatureSpread bottomOffset) {
        super(radius, offset);
        this.outwardSpeedX100 = outwardSpeedX100;
        this.inwardSpeedX100 = inwardSpeedX100;
        this.bottomOffset = bottomOffset;
    }

    protected FoliagePlacerType<?> func_230371_a_() {
        return TreeRegistry.POINTY_FOLIAGE_PLACER;
    }

    protected void func_230372_a_(IWorldGenerationReader worldGenerationReader, Random random, BaseTreeFeatureConfig featureConfig, int trunkHeight, FoliagePlacer.Foliage foliage, int crownHeight, int radius, Set<BlockPos> p_230372_8_, int startY, MutableBoundingBox p_230372_10_) {
        float m = (float)this.inwardSpeedX100.func_242259_a(random) * 0.01f;
        float n = (float)this.outwardSpeedX100.func_242259_a(random) * 0.01f;
        float h = trunkHeight - this.bottomOffset.func_242259_a(random) + startY;
        float targetHeightN = m / (n + m) * h;
        float targetWidthAct = n * targetHeightN;
        int y = -startY;
        this.currentWidth = 0.0f;
        while (this.currentWidth <= targetWidthAct) {
            this.currentWidth += n;
            this.func_236753_a_(worldGenerationReader, random, featureConfig, foliage.func_236763_a_(), (int)this.currentWidth + 1, p_230372_8_, -y, foliage.func_236765_c_(), p_230372_10_);
            ++y;
        }
        while (this.currentWidth > 0.0f) {
            this.currentWidth -= m;
            this.func_236753_a_(worldGenerationReader, random, featureConfig, foliage.func_236763_a_(), (int)this.currentWidth + 1, p_230372_8_, -y, foliage.func_236765_c_(), p_230372_10_);
            ++y;
        }
    }

    public int func_230374_a_(Random p_230374_1_, int p_230374_2_, BaseTreeFeatureConfig p_230374_3_) {
        return 0;
    }

    protected boolean func_230373_a_(Random rand, int x, int y, int z, int radius, boolean p_230373_6_) {
        double distance = Math.sqrt(x * x + z * z) - (double)this.currentWidth;
        return distance > 0.0 || !(distance / (double)this.currentWidth < -0.15) && rand.nextFloat() < 0.3f;
    }
}

