/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.tree.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import deerangle.treemendous.main.TreeRegistry;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;

public class WillowFoliagePlacer
extends FoliagePlacer {
    public static final Codec<WillowFoliagePlacer> CODEC = RecordCodecBuilder.create(placerInstance -> WillowFoliagePlacer.func_242830_b((RecordCodecBuilder.Instance)placerInstance).and((App)FeatureSpread.func_242254_a((int)0, (int)8, (int)8).fieldOf("branch_lengeth").forGetter(inst -> inst.branchLength)).apply((Applicative)placerInstance, WillowFoliagePlacer::new));
    private final FeatureSpread branchLength;

    public WillowFoliagePlacer(FeatureSpread radius, FeatureSpread offset, FeatureSpread branchLength) {
        super(radius, offset);
        this.branchLength = branchLength;
    }

    protected FoliagePlacerType<?> func_230371_a_() {
        return TreeRegistry.WILLOW_FOLIAGE_PLACER;
    }

    protected void func_230372_a_(IWorldGenerationReader worldGenerationReader, Random random, BaseTreeFeatureConfig featureConfig, int p_230372_4_, FoliagePlacer.Foliage foliage, int offset, int radius, Set<BlockPos> resultingBlocks, int startY, MutableBoundingBox boundingBox) {
        for (int i = 0; i < 4; ++i) {
            this.func_236753_a_(worldGenerationReader, random, featureConfig, foliage.func_236763_a_(), Math.min(i + 1, 3), resultingBlocks, startY - i, foliage.func_236765_c_(), boundingBox);
        }
        this.growBranchDown(2, startY - 4, 2, this.branchLength.func_242259_a(random), worldGenerationReader, random, featureConfig, foliage, resultingBlocks, boundingBox);
        this.growBranchDown(-2, startY - 4, -2, this.branchLength.func_242259_a(random), worldGenerationReader, random, featureConfig, foliage, resultingBlocks, boundingBox);
        this.growBranchDown(-2, startY - 4, 2, this.branchLength.func_242259_a(random), worldGenerationReader, random, featureConfig, foliage, resultingBlocks, boundingBox);
        this.growBranchDown(2, startY - 4, -2, this.branchLength.func_242259_a(random), worldGenerationReader, random, featureConfig, foliage, resultingBlocks, boundingBox);
        this.growBranchDown(3, startY - 4, 0, this.branchLength.func_242259_a(random), worldGenerationReader, random, featureConfig, foliage, resultingBlocks, boundingBox);
        this.growBranchDown(-3, startY - 4, 0, this.branchLength.func_242259_a(random), worldGenerationReader, random, featureConfig, foliage, resultingBlocks, boundingBox);
        this.growBranchDown(0, startY - 4, 3, this.branchLength.func_242259_a(random), worldGenerationReader, random, featureConfig, foliage, resultingBlocks, boundingBox);
        this.growBranchDown(0, startY - 4, -3, this.branchLength.func_242259_a(random), worldGenerationReader, random, featureConfig, foliage, resultingBlocks, boundingBox);
    }

    private void growBranchDown(int x, int y, int z, int length, IWorldGenerationReader worldGenerationReader, Random random, BaseTreeFeatureConfig featureConfig, FoliagePlacer.Foliage foliage, Set<BlockPos> resultingBlocks, MutableBoundingBox boundingBox) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int i = 0; i < length; ++i) {
            mutablePos.func_239621_a_((Vector3i)foliage.func_236763_a_(), x, y - i, z);
            if (!TreeFeature.func_236404_a_((IWorldGenerationBaseReader)worldGenerationReader, (BlockPos)mutablePos)) continue;
            worldGenerationReader.func_180501_a((BlockPos)mutablePos, featureConfig.field_227369_n_.func_225574_a_(random, (BlockPos)mutablePos), 19);
            boundingBox.func_78888_b(new MutableBoundingBox((Vector3i)mutablePos, (Vector3i)mutablePos));
            resultingBlocks.add(mutablePos.func_185334_h());
        }
    }

    public int func_230374_a_(Random p_230374_1_, int p_230374_2_, BaseTreeFeatureConfig p_230374_3_) {
        return 6;
    }

    protected boolean func_230373_a_(Random rand, int x, int y, int z, int p_230373_5_, boolean p_230373_6_) {
        double realSize = (new double[]{1.5, 2.5, 3.0, 3.5})[-y];
        double distance = Math.sqrt(x * x + z * z) - realSize;
        return distance > 0.0;
    }
}

