/*
 * Decompiled with CFR 0.152.
 */
package deerangle.treemendous.tree.trunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import deerangle.treemendous.main.TreeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class AshTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<AshTrunkPlacer> CODEC = RecordCodecBuilder.create(placerInstance -> AshTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)placerInstance).and((App)FeatureSpread.func_242254_a((int)0, (int)8, (int)8).fieldOf("offset").forGetter(inst -> inst.leavesOffset)).and((App)FeatureSpread.func_242254_a((int)0, (int)8, (int)8).fieldOf("min_height").forGetter(inst -> inst.minLeafHeight)).apply((Applicative)placerInstance, AshTrunkPlacer::new));
    private final FeatureSpread leavesOffset;
    private final FeatureSpread minLeafHeight;

    public AshTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, FeatureSpread leavesOffset, FeatureSpread minLeafHeight) {
        super(baseHeight, heightRandA, heightRandB);
        this.leavesOffset = leavesOffset;
        this.minLeafHeight = minLeafHeight;
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return TreeRegistry.ASH_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader generationReader, Random random, int height, BlockPos startPos, Set<BlockPos> resultingBlocks, MutableBoundingBox boundingBox, BaseTreeFeatureConfig featureConfig) {
        AshTrunkPlacer.func_236909_a_((IWorldGenerationReader)generationReader, (BlockPos)startPos.func_177977_b());
        ArrayList<FoliagePlacer.Foliage> foliages = new ArrayList<FoliagePlacer.Foliage>();
        int leafHeight = this.minLeafHeight.func_242259_a(random);
        int last = 0;
        for (int i = 0; i < height; ++i) {
            if (i >= leafHeight && i - last > 3) {
                BlockPos pos = startPos.func_177981_b(i - 1).func_177967_a(Direction.Plane.HORIZONTAL.func_179518_a(random), this.leavesOffset.func_242259_a(random));
                foliages.add(new FoliagePlacer.Foliage(pos, 0, false));
                last = i;
            }
            AshTrunkPlacer.func_236911_a_((IWorldGenerationReader)generationReader, (Random)random, (BlockPos)startPos.func_177981_b(i), resultingBlocks, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)featureConfig);
        }
        foliages.add(new FoliagePlacer.Foliage(startPos.func_177981_b(height - 1), 0, false));
        return foliages;
    }
}

