/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.CataclysmCharge;
import com.hackshop.ultimate_unicorn.custom.CustomHorseInfo;
import com.hackshop.ultimate_unicorn.custom.DeathWind;
import com.hackshop.ultimate_unicorn.custom.FlameAura;
import com.hackshop.ultimate_unicorn.custom.HealingHorn;
import com.hackshop.ultimate_unicorn.custom.HornOfThrowing;
import com.hackshop.ultimate_unicorn.custom.IcyWingBuffet;
import com.hackshop.ultimate_unicorn.custom.LifeAura;
import com.hackshop.ultimate_unicorn.custom.Power;
import com.hackshop.ultimate_unicorn.custom.PowerAccessor;
import com.hackshop.ultimate_unicorn.custom.PowerStomp;
import com.hackshop.ultimate_unicorn.custom.PowerWingBuffet;
import com.hackshop.ultimate_unicorn.custom.ProtectionAura;
import com.hackshop.ultimate_unicorn.custom.RainbowAura;
import com.hackshop.ultimate_unicorn.custom.RainbowBeam;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.PowerSettings;

public abstract class AbstractPower
implements Power {
    public static Power[] allPowers = new Power[]{new PowerWingBuffet(false), new IcyWingBuffet(false), new PowerStomp(false), new HealingHorn(false), new HornOfThrowing(false), new FlameAura(false), new ProtectionAura(false), new CataclysmCharge(), new LifeAura(), new DeathWind(), new RainbowBeam(false), new RainbowAura(false)};
    public static Power[] allSuperchargedPowers = new Power[]{new PowerWingBuffet(true), new IcyWingBuffet(true), new PowerStomp(true), new HealingHorn(true), new HornOfThrowing(true), new FlameAura(true), new ProtectionAura(true), new RainbowBeam(true), new RainbowAura(true)};
    protected String name;
    protected boolean supercharged = false;

    @Override
    public void doAuraPower(EntityMagicalHorse horse, int auraCounter) {
    }

    @Override
    public void doMovementPower(EntityMagicalHorse entityMagicalHorse) {
    }

    public AbstractPower() {
    }

    public AbstractPower(boolean supercharged) {
        this.supercharged = supercharged;
    }

    @Override
    public final String getName() {
        if (this.supercharged) {
            return this.name + " (+)";
        }
        return this.name;
    }

    @Override
    public abstract EntityMagicalHorse.OrderedPower getOrderedPower();

    @Override
    public void doBuffetPower(EntityMagicalHorse horse, int buffetCooldownCounter, float forward, float sides, float up) {
    }

    @Override
    public void doLandingPower(EntityMagicalHorse horse) {
    }

    @Override
    public boolean doHornPower(EntityMagicalHorse horse) {
        return false;
    }

    @Override
    public void doHornPowerOnClick(EntityMagicalHorse horse, Power.Counter counter) {
    }

    public static PowerAccessor[] getPowers(CustomHorseInfo info, PowerSettings powerSettings) {
        PowerAccessor[] retPowers = new PowerAccessor[info.powers.length + info.superchargedPowers.length];
        int index = 0;
        for (int i : info.powers) {
            retPowers[index] = new PowerAccessor(allPowers[i], powerSettings);
            ++index;
        }
        for (int i : info.superchargedPowers) {
            retPowers[index] = new PowerAccessor(allSuperchargedPowers[i], powerSettings);
            ++index;
        }
        return retPowers;
    }

    @Override
    public float getBuffetStrengthMultiplier() {
        return 1.0f;
    }

    @Override
    public float getBuffetForwardSizeMultiplier() {
        return 1.0f;
    }

    @Override
    public float getBuffetSideSizeMultiplier() {
        return 1.0f;
    }

    @Override
    public float getBuffetUpSizeMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean satisfiesCondition() {
        return true;
    }

    @Override
    public boolean isNonCombatant() {
        return false;
    }
}

