/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.google.common.collect.Lists;
import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.custom.CustomHorseInfo;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HorseLayeredTexture
extends AbstractTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String horseTextureName;
    private String name;
    public final List<String> layeredTextureNames;

    public HorseLayeredTexture(String name, String ... textureNames) {
        this.name = name.toLowerCase();
        this.layeredTextureNames = Lists.newArrayList((Object[])textureNames);
        this.horseTextureName = this.layeredTextureNames.remove(0);
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        BufferedImage bufferedImage = null;
        bufferedImage = this.drawTo2(resourceManager);
        for (String s : this.layeredTextureNames) {
            BufferedImage bi2 = this.drawTo(bufferedImage, s, resourceManager);
            if (null != bi2) continue;
            return;
        }
        TextureUtil.func_110987_a((int)this.func_110552_b(), (BufferedImage)bufferedImage);
    }

    private BufferedImage drawTo2(IResourceManager resourceManager) {
        BufferedImage source = null;
        CustomHorseInfo chi = CommonProxy.customHorseData.get(this.name);
        if (null != chi && !chi.isInMod() && chi.isReady()) {
            source = chi.getBufferedImage();
        }
        if (null != source) {
            BufferedImage bufferedImage = new BufferedImage(source.getWidth(), source.getHeight(), 2);
            bufferedImage.getGraphics().drawImage(source, 0, 0, null);
            return bufferedImage;
        }
        if (null != chi && chi.isInMod()) {
            return this.drawTo(null, chi.texture, resourceManager);
        }
        return this.drawTo(null, this.horseTextureName, resourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BufferedImage drawTo(BufferedImage bufferedImage, String s, IResourceManager resourceManager) {
        BufferedImage bufferedimage1;
        IResource iresource = null;
        try {
            if (s != null) {
                iresource = resourceManager.func_110536_a(new ResourceLocation(s));
                bufferedimage1 = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
                if (bufferedImage == null) {
                    bufferedImage = new BufferedImage(bufferedimage1.getWidth(), bufferedimage1.getHeight(), 2);
                }
                bufferedImage.getGraphics().drawImage(bufferedimage1, 0, 0, null);
            }
            bufferedimage1 = bufferedImage;
        }
        catch (IOException ioexception) {
            try {
                LOGGER.error("Couldn't load layered image", (Throwable)ioexception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(iresource);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)iresource);
            return null;
        }
        IOUtils.closeQuietly(iresource);
        return bufferedimage1;
    }
}

