/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.UpdateChecker;
import com.hackshop.ultimate_unicorn.custom.CustomHorseInfo;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerThreadDownloadHorse {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger TEXTURE_DOWNLOADER_THREAD_ID = new AtomicInteger(0);
    @Nullable
    private final File cacheFile;
    private String imageUrl;
    @Nullable
    private final File indexCacheFile;
    private final String indexUrl;
    @Nullable
    private Thread imageThread;
    private boolean textureUploaded;
    private CustomHorseInfo chi;
    private String name;
    private String firstLetter = null;
    private String title = null;
    private int[] powers = null;
    private static final HashMap<String, String> indexUrls = new HashMap();

    public ServerThreadDownloadHorse(String nameIn, ResourceLocation textureResourceLocation, CustomHorseInfo chi) {
        if (null == nameIn || nameIn.length() < 1) {
            this.firstLetter = "z";
        } else {
            this.firstLetter = nameIn.substring(0, 1);
            if (this.firstLetter.matches("[^a-z]")) {
                this.firstLetter = "z";
            }
        }
        this.indexUrl = indexUrls.get(this.firstLetter);
        this.indexCacheFile = new File(CommonProxy.downloadDir, this.firstLetter + ".txt");
        this.imageUrl = null;
        this.chi = chi;
        this.name = nameIn;
        this.cacheFile = new File(CommonProxy.downloadDir, this.name + ".png");
    }

    public void loadTexture() throws IOException {
        if (this.imageThread == null) {
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", new Object[]{this.cacheFile});
                try {
                    String def = this.loadIndex();
                    String deObDef = ServerThreadDownloadHorse.deOb(def);
                    if (null == deObDef) {
                        this.chi.setDefunct(true);
                        return;
                    }
                    this.loadTitleAndPowers(deObDef);
                    this.chi.setTitle(this.title);
                    this.chi.setPowers(this.powers);
                    this.chi.setReady(true);
                }
                catch (IOException ioexception) {
                    LOGGER.error("Couldn't load skin {}", new Object[]{this.cacheFile, ioexception});
                    this.loadTextureFromServer();
                }
            } else {
                this.loadTextureFromServer();
            }
        }
    }

    private void loadTitleAndPowers(String def) {
        String[] parts = def.split(",");
        this.imageUrl = parts[0];
        int i = 1;
        if (parts.length > i && !Pattern.matches("^\\d+$", parts[i])) {
            this.title = parts[i];
            ++i;
        }
        int start = i;
        int[] powers = new int[parts.length - i];
        while (i < parts.length) {
            powers[i - start] = Integer.parseInt(parts[i]);
            ++i;
        }
        this.powers = powers;
    }

    private static String deOb(String ob) {
        if (null == ob) {
            return null;
        }
        try {
            String preamble = ob.substring(0, 3);
            String rest = ob.substring(3);
            String subbed = ServerThreadDownloadHorse.sub3(rest);
            String rotated = ServerThreadDownloadHorse.rot13(subbed);
            int check = Integer.parseInt(preamble);
            int sum = 0;
            for (char c : rotated.toCharArray()) {
                sum += c;
            }
            if (check == (sum %= 997)) {
                return rotated;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String sub3(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            c = (char)(c - 3);
            sb.append(c);
        }
        return sb.toString();
    }

    private static String rot13(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected void loadTextureFromServer() {
        this.imageThread = new Thread("Texture Downloader #" + TEXTURE_DOWNLOADER_THREAD_ID.incrementAndGet()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection httpurlconnection = null;
                LOGGER.debug("Downloading http texture from {} to {}", new Object[]{ServerThreadDownloadHorse.this.imageUrl, ServerThreadDownloadHorse.this.cacheFile});
                try {
                    String def = ServerThreadDownloadHorse.this.loadIndex();
                    String deObDef = ServerThreadDownloadHorse.deOb(def);
                    if (null == deObDef) {
                        ServerThreadDownloadHorse.this.chi.setDefunct(true);
                        return;
                    }
                    ServerThreadDownloadHorse.this.loadTitleAndPowers(deObDef);
                    httpurlconnection = (HttpURLConnection)new URL(ServerThreadDownloadHorse.this.imageUrl).openConnection(Proxy.NO_PROXY);
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        if (ServerThreadDownloadHorse.this.cacheFile != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)ServerThreadDownloadHorse.this.cacheFile);
                        }
                        ServerThreadDownloadHorse.this.chi.setTitle(ServerThreadDownloadHorse.this.title);
                        ServerThreadDownloadHorse.this.chi.setPowers(ServerThreadDownloadHorse.this.powers);
                        ServerThreadDownloadHorse.this.chi.setReady(true);
                        return;
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't download http texture", (Throwable)exception);
                    ServerThreadDownloadHorse.this.chi.setDefunct(true);
                    return;
                }
                finally {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }

    public String loadIndex() throws IOException {
        if (this.indexCacheFile != null && this.indexCacheFile.isFile()) {
            LOGGER.debug("Loading index from local cache ({})", new Object[]{this.indexCacheFile});
            String md5 = DigestUtils.md5Hex((byte[])FileUtils.readFileToByteArray((File)this.indexCacheFile));
            if (UpdateChecker.isMd5Different(this.firstLetter, md5)) {
                return this.loadIndexFromServer();
            }
            try {
                Properties plainProps = new Properties();
                plainProps.load(new FileReader(this.indexCacheFile));
                return plainProps.getProperty(this.name);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't load index {}", new Object[]{this.indexCacheFile, ioexception});
                return this.loadIndexFromServer();
            }
        }
        return this.loadIndexFromServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadIndexFromServer() {
        HttpURLConnection httpurlconnection = null;
        LOGGER.debug("Downloading http index from {} to {}", new Object[]{this.indexUrl, this.indexCacheFile});
        try {
            httpurlconnection = (HttpURLConnection)new URL(this.indexUrl).openConnection(Proxy.NO_PROXY);
            httpurlconnection.setDoInput(true);
            httpurlconnection.setDoOutput(false);
            httpurlconnection.connect();
            if (httpurlconnection.getResponseCode() / 100 == 2) {
                if (this.indexCacheFile != null) {
                    FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.indexCacheFile);
                    Properties plainProps = new Properties();
                    plainProps.load(new FileReader(this.indexCacheFile));
                    String string = plainProps.getProperty(this.name);
                    return string;
                }
                Properties plainProps = new Properties();
                plainProps.load(new FileReader(this.indexCacheFile));
                String string = plainProps.getProperty(this.name);
                return string;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't download http index: " + this.indexUrl, (Throwable)exception);
        }
        finally {
            if (httpurlconnection != null) {
                httpurlconnection.disconnect();
            }
        }
        return null;
    }

    static {
        indexUrls.put("a", "https://drive.google.com/uc?id=0B9WcdoRq4rJWcEM3MURoSjR6TkE");
        indexUrls.put("b", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbnFvSXlING1aREk");
        indexUrls.put("c", "https://drive.google.com/uc?id=0B9WcdoRq4rJWeHlDYU5UZzFhZjQ");
        indexUrls.put("d", "https://drive.google.com/uc?id=0B9WcdoRq4rJWUkltbEIydGpubG8");
        indexUrls.put("e", "https://drive.google.com/uc?id=0B9WcdoRq4rJWTG5xbkFuWkk2WHc");
        indexUrls.put("f", "https://drive.google.com/uc?id=0B9WcdoRq4rJWOGJxczBOZnJoYVU");
        indexUrls.put("g", "https://drive.google.com/uc?id=0B9WcdoRq4rJWVGM2Y0Jyd24wY0k");
        indexUrls.put("h", "https://drive.google.com/uc?id=0B9WcdoRq4rJWYUNNdEE1WEJZbG8");
        indexUrls.put("i", "https://drive.google.com/uc?id=0B9WcdoRq4rJWY0lNVDJsZkt5YUk");
        indexUrls.put("j", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbFFVRl80eU5pX2M");
        indexUrls.put("k", "https://drive.google.com/uc?id=0B9WcdoRq4rJWUUxuWjVSdWdIS2c");
        indexUrls.put("l", "https://drive.google.com/uc?id=0B9WcdoRq4rJWb1l3S0NmalFsczg");
        indexUrls.put("m", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbXl6eHpRcjdsMGs");
        indexUrls.put("n", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbkl3aWk4QThWSzA");
        indexUrls.put("o", "https://drive.google.com/uc?id=0B9WcdoRq4rJWdmI0QU9pMGxVU28");
        indexUrls.put("p", "https://drive.google.com/uc?id=0B9WcdoRq4rJWZ3kyT2ZVYXN5dnc");
        indexUrls.put("q", "https://drive.google.com/uc?id=0B9WcdoRq4rJWOUxFTnUxSVBBU0U");
        indexUrls.put("r", "https://drive.google.com/uc?id=0B9WcdoRq4rJWZVkxcTFyVkE0S28");
        indexUrls.put("s", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbXF0NEIySWRaMFk");
        indexUrls.put("t", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbDhGMnRUZXAzeWc");
        indexUrls.put("u", "https://drive.google.com/uc?id=0B9WcdoRq4rJWZ1U2TFNnTU93QjQ");
        indexUrls.put("v", "https://drive.google.com/uc?id=0B9WcdoRq4rJWQlhJeE1YYTBkb28");
        indexUrls.put("w", "https://drive.google.com/uc?id=0B9WcdoRq4rJWMm5fMTl3X1RMdlU");
        indexUrls.put("x", "https://drive.google.com/uc?id=0B9WcdoRq4rJWQnU5NHBmY3ZZUWs");
        indexUrls.put("y", "https://drive.google.com/uc?id=0B9WcdoRq4rJWMUtoSjRtUk13b0U");
        indexUrls.put("z", "https://drive.google.com/uc?id=0B9WcdoRq4rJWVlptUzFQN19GUEU");
    }
}

