/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.input;

import com.hackshop.ultimate_unicorn.AscendPegasusMessage;
import com.hackshop.ultimate_unicorn.BreatheKirinMessage;
import com.hackshop.ultimate_unicorn.ChargeUnicornMessage;
import com.hackshop.ultimate_unicorn.CombinedClientProxy;
import com.hackshop.ultimate_unicorn.DescendPegasusMessage;
import com.hackshop.ultimate_unicorn.input.KeyBindings;
import com.hackshop.ultimate_unicorn.items.ItemWandOfCallLightning;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.util.WorldUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class KeyInputHandler {
    int tickCounter = 0;

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        EntityMagicalHorse horse;
        EntityPlayerSP player;
        if (KeyBindings.chargeUnicorn.func_151468_f()) {
            BlockPos targetPos = this.getTargetPos();
            CombinedClientProxy.network.sendToServer((IMessage)new ChargeUnicornMessage(targetPos));
        }
        if (KeyBindings.descendPegasus.func_151468_f()) {
            player = Minecraft.func_71410_x().field_71439_g;
            if (null != player.func_184187_bx() && player.func_184187_bx() instanceof EntityMagicalHorse) {
                horse = (EntityMagicalHorse)player.func_184187_bx();
                horse.ascendCounter = 0;
                horse.descendCounter = 1;
            }
            CombinedClientProxy.network.sendToServer((IMessage)new DescendPegasusMessage());
        }
        if (KeyBindings.ascendPegasus.func_151468_f()) {
            player = Minecraft.func_71410_x().field_71439_g;
            if (null != player.func_184187_bx() && player.func_184187_bx() instanceof EntityMagicalHorse) {
                horse = (EntityMagicalHorse)player.func_184187_bx();
                horse.ascendCounter = 1;
                horse.descendCounter = 0;
            }
            CombinedClientProxy.network.sendToServer((IMessage)new AscendPegasusMessage());
        }
    }

    public void checkDescendPegasusKeyDown() {
        if (KeyBindings.descendPegasus.func_151470_d()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (null != player.func_184187_bx() && player.func_184187_bx() instanceof EntityMagicalHorse) {
                EntityMagicalHorse horse = (EntityMagicalHorse)player.func_184187_bx();
                horse.ascendCounter = 0;
                horse.descendCounter = 1;
            }
            CombinedClientProxy.network.sendToServer((IMessage)new DescendPegasusMessage());
        }
    }

    public void checkAscendPegasusKeyDown() {
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() || KeyBindings.ascendPegasus.func_151470_d()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (null != player.func_184187_bx() && player.func_184187_bx() instanceof EntityMagicalHorse) {
                EntityMagicalHorse horse = (EntityMagicalHorse)player.func_184187_bx();
                horse.ascendCounter = 1;
                horse.descendCounter = 0;
            }
            CombinedClientProxy.network.sendToServer((IMessage)new AscendPegasusMessage());
        }
    }

    public void checkHornStabKeyDown() {
        if (KeyBindings.chargeUnicorn.func_151470_d()) {
            BlockPos targetPos = this.getTargetPos();
            CombinedClientProxy.network.sendToServer((IMessage)new ChargeUnicornMessage(targetPos));
        }
    }

    public void checkBreatheKeyDown() {
        if (KeyBindings.breatheKirin.func_151470_d()) {
            BlockPos targetPos = this.getTargetPos();
            CombinedClientProxy.network.sendToServer((IMessage)new BreatheKirinMessage(targetPos));
        }
    }

    public BlockPos getTargetPos() {
        EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
        World worldIn = playerIn.field_70170_p;
        BlockPos targetPos = null;
        RayTraceResult target = KeyInputHandler.getMouseOver(1.0f, worldIn, (EntityLivingBase)playerIn);
        if (null != target) {
            switch (target.field_72313_a) {
                case BLOCK: {
                    targetPos = WorldUtil.getTopSolidOrLiquidBlock(target.func_178782_a(), worldIn);
                    break;
                }
                case ENTITY: {
                    targetPos = ItemWandOfCallLightning.getLightningStrikePosOnEntity(worldIn, target.field_72308_g);
                    break;
                }
            }
        }
        return targetPos;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.tickCounter % 4 == 0) {
            this.checkDescendPegasusKeyDown();
            this.checkAscendPegasusKeyDown();
        }
        if (this.tickCounter % 10 == 0) {
            this.checkHornStabKeyDown();
            this.checkBreatheKeyDown();
        }
        ++this.tickCounter;
    }

    public static RayTraceResult getMouseOver(float p_78473_1_, World worldIn, EntityLivingBase entityIn) {
        RayTraceResult objectMouseOver = null;
        Entity pointedEntity = null;
        if (entityIn != null && worldIn != null) {
            pointedEntity = null;
            double d0 = 50.0;
            objectMouseOver = entityIn.func_174822_a(d0, p_78473_1_);
            double d1 = d0;
            Vec3d vec3 = entityIn.func_174824_e(p_78473_1_);
            if (objectMouseOver != null) {
                d1 = objectMouseOver.field_72307_f.func_72438_d(vec3);
            }
            Vec3d vec31 = entityIn.func_70676_i(p_78473_1_);
            Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * d0, vec31.field_72448_b * d0, vec31.field_72449_c * d0);
            pointedEntity = null;
            Vec3d vec33 = null;
            float f1 = 1.0f;
            List list = worldIn.func_72839_b((Entity)entityIn, entityIn.func_174813_aQ().func_72321_a(vec31.field_72450_a * d0, vec31.field_72448_b * d0, vec31.field_72449_c * d0).func_72314_b((double)f1, (double)f1, (double)f1));
            double d2 = d1;
            for (int i = 0; i < list.size(); ++i) {
                double d3;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L()) continue;
                float f2 = entity1.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f2, (double)f2, (double)f2);
                RayTraceResult movingobjectposition = axisalignedbb.func_72327_a(vec3, vec32);
                if (axisalignedbb.func_72318_a(vec3)) {
                    if (!(0.0 < d2) && d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec33 = movingobjectposition == null ? vec3 : movingobjectposition.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((d3 = vec3.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1 == entityIn.func_184187_bx() && !entityIn.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec33 = movingobjectposition.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                vec33 = movingobjectposition.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && (d2 < d1 || objectMouseOver == null)) {
                objectMouseOver = new RayTraceResult(pointedEntity, vec33);
            }
        }
        return objectMouseOver;
    }
}

