/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.items;

import com.google.common.collect.Multimap;
import com.hackshop.ultimate_unicorn.CombinedClientProxy;
import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.ShootWandMessage;
import com.hackshop.ultimate_unicorn.input.KeyInputHandler;
import com.hackshop.ultimate_unicorn.items.HornShootable;
import com.hackshop.ultimate_unicorn.items.ItemHelper;
import com.hackshop.ultimate_unicorn.util.WorldUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemWandOfCallLightning
extends Item
implements HornShootable {
    protected float attackDamage;
    protected final Item.ToolMaterial material = Item.ToolMaterial.IRON;
    private final String name = "wand_of_call_lightning";

    public ItemWandOfCallLightning() {
        this.field_77777_bU = 1;
        this.func_77656_e(50);
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.attackDamage = 0.4f + this.material.func_78000_c();
        this.func_77655_b("wand_of_call_lightning");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public float getDamageVsEntity() {
        return this.material.func_78000_c();
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (player.func_184607_cu() == stack) {
            stack.func_77972_a(4, (EntityLivingBase)player);
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, IBlockState block) {
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        BlockPos targetPos = ItemWandOfCallLightning.getLightningStrikePosOnEntity(target.field_70170_p, (Entity)target);
        target.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(target.field_70170_p, (double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), false));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase playerIn) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, playerIn);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 120;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public ActionResult<ItemStack> func_77659_a(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack lvt_4_1_ = p_onItemRightClick_2_.func_184586_b(p_onItemRightClick_3_);
        p_onItemRightClick_2_.func_184598_c(p_onItemRightClick_3_);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)lvt_4_1_);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (count % 8 == 0 && player.field_70170_p.field_72995_K && player == Minecraft.func_71410_x().field_71439_g) {
            this.clientShoot();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clientShoot() {
        EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
        World worldIn = playerIn.field_70170_p;
        BlockPos targetPos = null;
        RayTraceResult target = KeyInputHandler.getMouseOver(1.0f, worldIn, (EntityLivingBase)playerIn);
        if (null != target) {
            switch (target.field_72313_a) {
                case BLOCK: {
                    targetPos = WorldUtil.getTopSolidOrLiquidBlock(target.func_178782_a(), worldIn);
                    break;
                }
                case ENTITY: {
                    targetPos = ItemWandOfCallLightning.getLightningStrikePosOnEntity(worldIn, target.field_72308_g);
                    break;
                }
            }
        }
        CombinedClientProxy.network.sendToServer((IMessage)new ShootWandMessage(targetPos));
    }

    @Override
    public void shoot(ItemStack stack, World worldIn, EntityLivingBase shooter, BlockPos targetPos) {
        if (null != targetPos && !worldIn.field_72995_K && !CommonProxy.config.disableLightningWand) {
            ItemHelper.horseDamageItem(stack, 1, shooter);
            worldIn.func_72942_c((Entity)new EntityLightningBolt(worldIn, (double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), false));
        }
    }

    @Override
    public void shootTargetEntity(ItemStack stack, World worldIn, EntityLivingBase shooter, EntityLivingBase targetEntity) {
        if (null != targetEntity && !worldIn.field_72995_K) {
            stack.func_77972_a(1, shooter);
            BlockPos targetPos = ItemWandOfCallLightning.getLightningStrikePosOnEntity(worldIn, (Entity)targetEntity);
            worldIn.func_72942_c((Entity)new EntityLightningBolt(worldIn, (double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), false));
        }
    }

    public static BlockPos getLightningStrikePosOnEntity(World worldIn, Entity entityToStrike) {
        BlockPos targetPos = WorldUtil.getTopSolidOrLiquidBlock(new BlockPos(entityToStrike.field_70165_t, entityToStrike.field_70163_u, entityToStrike.field_70161_v), worldIn);
        if ((double)targetPos.func_177956_o() > entityToStrike.field_70163_u) {
            return targetPos;
        }
        return new BlockPos(entityToStrike.field_70165_t, entityToStrike.field_70163_u, entityToStrike.field_70161_v);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase playerIn, int timeLeft) {
        if (!worldIn.field_72995_K) {
            stack.func_77972_a((128 - timeLeft) / 8, playerIn);
        }
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
        return multimap;
    }

    public String getName() {
        return "wand_of_call_lightning";
    }
}

