/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.mobs.renderer;

import com.google.common.collect.Maps;
import com.hackshop.ultimate_unicorn.BreakBlockMessage;
import com.hackshop.ultimate_unicorn.CombinedClientProxy;
import com.hackshop.ultimate_unicorn.custom.HorseLayeredTexture;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.model.ModelMagicalHorse;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class RenderMagicalHorse
extends RenderLiving {
    private static final Map pathnamesToTextures = Maps.newHashMap();
    private static final ResourceLocation whiteHorseTextures = new ResourceLocation("ultimate_unicorn_mod:textures/entity/unicorn_white.png");
    private static final ResourceLocation rainbowBeamTexture = new ResourceLocation("ultimate_unicorn_mod:textures/entity/rainbow_beam.png");
    private static final String __OBFID = "CL_00001000";
    private RayTraceResult lastTarget = null;
    private int lastDamage = 0;
    private int lastDamageCounter = 0;

    public RenderMagicalHorse(RenderManager rMan, ModelMagicalHorse model, float shadowSize) {
        super(rMan, (ModelBase)model, shadowSize);
    }

    public void func_76979_b(Entity horse, double p_76979_2_, double p_76979_4_, double p_76979_6_, float p_76979_8_, float tickOffset) {
        if (horse instanceof EntityMagicalHorse) {
            this.field_76989_e = ((EntityMagicalHorse)horse).hasDestrierBody() ? 1.4f : 0.7f;
        }
        super.func_76979_b(horse, p_76979_2_, p_76979_4_, p_76979_6_, p_76979_8_, tickOffset);
        this.renderRainbowBeam((EntityMagicalHorse)horse, tickOffset);
    }

    private void renderRainbowBeam(EntityMagicalHorse horse, float tickOffset) {
        if (horse.getHideType() == 5 && horse.getCharge() && horse.powerSettings.isEnabled(EntityMagicalHorse.OrderedPower.RAINBOW_BEAM)) {
            GL11.glAlphaFunc((int)516, (float)0.1f);
            float f1 = 1.0f;
            double playerXOffset = horse.field_70165_t - TileEntityRendererDispatcher.field_147554_b;
            double playerYOffset = horse.field_70163_u - TileEntityRendererDispatcher.field_147555_c;
            double playerZOffset = horse.field_70161_v - TileEntityRendererDispatcher.field_147552_d;
            double dist = 60.0;
            RayTraceResult target = horse.rayTraceHorn(60.0, tickOffset);
            Vec3d pos = null;
            if (null != target) {
                switch (target.field_72313_a) {
                    case BLOCK: {
                        BlockPos targetBlockPos = target.func_178782_a();
                        dist = horse.func_70011_f(targetBlockPos.func_177958_n(), targetBlockPos.func_177956_o(), targetBlockPos.func_177952_p()) + 0.1;
                        pos = new Vec3d((double)targetBlockPos.func_177958_n(), (double)targetBlockPos.func_177956_o(), (double)targetBlockPos.func_177952_p());
                        if (this.lastTarget != null && targetBlockPos.equals((Object)this.lastTarget.func_178782_a())) {
                            ++this.lastDamageCounter;
                            float limit = 2.6f * horse.field_70170_p.func_180495_p(targetBlockPos).func_185887_b(null, null);
                            if ((float)this.lastDamageCounter > limit) {
                                this.lastDamageCounter = 0;
                                ++this.lastDamage;
                                if (this.lastDamage > 9) {
                                    CombinedClientProxy.network.sendToServer((IMessage)new BreakBlockMessage(targetBlockPos.func_177958_n(), targetBlockPos.func_177956_o(), targetBlockPos.func_177952_p()));
                                }
                            }
                        } else {
                            this.lastDamageCounter = 0;
                            this.lastDamage = 0;
                        }
                        horse.field_70170_p.func_175715_c(horse.func_145782_y(), targetBlockPos, this.lastDamage);
                        this.lastTarget = target;
                        break;
                    }
                    case ENTITY: {
                        dist = horse.func_70011_f(target.field_72308_g.field_70165_t, target.field_72308_g.field_70163_u, target.field_72308_g.field_70161_v);
                        pos = new Vec3d(target.field_72308_g.field_70165_t, target.field_72308_g.field_70163_u, target.field_72308_g.field_70161_v);
                        break;
                    }
                }
            }
            if (null != pos) {
                Random rand = horse.field_70170_p.field_73012_v;
                for (int i = 0; i < 1; ++i) {
                    double d0 = rand.nextGaussian();
                    double d1 = rand.nextGaussian();
                    double d2 = rand.nextGaussian();
                    double d3 = rand.nextGaussian();
                    double d4 = rand.nextGaussian();
                    double d5 = rand.nextGaussian();
                    horse.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, pos.field_72450_a + d0, pos.field_72448_b + d1, pos.field_72449_c + d2, d3, d4, d5, new int[0]);
                }
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            this.func_110776_a(rainbowBeamTexture);
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
            float tickTime = (float)horse.field_70170_p.func_82737_E() + tickOffset;
            float f3 = -tickTime * 0.2f - (float)MathHelper.func_76141_d((float)(-tickTime * 0.1f));
            double d3 = (double)tickTime * 0.025 * -11.5;
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            double d5 = 0.2;
            double d7 = 0.0 + Math.cos(d3 + 2.356194490192345) * d5;
            double d9 = 0.0 + Math.sin(d3 + 2.356194490192345) * d5;
            double d11 = 0.0 + Math.cos(d3 + 0.7853981633974483) * d5;
            double d13 = 0.0 + Math.sin(d3 + 0.7853981633974483) * d5;
            double d15 = 0.0 + Math.cos(d3 + 3.9269908169872414) * d5;
            double d17 = 0.0 + Math.sin(d3 + 3.9269908169872414) * d5;
            double d19 = 0.0 + Math.cos(d3 + 5.497787143782138) * d5;
            double zAdd = 0.0 + Math.sin(d3 + 5.497787143782138) * d5;
            double maxY = dist * (double)f1;
            double d25 = 0.0;
            double textureWidth = 1.0;
            double textureHeight2 = -1.0f + f3;
            double textureHeight = (double)(256.0f * f1) * (0.5 / d5) + textureHeight2;
            double horseBodyOffset = 1.5;
            worldrenderer.func_181662_b(playerXOffset + d7, playerYOffset + maxY, playerZOffset + d9).func_187315_a(textureWidth, textureHeight).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d7, playerYOffset + horseBodyOffset, playerZOffset + d9).func_187315_a(textureWidth, textureHeight2).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d11, playerYOffset + horseBodyOffset, playerZOffset + d13).func_187315_a(d25, textureHeight2).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d11, playerYOffset + maxY, playerZOffset + d13).func_187315_a(d25, textureHeight).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d19, playerYOffset + maxY, playerZOffset + zAdd).func_187315_a(textureWidth, textureHeight).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d19, playerYOffset + horseBodyOffset, playerZOffset + zAdd).func_187315_a(textureWidth, textureHeight2).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d15, playerYOffset + horseBodyOffset, playerZOffset + d17).func_187315_a(d25, textureHeight2).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d15, playerYOffset + maxY, playerZOffset + d17).func_187315_a(d25, textureHeight).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d11, playerYOffset + maxY, playerZOffset + d13).func_187315_a(textureWidth, textureHeight).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d11, playerYOffset + horseBodyOffset, playerZOffset + d13).func_187315_a(textureWidth, textureHeight2).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d19, playerYOffset + horseBodyOffset, playerZOffset + zAdd).func_187315_a(d25, textureHeight2).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d19, playerYOffset + maxY, playerZOffset + zAdd).func_187315_a(d25, textureHeight).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d15, playerYOffset + maxY, playerZOffset + d17).func_187315_a(textureWidth, textureHeight).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d15, playerYOffset + horseBodyOffset, playerZOffset + d17).func_187315_a(textureWidth, textureHeight2).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d7, playerYOffset + horseBodyOffset, playerZOffset + d9).func_187315_a(d25, textureHeight2).func_181669_b(255, 255, 255, 255).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d7, playerYOffset + maxY, playerZOffset + d9).func_187315_a(d25, textureHeight).func_181669_b(255, 255, 255, 255).func_181675_d();
            GL11.glPushMatrix();
            double beamHeight = 0.6;
            double beamForward = 0.9;
            if (horse.hasDestrierBody()) {
                beamHeight = 1.5;
                beamForward = 2.3;
            }
            GL11.glTranslated((double)playerXOffset, (double)(playerYOffset + beamHeight), (double)playerZOffset);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)horse.field_70177_z, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
            GL11.glTranslated((double)(-playerXOffset), (double)(-playerYOffset + beamForward), (double)(-playerZOffset));
            tessellator.func_78381_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179132_a((boolean)false);
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            double d30 = -0.3;
            double d4 = -0.3;
            double d6 = 0.30000000000000004;
            double d8 = -0.3;
            double d10 = -0.3;
            double d12 = 0.30000000000000004;
            double d14 = 0.30000000000000004;
            double d16 = 0.30000000000000004;
            double maxY2 = dist * (double)f1;
            double d20 = 0.0;
            double d22 = 1.0;
            double d24 = -1.0f + f3;
            double d26 = (double)(256.0f * f1) + d24;
            worldrenderer.func_181662_b(playerXOffset + d30, playerYOffset + maxY2, playerZOffset + d4).func_187315_a(d22, d26).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d30, playerYOffset, playerZOffset + d4).func_187315_a(d22, d24).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d6, playerYOffset, playerZOffset + d8).func_187315_a(d20, d24).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d6, playerYOffset + maxY2, playerZOffset + d8).func_187315_a(d20, d26).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d14, playerYOffset + maxY2, playerZOffset + d16).func_187315_a(d22, d26).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d14, playerYOffset, playerZOffset + d16).func_187315_a(d22, d24).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d10, playerYOffset, playerZOffset + d12).func_187315_a(d20, d24).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d10, playerYOffset + maxY2, playerZOffset + d12).func_187315_a(d20, d26).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d6, playerYOffset + maxY2, playerZOffset + d8).func_187315_a(d22, d26).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d6, playerYOffset, playerZOffset + d8).func_187315_a(d22, d24).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d14, playerYOffset, playerZOffset + d16).func_187315_a(d20, d24).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d14, playerYOffset + maxY2, playerZOffset + d16).func_187315_a(d20, d26).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d10, playerYOffset + maxY2, playerZOffset + d12).func_187315_a(d22, d26).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d10, playerYOffset, playerZOffset + d12).func_187315_a(d22, d24).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d30, playerYOffset, playerZOffset + d4).func_187315_a(d20, d24).func_181669_b(255, 255, 255, 32).func_181675_d();
            worldrenderer.func_181662_b(playerXOffset + d30, playerYOffset + maxY2, playerZOffset + d4).func_187315_a(d20, d26).func_181669_b(255, 255, 255, 32).func_181675_d();
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    protected void func_180580_a(EntityMagicalHorse horse, float partialTickTime) {
        float f1 = 1.0f;
        int i = 0;
        if (i == 1) {
            f1 *= 0.87f;
        } else if (i == 2) {
            f1 *= 0.92f;
        }
        GlStateManager.func_179152_a((float)f1, (float)f1, (float)f1);
        super.func_77041_b((EntityLivingBase)horse, partialTickTime);
    }

    protected ResourceLocation getTextureResource(EntityMagicalHorse horse) {
        return this.getLayeredTextureResource(horse);
    }

    protected ResourceLocation getLayeredTextureResource(EntityMagicalHorse horse) {
        String s = horse.getHorseTexture();
        if (!horse.func_175507_cI()) {
            return null;
        }
        ResourceLocation resourcelocation = (ResourceLocation)pathnamesToTextures.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new HorseLayeredTexture(horse.func_95999_t(), horse.getVariantTexturePaths()));
            pathnamesToTextures.put(s, resourcelocation);
        }
        return resourcelocation;
    }

    protected void func_77041_b(EntityLivingBase entityLivingBase, float p_77041_2_) {
        this.func_180580_a((EntityMagicalHorse)entityLivingBase, p_77041_2_);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getTextureResource((EntityMagicalHorse)entity);
    }
}

