/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenUtil {
    public static void makeWall(int x, int y, int z, int length, int height, IBlockState blockState, World world) {
        WorldGenUtil.makeWall(x, y, z, length, height, blockState, world, EnumFacing.EAST);
    }

    public static void makeWall(int x, int y, int z, int length, int height, IBlockState blockState, World world, EnumFacing facing) {
        BlockPos pos = null;
        switch (facing) {
            case EAST: 
            case WEST: {
                for (int i = 0; i < length; ++i) {
                    for (int j = 0; j < height; ++j) {
                        pos = new BlockPos(x, y + j, z + i);
                        world.func_175656_a(pos, blockState);
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                for (int i = 0; i < length; ++i) {
                    for (int j = 0; j < height; ++j) {
                        pos = new BlockPos(x + i, y + j, z);
                        world.func_175656_a(pos, blockState);
                    }
                }
                break;
            }
            case UP: 
            case DOWN: {
                for (int i = 0; i < length; ++i) {
                    for (int j = 0; j < height; ++j) {
                        pos = new BlockPos(x + j, y, z + i);
                        world.func_175656_a(pos, blockState);
                    }
                }
                break;
            }
        }
    }

    public static void makeClosedBox(int x, int y, int z, int length, int height, int width, World world, IBlockState blockState) {
        BlockPos currPos = new BlockPos(x, y, z);
        WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o(), currPos.func_177952_p(), width, length, blockState, world, EnumFacing.DOWN);
        WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o() + 1, currPos.func_177952_p(), length, height, blockState, world, EnumFacing.NORTH);
        WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o() + 1, currPos.func_177952_p() + width - 1, length, height, blockState, world, EnumFacing.NORTH);
        WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o() + 1, currPos.func_177952_p() + 1, width - 2, height, blockState, world, EnumFacing.EAST);
        WorldGenUtil.makeWall(currPos.func_177958_n() + length - 1, currPos.func_177956_o() + 1, currPos.func_177952_p() + 1, width - 2, height, blockState, world, EnumFacing.EAST);
        WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o() + 1 + height, currPos.func_177952_p(), width, length, blockState, world, EnumFacing.DOWN);
    }

    public static void makeClosedBoxWithAir(int x, int y, int z, int length, int height, int width, World world, IBlockState blockState) {
        WorldGenUtil.makeClosedBox(x, y, z, length, height, width, world, blockState);
        WorldGenUtil.fillWith(x + 1, y + 1, z + 1, length - 2, height - 2, width - 2, world, Blocks.field_150350_a.func_176223_P());
    }

    public static void makeBox(int x, int y, int z, int length, int height, int width, World world, IBlockState ... blockStates) {
        BlockPos currPos = new BlockPos(x, y, z);
        if (blockStates.length > 0 && null != blockStates[0]) {
            WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o(), currPos.func_177952_p(), width, length, blockStates[0], world, EnumFacing.DOWN);
        }
        if (blockStates.length > 1 && null != blockStates[1]) {
            WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o() + 1 + height, currPos.func_177952_p(), width, length, blockStates[1], world, EnumFacing.DOWN);
        }
        if (blockStates.length > 2 && null != blockStates[2]) {
            WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o() + 1, currPos.func_177952_p(), length, height, blockStates[2], world, EnumFacing.NORTH);
        }
        if (blockStates.length > 3 && null != blockStates[3]) {
            WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o() + 1, currPos.func_177952_p() + width - 1, length, height, blockStates[3], world, EnumFacing.NORTH);
        }
        if (blockStates.length > 4 && null != blockStates[4]) {
            WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o() + 1, currPos.func_177952_p() + 1, width - 2, height, blockStates[4], world, EnumFacing.EAST);
        }
        if (blockStates.length > 5 && null != blockStates[5]) {
            WorldGenUtil.makeWall(currPos.func_177958_n() + length - 1, currPos.func_177956_o() + 1, currPos.func_177952_p() + 1, width - 2, height, blockStates[5], world, EnumFacing.EAST);
        }
    }

    public static void makeBoxWithAir(int x, int y, int z, int length, int height, int width, World world, IBlockState ... blockStates) {
        WorldGenUtil.makeBox(x, y, z, length, height, width, world, blockStates);
        WorldGenUtil.fillWith(x + 1, y + 1, z + 1, length - 2, height, width - 2, world, Blocks.field_150350_a.func_176223_P());
    }

    public static void makePillarBox(int x, int y, int z, int length, int height, int width, World world, IBlockState[] pillarBlockStates, IBlockState ... blockStates) {
        BlockPos currPos = new BlockPos(x, y, z);
        if (blockStates.length > 0 && null != blockStates[0]) {
            WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o(), currPos.func_177952_p(), width, length, blockStates[0], world, EnumFacing.DOWN);
        }
        if (blockStates.length > 1 && null != blockStates[1]) {
            WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o() + 1 + height, currPos.func_177952_p(), width, length, blockStates[1], world, EnumFacing.DOWN);
        }
        if (blockStates.length > 2 && null != blockStates[2]) {
            WorldGenUtil.makeWall(currPos.func_177958_n() + 1, currPos.func_177956_o() + 1, currPos.func_177952_p(), length - 2, height, blockStates[2], world, EnumFacing.NORTH);
        }
        if (blockStates.length > 3 && null != blockStates[3]) {
            WorldGenUtil.makeWall(currPos.func_177958_n() + 1, currPos.func_177956_o() + 1, currPos.func_177952_p() + width - 1, length - 2, height, blockStates[3], world, EnumFacing.NORTH);
        }
        if (blockStates.length > 4 && null != blockStates[4]) {
            WorldGenUtil.makeWall(currPos.func_177958_n(), currPos.func_177956_o() + 1, currPos.func_177952_p() + 1, width - 2, height, blockStates[4], world, EnumFacing.EAST);
        }
        if (blockStates.length > 5 && null != blockStates[5]) {
            WorldGenUtil.makeWall(currPos.func_177958_n() + length - 1, currPos.func_177956_o() + 1, currPos.func_177952_p() + 1, width - 2, height, blockStates[5], world, EnumFacing.EAST);
        }
        int[] coords = new int[]{0, length - 1, 0, width - 1};
        for (int i = 0; i < 4 && i < pillarBlockStates.length; ++i) {
            if (null == pillarBlockStates[i]) continue;
            WorldGenUtil.makeWall(x + coords[i / 2], y + 1, z + coords[i % 2 + 2], 1, height, pillarBlockStates[i], world, EnumFacing.EAST);
        }
    }

    public static void makePillarBoxWithAir(int x, int y, int z, int length, int height, int width, World world, IBlockState[] pillarBlockStates, IBlockState ... blockStates) {
        WorldGenUtil.makePillarBox(x, y, z, length, height, width, world, pillarBlockStates, blockStates);
        WorldGenUtil.fillWith(x + 1, y + 1, z + 1, length - 2, height, width - 2, world, Blocks.field_150350_a.func_176223_P());
    }

    public static void fillWith(int x, int y, int z, int length, int height, int width, World world, IBlockState blockState) {
        for (int i = x; i < x + length; ++i) {
            for (int j = y; j < y + height; ++j) {
                for (int k = z; k < z + width; ++k) {
                    world.func_175656_a(new BlockPos(i, j, k), blockState);
                }
            }
        }
    }
}

