/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn;

import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChargeUnicornMessage {
    private String text;
    private BlockPos targetPos = null;

    public ChargeUnicornMessage() {
        this.text = "charge";
    }

    public ChargeUnicornMessage(BlockPos targetPos) {
        this.text = null != targetPos ? "charge1" : "charge";
        this.targetPos = targetPos;
    }

    public String getText() {
        return this.text;
    }

    public static ChargeUnicornMessage decode(PacketBuffer buf) {
        String text = buf.func_218666_n();
        if ("charge1".equals(text)) {
            BlockPos targetPos = buf.func_179259_c();
            return new ChargeUnicornMessage(targetPos);
        }
        return new ChargeUnicornMessage();
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public static void encode(ChargeUnicornMessage message, PacketBuffer buf) {
        buf.func_180714_a(message.getText());
        if (null != message.getTargetPos()) {
            buf.func_179255_a(message.getTargetPos());
        }
    }

    public static class Handler {
        public static void handle(ChargeUnicornMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (null != player.func_184187_bx()) {
                    if (player.func_184187_bx() instanceof EntityMagicalHorse) {
                        EntityMagicalHorse horse = (EntityMagicalHorse)player.func_184187_bx();
                        horse.chargeCounter = 1;
                        horse.shootTargetPos = message.getTargetPos();
                    }
                    ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                }
            });
        }
    }
}

