/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn;

import com.hackshop.ultimate_unicorn.CombinedClientProxy;
import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.Config;
import com.hackshop.ultimate_unicorn.DedicatedServerProxy;
import com.hackshop.ultimate_unicorn.IProxy;
import com.hackshop.ultimate_unicorn.UpdateChecker;
import com.hackshop.ultimate_unicorn.blocks.ContainerMagicalHorseInventory;
import com.hackshop.ultimate_unicorn.commands.ChangeHorseCommand;
import com.hackshop.ultimate_unicorn.gui.ChatFormatting;
import com.hackshop.ultimate_unicorn.gui.TextUtil;
import com.hackshop.ultimate_unicorn.gui.UrlOpenStyle;
import com.hackshop.ultimate_unicorn.init.ModBlocks;
import com.hackshop.ultimate_unicorn.init.ModContainerTypes;
import com.hackshop.ultimate_unicorn.init.ModEntities;
import com.hackshop.ultimate_unicorn.init.ModItems;
import com.hackshop.ultimate_unicorn.init.ModTileEntityTypes;
import com.hackshop.ultimate_unicorn.input.KeyBindings;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.renderer.MagicalHorseRenderer;
import com.hackshop.ultimate_unicorn.network.PacketHandler;
import com.mojang.brigadier.CommandDispatcher;
import java.net.URI;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RabbitRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ultimate_unicorn_mod")
public class UltimateUnicornMod {
    public static UltimateUnicornMod instance;
    public static final String CURRENT_VERSION = "1.5.16";
    public static final String MODID = "ultimate_unicorn_mod";
    public static IProxy proxy;
    public static boolean welcomeDone;
    public static final Logger LOGGER;

    public UltimateUnicornMod() {
        LOGGER.debug("The Ultimate Unicorn Mod!");
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_SPEC, "ultimate_unicorn_mod.toml");
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        modEventBus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModContainerTypes.CONTAINER_TYPES.register(modEventBus);
        ModTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.UNICORN.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.PEGASUS.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.DESTRIER.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.NIGHTMARE.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.DEER.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.HIPPOCAMP.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.KIRIN.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.MAGICAL_HORSE.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.ALEA.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.VELVET.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.TYPHON.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.ASMIDISKE.get()), MagicalHorseRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.FOLLOWER_BUNNY.get()), RabbitRenderer::new);
        CommonProxy.init();
        PacketHandler.register();
        KeyBindings.init();
        UpdateChecker.checkVersion(CURRENT_VERSION);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        CommandDispatcher commandDispatcher = event.getCommandDispatcher();
        ChangeHorseCommand.register((CommandDispatcher<CommandSource>)commandDispatcher);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!welcomeDone && !((Boolean)Config.COMMON.disable_notifications.get()).booleanValue()) {
            welcomeDone = true;
            UpdateChecker.UpdateProperties props = UpdateChecker.getProperties();
            if (UpdateChecker.isNewVersionAvailable()) {
                TextUtil.FormattedUrlChatMessage fucMsg;
                int j;
                String[] rawMsgs;
                if (null != props && null != props.getNewVersionMessage()) {
                    rawMsgs = props.getNewVersionMessage();
                    for (j = 0; j < rawMsgs.length; ++j) {
                        fucMsg = TextUtil.formatUrlChatMessage(rawMsgs[j]);
                        this.sendMessage(fucMsg.formattedMessage, fucMsg.url);
                    }
                } else {
                    LanguageMap langMap = LanguageMap.func_74808_a();
                    String newVersion = I18n.func_135052_a((String)"inventoryUI.newVersion", (Object[])new Object[0]);
                    String newVersion2 = I18n.func_135052_a((String)"inventoryUI.newVersion2", (Object[])new Object[0]);
                    String newVersion3 = "http://hackshop.com/download";
                    this.sendMessage(newVersion, newVersion3);
                    this.sendMessage(newVersion2 + " " + (Object)((Object)ChatFormatting.RED) + newVersion3, newVersion3);
                }
                if (null != props && null != props.getWhatsNewMessage()) {
                    rawMsgs = props.getWhatsNewMessage();
                    for (j = 0; j < rawMsgs.length; ++j) {
                        fucMsg = TextUtil.formatUrlChatMessage(rawMsgs[j]);
                        this.sendMessage(fucMsg.formattedMessage, fucMsg.url);
                    }
                } else {
                    String hackshopAd = I18n.func_135052_a((String)"inventoryUI.whatsNew", (Object[])new Object[0]);
                    String hackshopAd2 = "http://hackshop.com/new";
                    this.sendMessage(hackshopAd + " " + (Object)((Object)ChatFormatting.RED) + hackshopAd2, hackshopAd2);
                }
            }
            if (null != props && props.getStartupMessageCount() > 0) {
                for (int i = 0; i < props.getStartupMessageCount(); ++i) {
                    String[] rawMsgs = props.getStartupMessage(i);
                    for (int j = 0; j < rawMsgs.length; ++j) {
                        TextUtil.FormattedUrlChatMessage fucMsg = TextUtil.formatUrlChatMessage(rawMsgs[j]);
                        this.sendMessage(fucMsg.formattedMessage, fucMsg.url);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void sendMessage(String message, String url) {
        StringTextComponent t = new StringTextComponent(message);
        UrlOpenStyle uos = new UrlOpenStyle(t.func_150256_b(), url);
        t.func_150255_a((Style)uos);
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)t);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openUrl(URI uri) {
        try {
            Util.func_110647_a().func_195642_a(uri);
        }
        catch (Throwable throwable) {
            LOGGER.error("Couldn't open link", throwable);
        }
    }

    static {
        proxy = (IProxy)DistExecutor.runForDist(() -> () -> new CombinedClientProxy(), () -> () -> new DedicatedServerProxy());
        welcomeDone = false;
        LOGGER = LogManager.getLogger((String)MODID);
    }

    @Mod.EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void containerOpen(EntityMagicalHorse.OpenUnicornInventory event) {
            if (event.getContainer() instanceof ContainerMagicalHorseInventory) {
                LOGGER.info("Open Inventory");
                ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
                ContainerMagicalHorseInventory oldContainer = (ContainerMagicalHorseInventory)event.getContainer();
                EntityMagicalHorse unicorn = oldContainer.getUnicorn();
                IInventory horseInventory = oldContainer.getHorseInventory();
                if (player != null && unicorn != null && horseInventory != null) {
                    player.field_71070_bA = new ContainerMagicalHorseInventory(player.field_71139_cq, player.field_71071_by, horseInventory, unicorn);
                    player.field_71070_bA.func_75132_a((IContainerListener)player);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

