/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.chat.ai;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class OracleAI {
    private static final String[] supportedLangs = new String[]{"en_US", "pt_BR"};
    private static final HashMap<String, Responses> langMappings = new HashMap<String, Responses>(){

        @Override
        public Responses get(Object key) {
            if (null == super.get(key)) {
                return (Responses)super.get("en_US");
            }
            return (Responses)super.get(key);
        }
    };
    static final Gson SERIALIZER = new Gson();

    public String getDefaultResponse() {
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String lang = language.getCode();
        Responses r = langMappings.get(lang);
        return r.defaultResponse;
    }

    public String getConversationStarter() {
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String lang = language.getCode();
        Responses r = langMappings.get(lang);
        return r.defaultResponse;
    }

    public String getConversationEnder() {
        return "";
    }

    public String getResponse(String userSaid) {
        System.out.println("userSaid: " + userSaid);
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String lang = language.getCode();
        Responses responses = langMappings.get(lang);
        String lowercase = userSaid.toLowerCase();
        String[] words = lowercase.split("\\s+");
        for (String string : words) {
            System.out.println("word: " + string);
        }
        for (Map.Entry entry : responses.phrasesToResponses.entrySet()) {
            if (!lowercase.contains((CharSequence)entry.getKey())) continue;
            return (String)entry.getValue();
        }
        for (Map.Entry entry : responses.setsToResponses.entrySet()) {
            boolean found = true;
            for (String k : (String[])entry.getKey()) {
                if (lowercase.contains(k)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return (String)entry.getValue();
        }
        for (String string : words) {
            String response = responses.wordsToResponses.get(string.trim());
            if (null == response) continue;
            return response;
        }
        return responses.defaultResponse;
    }

    static {
        for (String lang : supportedLangs) {
            StringBuilder builder = new StringBuilder();
            ResourceLocation speechText = new ResourceLocation("ultimate_unicorn_mod", "texts/oracle_speech_" + lang + ".txt");
            try {
                IResource r = Minecraft.func_71410_x().func_195551_G().func_199002_a(speechText);
                BufferedReader reader = new BufferedReader(new InputStreamReader(r.func_199027_b()));
                while (reader.ready()) {
                    builder.append(reader.readLine());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            MappingFile mappingFile = (MappingFile)SERIALIZER.fromJson(builder.toString(), MappingFile.class);
            Responses responses = new Responses(mappingFile);
            langMappings.put(lang, responses);
        }
    }

    static class MappingFile {
        String defaultResponse;
        Mapping[] mappings;

        MappingFile() {
        }
    }

    static class Mapping {
        String response;
        String[] simple_keys;
        String[] logic_keys;
        String[] phrase_keys;

        Mapping() {
        }
    }

    static class Responses {
        public final String defaultResponse;
        public final HashMap<String, String> wordsToResponses = new HashMap();
        public final HashMap<String, String> phrasesToResponses = new HashMap();
        public final HashMap<String[], String> setsToResponses = new HashMap();

        Responses(MappingFile mappingFile) {
            for (Mapping m : mappingFile.mappings) {
                if (null != m.simple_keys) {
                    for (String s : m.simple_keys) {
                        this.wordsToResponses.put(s, m.response);
                    }
                }
                if (null != m.phrase_keys) {
                    for (String s : m.phrase_keys) {
                        this.phrasesToResponses.put(s, m.response);
                    }
                }
                if (null == m.logic_keys) continue;
                for (String s : m.logic_keys) {
                    String[] strs = s.split("\\s*&&\\s*");
                    this.setsToResponses.put(strs, m.response);
                }
            }
            this.defaultResponse = mappingFile.defaultResponse;
        }
    }
}

