/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BetterDownloadingTexture
extends SimpleTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private final File cacheFile;
    private final String imageUrl;
    @Nullable
    private final Runnable processTask;
    @Nullable
    private CompletableFuture<?> future;
    private boolean textureUploaded;
    private NativeImage nativeImage;
    private ByteBuffer byteBuffer;

    public NativeImage getNativeImage() {
        return this.nativeImage;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public BetterDownloadingTexture(@Nullable File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, @Nullable Runnable processTaskIn) {
        super(textureResourceLocation);
        this.cacheFile = cacheFileIn;
        this.imageUrl = imageUrlIn;
        this.processTask = processTaskIn;
    }

    private void setImage(NativeImage nativeImageIn) {
        this.nativeImage = nativeImageIn;
        if (this.processTask != null) {
            this.processTask.run();
        }
        Minecraft.func_71410_x().execute(() -> {
            this.textureUploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
            } else {
                this.upload(nativeImageIn);
            }
        });
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
        Minecraft.func_71410_x().execute(() -> {
            if (!this.textureUploaded) {
                try {
                    super.func_195413_a(manager);
                }
                catch (IOException var3) {
                    LOGGER.warn("Failed to load texture: {}", (Object)this.field_110568_b, (Object)var3);
                }
                this.textureUploaded = true;
            }
        });
        if (this.future == null) {
            NativeImage nativeimage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                nativeimage = this.loadTexture(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.setImage(nativeimage);
            } else {
                this.future = CompletableFuture.runAsync(() -> {
                    HttpURLConnection httpurlconnection = null;
                    LOGGER.debug("Downloading http texture from {} to {}", (Object)this.imageUrl, (Object)this.cacheFile);
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputstream;
                            if (this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.cacheFile);
                                inputstream = new FileInputStream(this.cacheFile);
                            } else {
                                inputstream = httpurlconnection.getInputStream();
                            }
                            Minecraft.func_71410_x().execute(() -> {
                                NativeImage nativeimage1 = this.loadTexture(inputstream);
                                if (nativeimage1 != null) {
                                    this.setImage(nativeimage1);
                                }
                            });
                            return;
                        }
                    }
                    catch (Exception var6) {
                        LOGGER.error("Couldn't download http texture", (Throwable)var6);
                        return;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }, Util.func_215072_e());
            }
        }
    }

    @Nullable
    private NativeImage loadTexture(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            this.byteBuffer = TextureUtil.func_225684_a_((InputStream)inputStreamIn);
            this.byteBuffer.rewind();
            nativeimage = NativeImage.func_195704_a((ByteBuffer)this.byteBuffer);
        }
        catch (IOException var4) {
            LOGGER.warn("Error while loading the skin texture", (Throwable)var4);
        }
        return nativeimage;
    }

    private static void setAreaTransparent(NativeImage image, int x, int y, int width, int height) {
        int i1;
        int l;
        for (l = x; l < width; ++l) {
            for (i1 = y; i1 < height; ++i1) {
                int k = image.func_195709_a(l, i1);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (l = x; l < width; ++l) {
            for (i1 = y; i1 < height; ++i1) {
                image.func_195700_a(l, i1, image.func_195709_a(l, i1) & 0xFFFFFF);
            }
        }
    }

    private static void setAreaOpaque(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                image.func_195700_a(i, j, image.func_195709_a(i, j) | 0xFF000000);
            }
        }
    }
}

