/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.mobs.renderer;

import com.google.common.collect.Maps;
import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.custom.CustomHorseInfo;
import com.hackshop.ultimate_unicorn.custom.HorseLayeredTexture;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.model.ModelMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.renderer.HorseArmorLayer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MagicalHorseRenderer
extends AbstractHorseRenderer<EntityMagicalHorse, ModelMagicalHorse<EntityMagicalHorse>> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();

    public MagicalHorseRenderer(EntityRendererManager p_i47205_1_) {
        super(p_i47205_1_, new ModelMagicalHorse(0.0f), 1.1f);
        this.func_177094_a(new HorseArmorLayer((IEntityRenderer<EntityMagicalHorse, ModelMagicalHorse<EntityMagicalHorse>>)this));
    }

    public ResourceLocation getEntityTexture(EntityMagicalHorse unicorn) {
        String textureString = unicorn.getHorseTexture();
        ResourceLocation texResourceLoc = LAYERED_LOCATION_CACHE.get(textureString);
        if (texResourceLoc == null) {
            CustomHorseInfo chi;
            String texResName = "";
            ITextComponent customName = unicorn.func_200201_e();
            boolean done = false;
            if (customName != null && (chi = CommonProxy.customHorseData.get(customName.getString().toLowerCase())) != null && (chi.isReady() || chi.isInMod())) {
                texResName = chi.texture;
                texResourceLoc = new ResourceLocation(textureString);
                if (chi.isInMod()) {
                    Minecraft.func_71410_x().func_110434_K().func_229263_a_(texResourceLoc, (Texture)new LayeredTexture(unicorn.getVariantTexturePaths()));
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_229263_a_(texResourceLoc, (Texture)new HorseLayeredTexture(chi, unicorn.getVariantTexturePaths()));
                }
                done = true;
            }
            if (!done) {
                texResourceLoc = new ResourceLocation(textureString);
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(texResourceLoc, (Texture)new LayeredTexture(unicorn.getVariantTexturePaths()));
            }
            LAYERED_LOCATION_CACHE.put(textureString, texResourceLoc);
        }
        return texResourceLoc;
    }

    public void render(EntityMagicalHorse p_225623_1_, float p_225623_2_, float p_225623_3_, MatrixStack p_225623_4_, IRenderTypeBuffer p_225623_5_, int p_225623_6_) {
        super.func_225623_a_((MobEntity)p_225623_1_, p_225623_2_, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_);
    }

    protected void preRenderCallback(EntityMagicalHorse horse, MatrixStack matrixStack, float partialTickTime) {
        if (horse.hasDestrierBody()) {
            matrixStack.func_227862_a_(1.8f, 1.8f, 1.8f);
        }
    }
}

