/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.mobs.unique;

import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.custom.PowerAccessor;
import com.hackshop.ultimate_unicorn.gui.ChatFormatting;
import com.hackshop.ultimate_unicorn.init.ModEntities;
import com.hackshop.ultimate_unicorn.mobs.EntityFollowerBunny;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.GeneEnum;
import com.hackshop.ultimate_unicorn.mobs.magicalhorse.Temperament;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityVelvetMysticalHealer
extends EntityMagicalHorse {
    public static final int archetypeDna1 = 0 | GeneEnum.HORN.mask | GeneEnum.WINGS.mask | 3 << GeneEnum.HIDE.offset | 3 << GeneEnum.HIDE.offset + 4;
    public static final int archetypeDna2 = 0;
    private static VelvetSummonBunniesPower velvetSummonBunniesPower = new VelvetSummonBunniesPower();

    public EntityVelvetMysticalHealer(EntityType<? extends EntityVelvetMysticalHealer> entityType, World worldIn) {
        super(entityType, worldIn, archetypeDna1, 0);
        this.temperament = Temperament.SKITTISH;
        this.setPowers();
        this.func_200203_b((ITextComponent)new StringTextComponent("Velvet"));
    }

    @Override
    public int func_190676_dC() {
        return 100;
    }

    @Override
    public void setPowers() {
        this.powers = new PowerAccessor[3];
        this.powers[0] = new PowerAccessor(AbstractPower.allPowers[8], this.powerSettings);
        this.powers[1] = new PowerAccessor(AbstractPower.allSuperchargedPowers[3], this.powerSettings);
        this.powers[2] = new PowerAccessor(velvetSummonBunniesPower, this.powerSettings);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        if (CommonProxy.config.useOldHorseHealthMax) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(this.getRandomBaseHealth() + 14.0f));
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.234);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public int getArchetypeDna1() {
        return archetypeDna1;
    }

    @Override
    public int getArchetypeDna2() {
        return 0;
    }

    @Override
    public void doRearingKick() {
    }

    @Override
    public ITextComponent func_145748_c_() {
        String name = this.func_200200_C_().getString() + ", " + (Object)((Object)ChatFormatting.GOLD) + this.getTitle();
        StringTextComponent chatcomponenttext = new StringTextComponent(name);
        chatcomponenttext.func_150256_b().func_150209_a(this.func_174823_aP());
        chatcomponenttext.func_150256_b().func_179989_a(this.func_110124_au().toString());
        return chatcomponenttext;
    }

    @Override
    public boolean hasTitle() {
        return true;
    }

    @Override
    public String getTitle() {
        return "Mystical Healer";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getBaseTexture() {
        return "ultimate_unicorn_mod:textures/entity/unique/velvet.png";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getBaseTexturePrefix() {
        return "uniq_velvet_";
    }

    @Override
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficulty, reason, livingData, dataTag);
        this.func_110234_j(true);
        this.field_110296_bG.func_70299_a(0, new ItemStack((IItemProvider)Items.field_151141_av));
        this.func_70873_a(0);
        return data;
    }

    public static class VelvetSummonBunniesPower
    extends AbstractPower {
        private static final int period = 40;

        public VelvetSummonBunniesPower() {
            super(true);
            this.name = I18n.func_135052_a((String)"power.animalFriendship", (Object[])new Object[0]);
        }

        @Override
        public EntityMagicalHorse.OrderedPower getOrderedPower() {
            return EntityMagicalHorse.OrderedPower.ANIMAL_FRIENDSHIP;
        }

        @Override
        public void doAuraPower(EntityMagicalHorse horse, int auraCounter) {
            World worldObj = horse.func_130014_f_();
            if (!worldObj.field_72995_K && !CommonProxy.config.suppressBunnies && auraCounter % 40 == 0) {
                BlockPos entityPos;
                BlockPos oneDown;
                List list = horse.field_70170_p.func_175647_a(RabbitEntity.class, horse.func_174813_aQ().func_72314_b(50.0, 12.0, 50.0), null);
                if (list.size() < CommonProxy.config.maxBunnies && worldObj.func_180495_p(oneDown = (entityPos = horse.func_180425_c()).func_177977_b()).func_185904_a() != Material.field_151579_a) {
                    Random rand = worldObj.field_73012_v;
                    double x = rand.nextDouble() * 10.0 + 14.0;
                    double z = rand.nextDouble() * 10.0 + 14.0;
                    if (rand.nextBoolean()) {
                        x = -x;
                    }
                    if (rand.nextBoolean()) {
                        z = -z;
                    }
                    BlockPos pos = worldObj.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos((Vec3i)entityPos.func_177963_a(x, 0.0, z))).func_177977_b();
                    BlockState up = worldObj.func_180495_p(pos.func_177984_a());
                    if (Math.abs(pos.func_177956_o() - entityPos.func_177956_o()) < 8 && !up.func_185904_a().func_76224_d() && !up.func_185904_a().func_76220_a()) {
                        EntityFollowerBunny bunny = new EntityFollowerBunny((EntityType<? extends EntityFollowerBunny>)((EntityType)ModEntities.FOLLOWER_BUNNY.get()), worldObj);
                        bunny.func_70107_b(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                        worldObj.func_217376_c((Entity)bunny);
                    }
                }
                ServerWorld serverWorld = (ServerWorld)worldObj;
                for (Object o : list) {
                    if (o instanceof EntityFollowerBunny) continue;
                    RabbitEntity r = (RabbitEntity)o;
                    BlockPos pos = r.func_180425_c();
                    EntityFollowerBunny b = new EntityFollowerBunny((EntityType<? extends EntityFollowerBunny>)((EntityType)ModEntities.FOLLOWER_BUNNY.get()), worldObj);
                    b.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    serverWorld.func_217467_h((Entity)r);
                    serverWorld.func_217376_c((Entity)b);
                }
            }
        }
    }
}

