/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.MagicEffectMessage;
import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;

public class HealingHorn
extends AbstractPower {
    public HealingHorn(boolean b) {
        super(b);
        this.name = LanguageRegistry.instance().getStringLocalization("power.healingHorn");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.HEALING_HORN;
    }

    @Override
    public boolean doHornPower(EntityMagicalHorse horse) {
        if (horse.hasHorn()) {
            float ff = 1.0f;
            float healAmount = 3.0f;
            float selfAmount = 1.0f;
            int effectSize = 2;
            if (this.supercharged) {
                healAmount = 6.5f;
                selfAmount = 2.0f;
                effectSize = 3;
            }
            for (Object e : horse.field_70170_p.func_72872_a(EntityLivingBase.class, horse.field_70121_D.func_72325_c((double)(-MathHelper.func_76126_a((float)(horse.field_70177_z * (float)Math.PI / 180.0f)) * ff), 0.0, (double)(MathHelper.func_76134_b((float)(horse.field_70177_z * (float)Math.PI / 180.0f)) * ff)))) {
                EntityLivingBase targetEntity = (EntityLivingBase)e;
                if (null != horse && targetEntity.func_70662_br()) {
                    if (null != horse.field_70153_n) {
                        targetEntity.func_70097_a(DamageSource.func_76354_b((Entity)horse.field_70153_n, (Entity)targetEntity), healAmount + 1.0f);
                    } else {
                        targetEntity.func_70097_a(DamageSource.func_76354_b((Entity)horse, (Entity)targetEntity), healAmount + 1.0f);
                    }
                }
                if (e instanceof EntityMob) continue;
                if (null != horse && targetEntity.func_70662_br()) {
                    if (null != horse.field_70153_n) {
                        targetEntity.func_70097_a(DamageSource.func_76354_b((Entity)horse.field_70153_n, (Entity)targetEntity), healAmount / 2.0f);
                    } else {
                        targetEntity.func_70097_a(DamageSource.func_76354_b((Entity)horse, (Entity)targetEntity), healAmount / 2.0f);
                    }
                }
                float h = targetEntity.func_110143_aJ();
                if (e == horse || e == horse.field_70153_n) {
                    targetEntity.func_70691_i(selfAmount);
                } else {
                    targetEntity.func_70691_i(healAmount);
                }
                float h2 = targetEntity.func_110143_aJ();
                boolean wasOnFire = targetEntity.func_70027_ad();
                targetEntity.func_70066_B();
                if (!wasOnFire && !(h2 > h)) continue;
                MagicEffectMessage msg = new MagicEffectMessage(targetEntity.func_145782_y());
                msg.particleId1 = "mobSpell";
                msg.val1 = 0.9f;
                msg.val2 = 0.4f;
                msg.val3 = 0.4f;
                if (wasOnFire) {
                    msg.particleId2 = "water drop";
                }
                msg.amount1 = effectSize;
                CommonProxy.network.sendToAllAround((IMessage)msg, new NetworkRegistry.TargetPoint(targetEntity.field_71093_bK, targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v, 40.0));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNonCombatant() {
        return true;
    }
}

