/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.projectile.EntityIceBall;
import com.hackshop.ultimate_unicorn.util.BlockPos;
import com.hackshop.ultimate_unicorn.util.Vector;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class IcyWingBuffet
extends AbstractPower {
    public static final float ext = 0.96f;
    public static final float ext2 = 0.35999998f;

    public IcyWingBuffet(boolean b) {
        super(b);
        this.name = LanguageRegistry.instance().getStringLocalization("power.icyWingBuffet");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.ICY_WING_BUFFET;
    }

    @Override
    public void doBuffetPower(EntityMagicalHorse horse, int buffetCooldownCounter, float forward, float sides, float up) {
        if (this.supercharged) {
            forward = (float)((double)forward * 1.2);
            sides = (float)((double)sides * 1.1);
        }
        int maxDir = (int)((double)forward * 3.5);
        int maxWidth = (int)sides;
        float v2 = -MathHelper.func_76126_a((float)(horse.field_70177_z * (float)Math.PI / 180.0f));
        float v3 = MathHelper.func_76134_b((float)(horse.field_70177_z * (float)Math.PI / 180.0f));
        Vec3 vLeft = Vec3.func_72443_a((double)v2, (double)0.0, (double)v3).func_72432_b();
        Vec3 vRight = Vec3.func_72443_a((double)v2, (double)0.0, (double)v3).func_72432_b();
        vLeft.func_72442_b(0.5235988f);
        vRight.func_72442_b(-0.5235988f);
        Vec3 vPerp = Vec3.func_72443_a((double)v2, (double)0.0, (double)v3).func_72432_b();
        vPerp.func_72442_b(-1.5707964f);
        Vec3 vPerpSide = Vec3.func_72443_a((double)(vPerp.field_72450_a * (double)maxWidth), (double)(vPerp.field_72448_b * (double)maxWidth), (double)(vPerp.field_72449_c * (double)maxWidth));
        Vec3 startPos = Vector.getPositionVector((Entity)horse).func_72441_c(vPerpSide.field_72450_a, vPerpSide.field_72448_b, vPerpSide.field_72449_c);
        Vec3 startPos2 = Vector.getPositionVector((Entity)horse).func_72441_c(vPerpSide.field_72450_a, vPerpSide.field_72448_b, vPerpSide.field_72449_c);
        Vec3 endPos = Vector.getPositionVector((Entity)horse).func_72441_c(-vPerpSide.field_72450_a, -vPerpSide.field_72448_b, -vPerpSide.field_72449_c);
        int counter = 0;
        if (!horse.field_70170_p.field_72995_K) {
            Material m;
            Block b;
            BlockPos bPos;
            int k;
            int i;
            Vec3 current;
            while (startPos.func_72444_a(endPos).func_72433_c() > 0.2 && counter < 100) {
                ++counter;
                current = Vec3.func_72443_a((double)startPos.field_72450_a, (double)startPos.field_72448_b, (double)startPos.field_72449_c);
                for (i = 0; i < maxDir; ++i) {
                    for (k = -1; k < 2; ++k) {
                        bPos = new BlockPos(current.func_72441_c(0.0, (double)k, 0.0));
                        b = horse.field_70170_p.func_147439_a(bPos.x, bPos.y, bPos.z);
                        m = b.func_149688_o();
                        if (m == Material.field_151586_h) {
                            horse.field_70170_p.func_147449_b(bPos.x, bPos.y, bPos.z, Blocks.field_150432_aD);
                            continue;
                        }
                        if (m == Material.field_151587_i) {
                            horse.field_70170_p.func_147449_b(bPos.x, bPos.y, bPos.z, Blocks.field_150348_b);
                            continue;
                        }
                        if (m != Material.field_151581_o) continue;
                        horse.field_70170_p.func_147449_b(bPos.x, bPos.y, bPos.z, Blocks.field_150350_a);
                    }
                    current = current.func_72441_c(vLeft.field_72450_a, vLeft.field_72448_b, vLeft.field_72449_c);
                }
                startPos = startPos.func_72441_c(-vPerp.field_72450_a, -vPerp.field_72448_b, -vPerp.field_72449_c);
            }
            counter = 0;
            while (startPos2.func_72444_a(endPos).func_72433_c() > 1.0 && counter < 100) {
                ++counter;
                current = Vec3.func_72443_a((double)endPos.field_72450_a, (double)endPos.field_72448_b, (double)endPos.field_72449_c);
                for (i = 0; i < maxDir; ++i) {
                    for (k = -1; k < 4; ++k) {
                        bPos = new BlockPos(current.func_72441_c(0.0, (double)k, 0.0));
                        b = horse.field_70170_p.func_147439_a(bPos.x, bPos.y, bPos.z);
                        m = b.func_149688_o();
                        if (m == Material.field_151586_h) {
                            horse.field_70170_p.func_147449_b(bPos.x, bPos.y, bPos.z, Blocks.field_150432_aD);
                            continue;
                        }
                        if (m == Material.field_151587_i) {
                            horse.field_70170_p.func_147449_b(bPos.x, bPos.y, bPos.z, Blocks.field_150348_b);
                            continue;
                        }
                        if (m != Material.field_151581_o) continue;
                        horse.field_70170_p.func_147449_b(bPos.x, bPos.y, bPos.z, Blocks.field_150350_a);
                    }
                    current = current.func_72441_c(vRight.field_72450_a, vRight.field_72448_b, vRight.field_72449_c);
                }
                endPos = endPos.func_72441_c(vPerp.field_72450_a, vPerp.field_72448_b, vPerp.field_72449_c);
            }
        }
        if (this.supercharged) {
            this.shootSnowballs(horse, buffetCooldownCounter);
        }
    }

    public void shootSnowballs(EntityMagicalHorse horse, int buffetCooldownCounter) {
        if (buffetCooldownCounter % 9 == 6 && this.isNearIce(horse.field_70170_p, new BlockPos((int)horse.field_70165_t, (int)horse.field_70163_u, (int)horse.field_70161_v))) {
            Vec3 lookVec = null != horse.field_70153_n ? horse.field_70153_n.func_70040_Z() : horse.func_70040_Z();
            float f2 = MathHelper.func_76126_a((float)(1.5707964f + horse.field_70177_z * (float)Math.PI / 180.0f));
            float f3 = MathHelper.func_76134_b((float)(1.5707964f + horse.field_70177_z * (float)Math.PI / 180.0f));
            double x = 0.96f * f2;
            double z = -0.96f * f3;
            if (horse.hasDestrierBody()) {
                x *= (double)1.6f;
                z *= (double)1.6f;
            }
            double x2 = 0.35999998f * f2;
            double z2 = -0.35999998f * f3;
            for (int i = 0; i < 3; ++i) {
                EntityIceBall sfb = new EntityIceBall(horse.field_70170_p, (EntityLivingBase)horse);
                sfb.func_70107_b(horse.field_70165_t + lookVec.field_72450_a * (double)1.8f + x * (double)i, horse.field_70163_u + (double)horse.func_70047_e() + lookVec.field_72448_b * (double)1.8f, horse.field_70161_v + lookVec.field_72449_c * (double)1.8f + z * (double)i);
                if (horse.field_70170_p.field_72995_K) {
                    sfb.func_70016_h(lookVec.field_72450_a * 2.5 + horse.field_70159_w + x2 * (double)i, lookVec.field_72448_b * 2.5 + horse.field_70181_x, lookVec.field_72449_c * 2.5 + horse.field_70179_y + z2 * (double)i);
                }
                horse.field_70170_p.func_72838_d((Entity)sfb);
                EntityIceBall sfb2 = new EntityIceBall(horse.field_70170_p, (EntityLivingBase)horse);
                sfb2.func_70107_b(horse.field_70165_t + lookVec.field_72450_a * (double)1.8f - x * (double)i, horse.field_70163_u + (double)horse.func_70047_e() + lookVec.field_72448_b * (double)1.8f, horse.field_70161_v + lookVec.field_72449_c * (double)1.8f - z * (double)i);
                if (horse.field_70170_p.field_72995_K) {
                    sfb2.func_70016_h(lookVec.field_72450_a * 2.5 + horse.field_70159_w - x2 * (double)i, lookVec.field_72448_b * 2.5 + horse.field_70181_x, lookVec.field_72449_c * 2.5 + horse.field_70179_y - z2 * (double)i);
                }
                horse.field_70170_p.func_72838_d((Entity)sfb2);
            }
        }
    }

    @Override
    public float getBuffetStrengthMultiplier() {
        if (this.supercharged) {
            return 1.18f;
        }
        return 1.09f;
    }

    @Override
    public float getBuffetForwardSizeMultiplier() {
        if (this.supercharged) {
            return 1.2f;
        }
        return 1.1f;
    }

    @Override
    public float getBuffetSideSizeMultiplier() {
        if (this.supercharged) {
            return 1.2f;
        }
        return 1.1f;
    }

    @Override
    public float getBuffetUpSizeMultiplier() {
        if (this.supercharged) {
            return 1.2f;
        }
        return 1.1f;
    }

    protected boolean isNearIce(World worldObj, BlockPos position) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int k = -1; k < 4; ++k) {
                    BlockPos bPos = position.add(i, k, j);
                    Block block = worldObj.func_147439_a(bPos.x, bPos.y, bPos.z);
                    Material m = block.func_149688_o();
                    if (block != Block.func_149729_e((int)78) && Material.field_151588_w != m && Material.field_151598_x != m && Material.field_151597_y != m) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

