/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.util.BlockPos;
import com.hackshop.ultimate_unicorn.util.WorldUtil;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LifeAura
extends AbstractPower {
    public LifeAura() {
        this.name = LanguageRegistry.instance().getStringLocalization("power.lifeAura");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.LIFE_AURA;
    }

    @Override
    public void doAuraPower(EntityMagicalHorse horse, int auraCounter) {
        int healTime = 1;
        int modCount1 = 30;
        int amplifier = 0;
        int modCount2 = 10;
        int modCount3 = 200;
        double xExp = 5.5;
        double up = 2.6;
        double zExp = 5.5;
        int numParticles = 3;
        this.emitAura((Entity)horse, numParticles, xExp / 2.0, up / 2.0, zExp / 2.0);
        if (auraCounter % modCount1 == 0) {
            for (int i = 0; i < 3; ++i) {
                this.spreadGrass((Entity)horse);
            }
        }
        if (auraCounter % modCount2 == 0) {
            this.spreadFlowers((Entity)horse);
        }
        if (auraCounter % modCount3 == 0) {
            for (Object e : horse.field_70170_p.func_72872_a(EntityLivingBase.class, horse.field_70121_D.func_72314_b(xExp, up, zExp))) {
                EntityLivingBase targetEntity = (EntityLivingBase)e;
                if (targetEntity instanceof IMob) continue;
                targetEntity.func_70690_d(new PotionEffect(6, healTime, amplifier, true));
                if (!(targetEntity instanceof EntityAnimal)) continue;
                targetEntity.func_70690_d(new PotionEffect(11, 100, 3, true));
                targetEntity.func_70690_d(new PotionEffect(6, 10, 2, true));
            }
        }
    }

    private void spreadGrass(Entity entity) {
        int z;
        Random rand = entity.field_70170_p.field_73012_v;
        BlockPos entityPos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        int x = MathHelper.func_76128_c((double)(rand.nextGaussian() * 3.0)) + entityPos.x;
        int posY = WorldUtil.getTopSolidOrLiquidBlock(x, z = MathHelper.func_76128_c((double)(rand.nextGaussian() * 3.0)) + entityPos.z, entity.field_70170_p);
        if ((double)posY > entity.field_70163_u + 5.0) {
            posY = entityPos.y - 1;
        }
        Block b = entity.field_70170_p.func_147439_a(x, posY, z);
        Block up = entity.field_70170_p.func_147439_a(x, posY + 1, z);
        if (!(Math.abs(posY - entityPos.y) >= 6 || Blocks.field_150346_d != b && Blocks.field_150354_m != b || up.func_149688_o().func_76224_d() || up.func_149688_o().func_76220_a())) {
            entity.field_70170_p.func_147465_d(x, posY, z, (Block)Blocks.field_150349_c, 0, 3);
        }
    }

    private void spreadFlowers(Entity entity) {
        int y;
        World worldObj = entity.field_70170_p;
        Random rand = worldObj.field_73012_v;
        double x = rand.nextGaussian() * 3.0;
        double z = rand.nextGaussian() * 3.0;
        BlockPos entityPos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        BlockPos pos = new BlockPos((double)entityPos.x + x, 0.0, (double)entityPos.z + z);
        pos.y = y = WorldUtil.getTopSolidOrLiquidBlock(pos.x, pos.z, worldObj);
        if (pos.getY() > entityPos.y + 5) {
            pos = new BlockPos(pos.getX(), entityPos.getY() - 1, pos.getZ());
        }
        Block b = worldObj.func_147439_a(pos.getX(), pos.getY(), pos.getZ());
        Block up = worldObj.func_147439_a(pos.getX(), pos.getY() + 1, pos.getZ());
        if (Math.abs(pos.getY() - entityPos.getY()) < 6 && Blocks.field_150349_c == b && !up.func_149688_o().func_76224_d() && !up.func_149688_o().func_76220_a() && up != Blocks.field_150328_O && up != Blocks.field_150327_N) {
            String flowerType = "tulipPink";
            int r = rand.nextInt(5);
            if (0 == r) {
                flowerType = "allium";
            } else if (r < 4) {
                flowerType = worldObj.func_72807_a(pos.getX(), pos.getZ()).func_150572_a(rand, pos.getX(), pos.getY(), pos.getZ());
            }
            BlockFlower blockFlower = BlockFlower.func_149857_e((String)flowerType);
            if (blockFlower.func_149688_o() != Material.field_151579_a) {
                this.generateFlowers(worldObj, rand, blockFlower, flowerType, pos);
            }
        }
    }

    public boolean generateFlowers(World worldIn, Random rand, BlockFlower blockFlower, String flowerType, BlockPos pos) {
        int meta = BlockFlower.func_149856_f((String)flowerType);
        for (int i = 0; i < 5; ++i) {
            int k1;
            int j1;
            int i1 = pos.getX() + rand.nextInt(6) - rand.nextInt(6);
            if (!worldIn.func_147437_c(i1, j1 = pos.getY() + rand.nextInt(4) - rand.nextInt(4), k1 = pos.getZ() + rand.nextInt(6) - rand.nextInt(6)) || worldIn.field_73011_w.field_76576_e && j1 >= 255 || !blockFlower.func_149718_j(worldIn, i1, j1, k1)) continue;
            worldIn.func_147465_d(i1, j1, k1, (Block)blockFlower, meta, 2);
        }
        return true;
    }

    private void emitAura(Entity entity, int numParticles, double xDist, double yDist, double zDist) {
        Random rand = entity.field_70170_p.field_73012_v;
        for (int i = 0; i < numParticles; ++i) {
            double d0 = rand.nextGaussian() * 0.2;
            double d1 = rand.nextGaussian() * 0.2;
            double d2 = rand.nextGaussian() * 0.2;
            entity.field_70170_p.func_72869_a("crit", entity.field_70165_t + (double)rand.nextFloat() * ((double)entity.field_70130_N + xDist) * 2.0 - ((double)entity.field_70130_N + xDist), entity.field_70163_u + 0.5 + (double)rand.nextFloat() * ((double)entity.field_70131_O + yDist), entity.field_70161_v + (double)rand.nextFloat() * ((double)entity.field_70130_N + zDist) * 2.0 - ((double)entity.field_70130_N + zDist), d0, d1, d2);
        }
    }
}

