/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.gui;

import com.hackshop.ultimate_unicorn.blocks.TileEntityMagicalHorseInventory;
import com.hackshop.ultimate_unicorn.gui.GuiSlot;
import com.hackshop.ultimate_unicorn.items.ItemHelper;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.LocalPowerSettings;
import com.hackshop.ultimate_unicorn.util.GlStateManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiHorseConfig
extends GuiScreen {
    protected EntityMagicalHorse unicorn;
    private GuiButton doneBtn;
    private GuiButton cancelBtn;
    private final GuiScreen last;
    protected TileEntityMagicalHorseInventory tileEntity;
    protected int xSize = 176;
    protected int ySize = 166;
    protected int guiLeft;
    protected int guiTop;
    protected GuiButton[] buttonArray = new GuiButton[EntityMagicalHorse.OrderedPower.values().length];
    protected LocalPowerSettings localPowerSettings;
    private List powerListBox;
    private ArrayList<EntityMagicalHorse.OrderedPower> powerList;
    private int selectedIndex;
    private static final int BUTTON_HEIGHT = 13;
    private static final int LIST_WIDTH = 144;
    private static final int SCROLL_BAR_WIDTH = 6;
    private static final ResourceLocation panelImage = new ResourceLocation("ultimate_unicorn_mod:textures/gui/container/power_settings.png");

    public GuiHorseConfig(EntityMagicalHorse unicorn, TileEntityMagicalHorseInventory tileEntity, GuiScreen last) {
        this.unicorn = unicorn;
        this.last = last;
        this.tileEntity = tileEntity;
        this.localPowerSettings = unicorn.powerSettings.copy();
        this.powerList = unicorn.getAllPowerStrings();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.doneBtn = new GuiButton(100, this.field_146294_l / 2 - 4 - 150, this.field_146295_m * 10 / 11 - 13, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.doneBtn);
        this.cancelBtn = new GuiButton(101, this.field_146294_l / 2 + 4, this.field_146295_m * 10 / 11 - 13, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(this.cancelBtn);
        this.powerListBox = new List(this.field_146297_k);
        this.powerListBox.registerScrollButtons(400, 500);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int k = this.guiLeft;
        int l = this.guiTop;
        this.powerListBox.drawScreen(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String title = I18n.func_135052_a((String)"horseSettingsUI.topTitle", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(title, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(title) / 2, 43, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("ultimate_unicorn_mod:textures/gui/container/unicorn_inventory.png"));
        int x = this.guiLeft;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(x, y, 0, 0, this.xSize, this.ySize);
        if (null == this.unicorn || this.unicorn.func_110261_ca()) {
            this.func_73729_b(x + 79 + 18, y + 17, 0, this.ySize, 72, 54);
        }
        this.func_73729_b(x + 7, y + 35, 0, this.ySize + 54, 18, 18);
        this.func_73729_b(x + 7, y + 35 + 18, 18, this.ySize + 54, 18, 18);
        this.func_73729_b(x + 79, y + 17, 13, this.ySize + 54, 18, 18);
        if (null == this.unicorn || this.unicorn.hasHorn() || this.tileEntity.func_70301_a(3) != null && ItemHelper.isSlottedHelm(this.tileEntity.func_70301_a(3).func_77973_b())) {
            this.func_73729_b(x + 79, y + 35, 54, this.ySize + 54, 18, 18);
        }
        if (null == this.unicorn || this.unicorn.hasWings()) {
            this.func_73729_b(x + 79, y + 35 + 18, 72, this.ySize + 54, 18, 18);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 100: {
                    this.unicorn.powerSettings.diffAndMessage(this.localPowerSettings);
                    this.field_146297_k.func_147108_a(this.last);
                    break;
                }
                case 101: {
                    this.field_146297_k.func_147108_a(this.last);
                    break;
                }
                default: {
                    this.powerListBox.actionPerformed(button);
                }
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode != 28 && keyCode != 156) {
            if (keyCode == 1) {
                this.func_146284_a(this.cancelBtn);
            }
        } else {
            this.func_146284_a(this.doneBtn);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        this.powerListBox.handleMouseInput();
    }

    @SideOnly(value=Side.CLIENT)
    class List
    extends GuiSlot {
        private static final String __OBFID = "CL_00000712";
        protected float zLevel;

        public List(Minecraft mcIn) {
            super(mcIn, 144, GuiHorseConfig.this.field_146295_m, GuiHorseConfig.this.guiTop + 16, GuiHorseConfig.this.guiTop + 155, 13);
            this.zLevel = 0.0f;
            this.setSlotXBoundsFromLeft(132);
        }

        @Override
        public int getListWidth() {
            return 144;
        }

        @Override
        protected int getSize() {
            return GuiHorseConfig.this.powerList.size();
        }

        @Override
        public int getSlotIndexFromScreenCoords(int xCoord, int yCoord) {
            int k = this.left;
            int l = this.left + this.width;
            int i1 = yCoord - this.top - this.headerPadding + (int)this.amountScrolled - 4;
            int j1 = i1 / this.slotHeight;
            return xCoord >= k && xCoord <= l && j1 >= 0 && i1 >= 0 && j1 < this.getSize() ? j1 : -1;
        }

        @Override
        protected void elementClicked(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            GuiHorseConfig.this.selectedIndex = slotIndex;
            EntityMagicalHorse.OrderedPower p = (EntityMagicalHorse.OrderedPower)((Object)GuiHorseConfig.this.powerList.get(slotIndex));
            GuiHorseConfig.this.localPowerSettings.toggle(p);
            if (isDoubleClick) {
                // empty if block
            }
        }

        @Override
        public boolean isMouseYWithinSlotBounds(int p_148141_1_) {
            return p_148141_1_ >= this.top && p_148141_1_ <= this.bottom && (this.mouseX >= this.left && this.mouseX <= this.right || this.mouseX >= this.getScrollBarX() && this.mouseX <= this.getScrollBarX() + 6);
        }

        @Override
        public void handleMouseInput() {
            if (this.isMouseYWithinSlotBounds(this.mouseY)) {
                if (Mouse.isButtonDown((int)0)) {
                    if (this.initialClickY == -1.0f) {
                        boolean flag = true;
                        if (this.mouseY >= this.top && this.mouseY <= this.bottom) {
                            int i = this.left;
                            int j = this.left + this.width;
                            int k = this.mouseY - this.top - this.headerPadding + (int)this.amountScrolled - 4;
                            int l = k / this.slotHeight;
                            if (this.mouseX >= i && this.mouseX <= j && l >= 0 && k >= 0 && l < this.getSize()) {
                                boolean flag1 = l == this.selectedElement && Minecraft.func_71386_F() - this.lastClicked < 250L;
                                this.elementClicked(l, flag1, this.mouseX, this.mouseY);
                                this.selectedElement = l;
                                this.lastClicked = Minecraft.func_71386_F();
                            } else if (this.mouseX >= i && this.mouseX <= j && k < 0) {
                                this.func_148132_a(this.mouseX - i, this.mouseY - this.top + (int)this.amountScrolled - 4);
                                flag = false;
                            }
                            int i2 = this.getScrollBarX();
                            int i1 = i2 + 6;
                            if (this.mouseX >= i2 && this.mouseX <= i1) {
                                this.scrollMultiplier = -1.0f;
                                int j1 = this.func_148135_f();
                                if (j1 < 1) {
                                    j1 = 1;
                                }
                                int k1 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight());
                                k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.bottom - this.top - 8));
                                this.scrollMultiplier /= (float)(this.bottom - this.top - k1) / (float)j1;
                            } else {
                                this.scrollMultiplier = 1.0f;
                            }
                            this.initialClickY = flag ? (float)this.mouseY : -2.0f;
                        } else {
                            this.initialClickY = -2.0f;
                        }
                    } else if (this.initialClickY >= 0.0f) {
                        this.amountScrolled -= ((float)this.mouseY - this.initialClickY) * this.scrollMultiplier;
                        this.initialClickY = this.mouseY;
                    }
                } else {
                    this.initialClickY = -1.0f;
                }
                int l1 = Mouse.getEventDWheel();
                if (l1 != 0) {
                    if (l1 > 0) {
                        l1 = -1;
                    } else if (l1 < 0) {
                        l1 = 1;
                    }
                    this.amountScrolled += (float)(l1 * this.slotHeight / 2);
                }
            }
        }

        @Override
        protected boolean isSelected(int slotIndex) {
            return slotIndex == GuiHorseConfig.this.selectedIndex;
        }

        @Override
        protected int getContentHeight() {
            return GuiHorseConfig.this.powerList.size() * 13;
        }

        @Override
        protected void drawBackground() {
        }

        @Override
        protected void drawSlot(int entryID, int xPos, int yPos, int p_180791_4_, int mouseX, int mouseY) {
            EntityMagicalHorse.OrderedPower orderedPower = (EntityMagicalHorse.OrderedPower)((Object)GuiHorseConfig.this.powerList.get(entryID));
            String s = orderedPower.getName() + (GuiHorseConfig.this.localPowerSettings.isEnabled(orderedPower) ? ": ON" : ": OFF");
            int color = 0xFFFFFF;
            if (this.isHoveringOverSlot(xPos, yPos, entryID, mouseX, mouseY)) {
                color = 0xFFFFA0;
            }
            GuiHorseConfig.this.func_73731_b(GuiHorseConfig.this.field_146289_q, s, xPos + 2, yPos + 1, color);
            GlStateManager.color(255.0f, 255.0f, 255.0f, 255.0f);
        }

        @Override
        protected int getScrollBarX() {
            return this.width + this.left + 6;
        }

        @Override
        protected void overlayBackground(int p_148136_1_, int p_148136_2_, int p_148136_3_, int p_148136_4_) {
            Tessellator tessellator = Tessellator.field_78398_a;
            this.mc.func_110434_K().func_110577_a(panelImage);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            float f = 32.0f;
            tessellator.func_78382_b();
            tessellator.func_78384_a(0x404040, p_148136_4_);
            tessellator.func_78374_a((double)this.left, (double)p_148136_2_, 0.0, 0.0, (double)((float)p_148136_2_ / f));
            tessellator.func_78374_a((double)(this.left + this.width), (double)p_148136_2_, 0.0, (double)((float)this.width / f), (double)((float)p_148136_2_ / f));
            tessellator.func_78384_a(0x404040, p_148136_3_);
            tessellator.func_78374_a((double)(this.left + this.width), (double)p_148136_1_, 0.0, (double)((float)this.width / f), (double)((float)p_148136_1_ / f));
            tessellator.func_78374_a((double)this.left, (double)p_148136_1_, 0.0, 0.0, (double)((float)p_148136_1_ / f));
            tessellator.func_78381_a();
        }

        @Override
        public void drawScreen(int mouseXIn, int mouseYIn, float p_148128_3_) {
            this.mouseX = mouseXIn;
            this.mouseY = mouseYIn;
            this.drawBackground();
            int k = this.getScrollBarX();
            int l = k + 6;
            this.bindAmountScrolled();
            GlStateManager.disableLighting();
            GlStateManager.disableFog();
            Tessellator tessellator = Tessellator.field_78398_a;
            this.drawContainerBackground(tessellator);
            int i1 = this.left;
            int j1 = this.top + 4 - (int)this.amountScrolled;
            if (this.hasListHeader) {
                this.drawListHeader(i1, j1, tessellator);
            }
            this.drawSelectionBox(i1, j1, mouseXIn, mouseYIn);
            GlStateManager.disableDepth();
            int b0 = 4;
            this.mc.func_110434_K().func_110577_a(panelImage);
            GuiHorseConfig.this.func_73729_b(GuiHorseConfig.this.guiLeft, GuiHorseConfig.this.guiTop, 0, 0, 240, 165);
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(770, 771, 0, 1);
            GlStateManager.disableAlpha();
            GlStateManager.shadeModel(7425);
            GlStateManager.disableTexture2D();
            int k1 = this.func_148135_f();
            if (k1 > 0) {
                int l1 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
                int i2 = (int)this.amountScrolled * (this.bottom - this.top - (l1 = MathHelper.func_76125_a((int)l1, (int)32, (int)(this.bottom - this.top - 8)))) / k1 + this.top;
                if (i2 < this.top) {
                    i2 = this.top;
                }
                tessellator.func_78382_b();
                tessellator.func_78384_a(0, 255);
                tessellator.func_78374_a((double)k, (double)this.bottom, 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)l, (double)this.bottom, 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)l, (double)this.top, 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)k, (double)this.top, 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78384_a(0x808080, 255);
                tessellator.func_78374_a((double)k, (double)(i2 + l1), 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)l, (double)(i2 + l1), 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)l, (double)i2, 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)k, (double)i2, 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78384_a(0xA2A2A2, 255);
                tessellator.func_78374_a((double)k, (double)(i2 + l1 - 1), 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)(l - 1), (double)(i2 + l1 - 1), 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)(l - 1), (double)i2, 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)k, (double)i2, 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
            }
            this.func_148142_b(mouseXIn, mouseYIn);
            GlStateManager.enableTexture2D();
            GlStateManager.shadeModel(7424);
            GlStateManager.enableAlpha();
            GlStateManager.disableBlend();
        }

        boolean isHoveringOverSlot(int xPos, int k1, int slotIndex, int mouseInX, int mouseInY) {
            return mouseInY >= k1 && mouseInY < k1 + this.slotHeight && mouseInX >= xPos && mouseInX <= xPos + 144;
        }

        @Override
        protected void drawSelectionBox(int xPos, int yPos, int mouseInX, int mouseInY) {
            int numSlots = this.getSize();
            Tessellator tessellator = Tessellator.field_78398_a;
            for (int slotIndex = 0; slotIndex < numSlots; ++slotIndex) {
                int k1 = yPos + slotIndex * this.slotHeight + this.headerPadding;
                int l1 = this.slotHeight - 4;
                if (k1 < this.top - 13 || k1 > this.bottom) continue;
                if (this.showSelectionBox) {
                    int color1 = 0;
                    int color2 = 0x808080;
                    if (this.isHoveringOverSlot(xPos, k1, slotIndex, mouseInX, mouseInY)) {
                        color1 = 0;
                        color2 = new Color(155, 155, 255).getRGB();
                    }
                    int i2 = this.left;
                    int j2 = this.left + this.width;
                    GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                    GlStateManager.disableTexture2D();
                    tessellator.func_78382_b();
                    tessellator.func_78378_d(color1);
                    tessellator.func_78374_a((double)i2, (double)(k1 + l1 + 2), 0.0, 0.0, 1.0);
                    tessellator.func_78374_a((double)j2, (double)(k1 + l1 + 2), 0.0, 1.0, 1.0);
                    tessellator.func_78374_a((double)j2, (double)(k1 - 2), 0.0, 1.0, 0.0);
                    tessellator.func_78374_a((double)i2, (double)(k1 - 2), 0.0, 0.0, 0.0);
                    tessellator.func_78378_d(color2);
                    tessellator.func_78374_a((double)(i2 + 1), (double)(k1 + l1 + 1), 0.0, 0.0, 1.0);
                    tessellator.func_78374_a((double)(j2 - 1), (double)(k1 + l1 + 1), 0.0, 1.0, 1.0);
                    tessellator.func_78374_a((double)(j2 - 1), (double)(k1 - 1), 0.0, 1.0, 0.0);
                    tessellator.func_78374_a((double)(i2 + 1), (double)(k1 - 1), 0.0, 0.0, 0.0);
                    tessellator.func_78381_a();
                    GlStateManager.enableTexture2D();
                }
                this.drawSlot(slotIndex, xPos, k1, l1, mouseInX, mouseInY);
            }
        }
    }
}

