/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.input;

import com.hackshop.ultimate_unicorn.AscendPegasusMessage;
import com.hackshop.ultimate_unicorn.BreatheKirinMessage;
import com.hackshop.ultimate_unicorn.ChargeUnicornMessage;
import com.hackshop.ultimate_unicorn.CombinedClientProxy;
import com.hackshop.ultimate_unicorn.DescendPegasusMessage;
import com.hackshop.ultimate_unicorn.input.KeyBindings;
import com.hackshop.ultimate_unicorn.items.ItemWandOfCallLightning;
import com.hackshop.ultimate_unicorn.util.BlockPos;
import com.hackshop.ultimate_unicorn.util.WorldUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class KeyInputHandler {
    int tickCounter = 0;

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (KeyBindings.chargeUnicorn.func_151468_f()) {
            BlockPos targetPos = this.getTargetPos();
            if (null == targetPos) {
                CombinedClientProxy.network.sendToServer((IMessage)new ChargeUnicornMessage());
            } else {
                CombinedClientProxy.network.sendToServer((IMessage)new ChargeUnicornMessage(targetPos.x, targetPos.y, targetPos.z));
            }
        }
        if (KeyBindings.descendPegasus.func_151468_f()) {
            CombinedClientProxy.network.sendToServer((IMessage)new DescendPegasusMessage());
        }
        if (KeyBindings.ascendPegasus.func_151468_f()) {
            CombinedClientProxy.network.sendToServer((IMessage)new AscendPegasusMessage());
        }
    }

    public void checkDescendPegasusKeyDown() {
        if (KeyBindings.descendPegasus.func_151470_d()) {
            CombinedClientProxy.network.sendToServer((IMessage)new DescendPegasusMessage());
        }
    }

    public void checkAscendPegasusKeyDown() {
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() || KeyBindings.ascendPegasus.func_151470_d()) {
            CombinedClientProxy.network.sendToServer((IMessage)new AscendPegasusMessage());
        }
    }

    public void checkHornStabKeyDown() {
        if (KeyBindings.chargeUnicorn.func_151470_d()) {
            BlockPos targetPos = this.getTargetPos();
            if (null == targetPos) {
                CombinedClientProxy.network.sendToServer((IMessage)new ChargeUnicornMessage());
            } else {
                CombinedClientProxy.network.sendToServer((IMessage)new ChargeUnicornMessage(targetPos.x, targetPos.y, targetPos.z));
            }
        }
    }

    public void checkBreatheKeyDown() {
        if (KeyBindings.breatheKirin.func_151470_d()) {
            BlockPos targetPos = this.getTargetPos();
            CombinedClientProxy.network.sendToServer((IMessage)new BreatheKirinMessage(targetPos));
        }
    }

    public BlockPos getTargetPos() {
        EntityClientPlayerMP playerIn = Minecraft.func_71410_x().field_71439_g;
        World worldIn = playerIn.field_70170_p;
        int x = 0;
        int y = 0;
        int z = 0;
        MovingObjectPosition target = KeyInputHandler.getMouseOver(1.0f, worldIn, (EntityLivingBase)playerIn);
        if (null != target) {
            switch (target.field_72313_a) {
                case BLOCK: {
                    x = target.field_72311_b;
                    z = target.field_72309_d;
                    y = WorldUtil.getTopSolidOrLiquidBlock(target.field_72311_b, target.field_72309_d, worldIn);
                    break;
                }
                case ENTITY: {
                    x = (int)target.field_72308_g.field_70165_t;
                    z = (int)target.field_72308_g.field_70161_v;
                    y = ItemWandOfCallLightning.getLightningStrikePosOnEntity(worldIn, target.field_72308_g);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return new BlockPos(x, y, z);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.tickCounter % 4 == 0) {
            this.checkDescendPegasusKeyDown();
            this.checkAscendPegasusKeyDown();
        }
        if (this.tickCounter % 10 == 0) {
            this.checkHornStabKeyDown();
            this.checkBreatheKeyDown();
        }
        ++this.tickCounter;
    }

    public static MovingObjectPosition getMouseOver(float p_78473_1_, World worldIn, EntityLivingBase entityIn) {
        MovingObjectPosition objectMouseOver = null;
        Entity pointedEntity = null;
        if (entityIn != null && worldIn != null) {
            pointedEntity = null;
            double d0 = 50.0;
            objectMouseOver = entityIn.func_70614_a(d0, p_78473_1_);
            double d1 = d0;
            Vec3 vec3 = entityIn.func_70666_h(p_78473_1_);
            vec3.field_72448_b += (double)entityIn.func_70047_e();
            if (objectMouseOver != null) {
                d1 = objectMouseOver.field_72307_f.func_72438_d(vec3);
            }
            Vec3 vec31 = entityIn.func_70676_i(p_78473_1_);
            Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * d0, vec31.field_72448_b * d0, vec31.field_72449_c * d0);
            pointedEntity = null;
            Vec3 vec33 = null;
            float f1 = 1.0f;
            List list = worldIn.func_72839_b((Entity)entityIn, entityIn.field_70121_D.func_72321_a(vec31.field_72450_a * d0, vec31.field_72448_b * d0, vec31.field_72449_c * d0).func_72314_b((double)f1, (double)f1, (double)f1));
            double d2 = d1;
            for (int i = 0; i < list.size(); ++i) {
                double d3;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L()) continue;
                float f2 = entity1.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity1.field_70121_D.func_72314_b((double)f2, (double)f2, (double)f2);
                MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(vec3, vec32);
                if (axisalignedbb.func_72318_a(vec3)) {
                    if (!(0.0 < d2) && d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec33 = movingobjectposition == null ? vec3 : movingobjectposition.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((d3 = vec3.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1 == entityIn.field_70154_o && !entityIn.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec33 = movingobjectposition.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                vec33 = movingobjectposition.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && (d2 < d1 || objectMouseOver == null)) {
                objectMouseOver = new MovingObjectPosition(pointedEntity, vec33);
            }
        }
        return objectMouseOver;
    }
}

