/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.items;

import com.google.common.collect.Multimap;
import com.hackshop.ultimate_unicorn.CombinedClientProxy;
import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.ShootWandMessage;
import com.hackshop.ultimate_unicorn.input.KeyInputHandler;
import com.hackshop.ultimate_unicorn.items.HornShootable;
import com.hackshop.ultimate_unicorn.items.ItemHelper;
import com.hackshop.ultimate_unicorn.util.BlockPos;
import com.hackshop.ultimate_unicorn.util.WorldUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemWandOfCallLightning
extends Item
implements HornShootable {
    protected float attackDamage;
    protected final Item.ToolMaterial material = Item.ToolMaterial.IRON;
    private final String name = "wand_of_call_lightning";

    public ItemWandOfCallLightning() {
        this.field_77777_bU = 1;
        this.func_77656_e(50);
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.attackDamage = 0.4f + this.material.func_78000_c();
        this.func_111206_d("ultimate_unicorn_mod:wand_of_call_lightning");
        this.func_77655_b("wand_of_call_lightning");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public float getDamageVsEntity() {
        return this.material.func_78000_c();
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (player.func_71039_bw()) {
            stack.func_77972_a(4, (EntityLivingBase)player);
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = block.func_149688_o();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        int y = ItemWandOfCallLightning.getLightningStrikePosOnEntity(target.field_70170_p, (Entity)target);
        target.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(target.field_70170_p, target.field_70165_t, (double)y, target.field_70161_v));
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World worldIn, Block blockIn, int x, int y, int z, EntityLivingBase playerIn) {
        if ((double)blockIn.func_149712_f(worldIn, x, y, z) != 0.0) {
            stack.func_77972_a(2, playerIn);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack stack) {
        return 120;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count % 8 == 0 && player.field_70170_p.field_72995_K && player == Minecraft.func_71410_x().field_71439_g) {
            this.clientShoot();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clientShoot() {
        EntityClientPlayerMP playerIn = Minecraft.func_71410_x().field_71439_g;
        World worldIn = playerIn.field_70170_p;
        BlockPos targetPos = null;
        MovingObjectPosition target = KeyInputHandler.getMouseOver(1.0f, worldIn, (EntityLivingBase)playerIn);
        if (null != target) {
            switch (target.field_72313_a) {
                case BLOCK: {
                    targetPos = new BlockPos(target.field_72311_b, WorldUtil.getTopSolidOrLiquidBlock(target.field_72311_b, target.field_72309_d, worldIn), target.field_72309_d);
                    break;
                }
                case ENTITY: {
                    targetPos = new BlockPos((int)target.field_72308_g.field_70165_t, ItemWandOfCallLightning.getLightningStrikePosOnEntity(worldIn, target.field_72308_g), (int)target.field_72308_g.field_70161_v);
                    break;
                }
            }
        }
        if (null != targetPos) {
            CombinedClientProxy.network.sendToServer((IMessage)new ShootWandMessage(targetPos.x, targetPos.y, targetPos.z));
        }
    }

    @Override
    public void shoot(ItemStack stack, World worldIn, EntityLivingBase shooter, int x, int y, int z) {
        if (!worldIn.field_72995_K && !CommonProxy.config.disableLightningWand) {
            ItemHelper.horseDamageItem(stack, 1, shooter);
        }
        worldIn.func_72942_c((Entity)new EntityLightningBolt(worldIn, (double)x, (double)y, (double)z));
    }

    @Override
    public void shootTargetEntity(ItemStack stack, World worldIn, EntityLivingBase shooter, EntityLivingBase targetEntity) {
        if (null != targetEntity && !worldIn.field_72995_K) {
            stack.func_77972_a(1, shooter);
            int y = ItemWandOfCallLightning.getLightningStrikePosOnEntity(worldIn, (Entity)targetEntity);
            worldIn.func_72942_c((Entity)new EntityLightningBolt(worldIn, targetEntity.field_70165_t, (double)y, targetEntity.field_70161_v));
        }
    }

    public static int getLightningStrikePosOnEntity(World worldIn, Entity entityToStrike) {
        int targetPos = WorldUtil.getTopSolidOrLiquidBlock((int)entityToStrike.field_70165_t, (int)entityToStrike.field_70161_v, worldIn);
        if ((double)targetPos > entityToStrike.field_70163_u) {
            return targetPos;
        }
        return (int)entityToStrike.field_70163_u;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityPlayer playerIn, int timeLeft) {
        if (!worldIn.field_72995_K) {
            stack.func_77972_a((128 - timeLeft) / 8, (EntityLivingBase)playerIn);
            if (this.getDamage(stack) >= this.func_77612_l()) {
                playerIn.func_71028_bD();
            }
        }
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (worldIn.field_72995_K && playerIn == Minecraft.func_71410_x().field_71439_g) {
            this.clientShoot();
        }
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        return itemStackIn;
    }

    public boolean func_150897_b(Block blockIn) {
        return false;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
        return multimap;
    }

    public String getName() {
        return "wand_of_call_lightning";
    }
}

