/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.items;

import com.google.common.collect.Multimap;
import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.items.HornShootable;
import com.hackshop.ultimate_unicorn.items.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemWandOfDropsies
extends Item
implements HornShootable {
    protected float attackDamage;
    protected final Item.ToolMaterial material = Item.ToolMaterial.IRON;
    private final String name = "wand_of_dropsies";

    public ItemWandOfDropsies() {
        this.field_77777_bU = 1;
        this.func_77656_e(50);
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.attackDamage = 0.4f + this.material.func_78000_c();
        this.func_77655_b("wand_of_dropsies");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public float getDamageVsEntity() {
        return this.material.func_78000_c();
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (player.func_71039_bw()) {
            stack.func_77972_a(4, (EntityLivingBase)player);
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = block.func_149688_o();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World worldIn, Block blockIn, int x, int y, int z, EntityLivingBase playerIn) {
        if ((double)blockIn.func_149712_f(worldIn, x, y, z) != 0.0) {
            stack.func_77972_a(2, playerIn);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack stack) {
        return 120;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count % 8 == 0) {
            this.shoot(stack, player.field_70170_p, (EntityLivingBase)player, 0, 0, 0);
        }
    }

    @Override
    public void shoot(ItemStack stack, World worldIn, EntityLivingBase shooter, int x, int y, int z) {
        if (!worldIn.field_72995_K && !CommonProxy.config.disableDropsyWand) {
            ItemHelper.horseDamageItem(stack, 1, shooter);
            Vec3 lookVec = shooter.func_70040_Z();
            for (Object obj : worldIn.func_72839_b((Entity)shooter, shooter.field_70121_D.func_72329_c().func_72317_d(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c).func_72321_a(lookVec.field_72450_a * 12.0, lookVec.field_72448_b * 12.0, lookVec.field_72449_c * 12.0))) {
                EntityLiving el;
                ItemStack itemStackIn;
                if (obj instanceof Entity) {
                    Vec3 shooterPosVec;
                    Entity e = (Entity)obj;
                    Vec3 objPosVec = Vec3.func_72443_a((double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v);
                    Vec3 objVec = objPosVec.func_72444_a(shooterPosVec = Vec3.func_72443_a((double)shooter.field_70165_t, (double)shooter.field_70163_u, (double)shooter.field_70161_v)).func_72432_b();
                    if (lookVec.func_72431_c(objVec).func_72433_c() > 0.45) continue;
                }
                if (obj instanceof EntityPlayer && obj != shooter.field_70153_n) {
                    EntityPlayer ep = (EntityPlayer)obj;
                    ep.func_71040_bB(true);
                    continue;
                }
                if (!(obj instanceof EntityLiving) || obj == shooter.field_70153_n || null == (itemStackIn = (el = (EntityLiving)obj).func_70694_bm()) || itemStackIn.field_77994_a == 0 || itemStackIn.func_77973_b() == null) continue;
                EntityItem entityItem = new EntityItem(worldIn, el.field_70165_t, el.field_70163_u + (double)el.field_70131_O / 1.8, el.field_70161_v, itemStackIn);
                entityItem.field_145804_b = 4;
                el.func_70035_c()[0] = null;
                Vec3 targetLookVec = el.func_70040_Z();
                entityItem.field_70159_w = targetLookVec.field_72450_a / 1.3;
                double yTrajectory = targetLookVec.field_72448_b < 0.35 ? targetLookVec.field_72448_b + 0.2 : targetLookVec.field_72448_b;
                entityItem.field_70181_x = yTrajectory = yTrajectory < 0.1 ? 0.1 : yTrajectory;
                entityItem.field_70179_y = targetLookVec.field_72449_c / 1.3;
                worldIn.func_72838_d((Entity)entityItem);
                if (!(el instanceof EntitySkeleton)) continue;
                ((EntitySkeleton)el).func_85036_m();
            }
        }
    }

    @Override
    public void shootTargetEntity(ItemStack stack, World worldIn, EntityLivingBase shooter, EntityLivingBase targetEntity) {
        if (null != targetEntity && !worldIn.field_72995_K) {
            this.shoot(stack, worldIn, shooter, (int)targetEntity.field_70165_t, (int)targetEntity.field_70163_u, (int)targetEntity.field_70161_v);
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityPlayer playerIn, int timeLeft) {
        if (!worldIn.field_72995_K) {
            stack.func_77972_a((128 - timeLeft) / 8, (EntityLivingBase)playerIn);
            if (this.getDamage(stack) >= this.func_77612_l()) {
                playerIn.func_71028_bD();
            }
        }
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        this.shoot(itemStackIn, worldIn, (EntityLivingBase)playerIn, 0, 0, 0);
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        return itemStackIn;
    }

    public boolean func_150897_b(Block blockIn) {
        return false;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
        return multimap;
    }

    public String getName() {
        return "wand_of_dropsies";
    }
}

