/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.mobs;

import com.google.common.base.Predicate;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityRabbit
extends EntityAnimal {
    private AIAvoidEntity avoidEntityActivity;
    private int currentActivityTicksDone = 0;
    private int currentActivityTicksToDo = 0;
    private boolean isJumping_guess = false;
    private boolean isLanded = false;
    private int ticksToGo = 0;
    private EnumMoveType moveType = EnumMoveType.HOP;
    private int carrotTicks = 0;
    private static final String __OBFID = "CL_00002242";
    protected RabbitMoveHelper field_70765_h;
    protected EntityJumpHelper field_70767_i;

    public EntityRabbit(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.7f);
        this.field_70767_i = new RabbitJumpHelper(this, super.func_70683_ar());
        this.field_70765_h = new RabbitMoveHelper(super.func_70605_aq());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic(1.33));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_151172_bF, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.avoidEntityActivity = new AIAvoidEntity(new Predicate(){

            public boolean func_180086_a(Entity p_180086_1_) {
                return p_180086_1_ instanceof EntityWolf;
            }

            public boolean apply(Object p_apply_1_) {
                return this.func_180086_a((Entity)p_apply_1_);
            }
        }, 16.0f, 1.33, 1.33);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.avoidEntityActivity);
        this.moveWithSpeed(0.0);
    }

    protected void func_70664_aZ() {
        this.field_70181_x = this.getJumpHeight();
        if (this.func_70644_a(Potion.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float f = this.field_70177_z * ((float)Math.PI / 180);
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    protected float getJumpHeight() {
        return this.field_70765_h.func_75640_a() && this.field_70765_h.getY() > this.field_70163_u + 0.5 ? 0.5f : this.moveType.getJumpHeight();
    }

    public void setMoveType(EnumMoveType newMoveType) {
        this.moveType = newMoveType;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCurrentActivityProgress(float tickAmount) {
        return this.currentActivityTicksToDo == 0 ? 0.0f : ((float)this.currentActivityTicksDone + tickAmount) / (float)this.currentActivityTicksToDo;
    }

    public void moveWithSpeed(double speed) {
        this.func_70661_as().func_75489_a(speed);
        this.field_70765_h.func_75642_a(this.field_70765_h.getX(), this.field_70765_h.getY(), this.field_70765_h.getZ(), speed);
    }

    public void hopAndMove(boolean doJumping, EnumMoveType moveType) {
        super.func_70637_d(doJumping);
        if (!doJumping) {
            if (this.moveType == EnumMoveType.ATTACK) {
                this.moveType = EnumMoveType.HOP;
            }
        } else {
            this.moveWithSpeed(1.5 * (double)moveType.getSpeed());
            this.func_85030_a(this.getHopSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
        this.isJumping_guess = doJumping;
    }

    public void setNewActivity(EnumMoveType moveType) {
        this.hopAndMove(true, moveType);
        this.currentActivityTicksToDo = moveType.getTickCooldownLength();
        this.currentActivityTicksDone = 0;
    }

    public boolean func_175523_cj() {
        return this.isJumping_guess;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void func_70629_bd() {
        if (this.field_70765_h.func_75638_b() > 0.8) {
            this.setMoveType(EnumMoveType.SPRINT);
        } else if (this.moveType != EnumMoveType.ATTACK) {
            this.setMoveType(EnumMoveType.HOP);
        }
        if (this.ticksToGo > 0) {
            --this.ticksToGo;
        }
        if (this.carrotTicks > 0) {
            this.carrotTicks -= this.field_70146_Z.nextInt(3);
            if (this.carrotTicks < 0) {
                this.carrotTicks = 0;
            }
        }
        if (this.field_70122_E) {
            RabbitJumpHelper rabbitjumphelper;
            EntityLivingBase entitylivingbase;
            if (!this.isLanded) {
                this.hopAndMove(false, EnumMoveType.NONE);
                this.resetTicksNoJump();
            }
            if (this.getRabbitType() == 99 && this.ticksToGo == 0 && (entitylivingbase = this.func_70638_az()) != null && this.func_70068_e((Entity)entitylivingbase) < 16.0) {
                this.lookAtXZ(entitylivingbase.field_70165_t, entitylivingbase.field_70161_v);
                this.field_70765_h.func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, this.field_70765_h.func_75638_b());
                this.setNewActivity(EnumMoveType.ATTACK);
                this.isLanded = true;
            }
            if (!(rabbitjumphelper = (RabbitJumpHelper)this.field_70767_i).isJumping()) {
                if (this.func_70605_aq().func_75640_a() && this.ticksToGo == 0) {
                    PathEntity pathentity = this.func_70661_as().func_75505_d();
                    Vec3 vec3 = Vec3.func_72443_a((double)this.field_70765_h.getX(), (double)this.field_70765_h.getY(), (double)this.field_70765_h.getZ());
                    if (pathentity != null && pathentity.func_75873_e() < pathentity.func_75874_d()) {
                        vec3 = pathentity.func_75878_a((Entity)this);
                    }
                    this.lookAtXZ(vec3.field_72450_a, vec3.field_72449_c);
                    this.setNewActivity(this.moveType);
                }
            } else if (!rabbitjumphelper.getValue1()) {
                this.setJumpValue1True();
            }
        }
        this.isLanded = this.field_70122_E;
    }

    public void spawnRunningParticles() {
    }

    private void lookAtXZ(double x, double z) {
        this.field_70177_z = (float)(Math.atan2(z - this.field_70161_v, x - this.field_70165_t) * 180.0 / Math.PI) - 90.0f;
    }

    private void setJumpValue1True() {
        ((RabbitJumpHelper)this.field_70767_i).setValue1(true);
    }

    private void setJumpValue1False() {
        ((RabbitJumpHelper)this.field_70767_i).setValue1(false);
    }

    private void resetTicksToGo() {
        this.ticksToGo = this.getCurrentActivityTickLength();
    }

    private void resetTicksNoJump() {
        this.resetTicksToGo();
        this.setJumpValue1False();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.currentActivityTicksDone != this.currentActivityTicksToDo) {
            if (this.currentActivityTicksDone == 0 && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)1);
            }
            ++this.currentActivityTicksDone;
        } else if (this.currentActivityTicksToDo != 0) {
            this.currentActivityTicksDone = 0;
            this.currentActivityTicksToDo = 0;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("RabbitType", this.getRabbitType());
        tagCompound.func_74768_a("MoreCarrotTicks", this.carrotTicks);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setRabbitType(tagCompund.func_74762_e("RabbitType"));
        this.carrotTicks = tagCompund.func_74762_e("MoreCarrotTicks");
    }

    protected String getHopSound() {
        return "ultimate_unicorn_mod:rabbit_hop";
    }

    protected String func_70639_aQ() {
        return "ultimate_unicorn_mod:rabbit_idle";
    }

    protected String func_70621_aR() {
        return "ultimate_unicorn_mod:rabbit_hurt";
    }

    protected String func_70673_aS() {
        return "ultimate_unicorn_mod:rabbit_death";
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        if (this.getRabbitType() == 99) {
            this.func_85030_a("mob.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            return p_70652_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 8.0f);
        }
        return p_70652_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
    }

    public int func_70658_aO() {
        return this.getRabbitType() == 99 ? 8 : super.func_70658_aO();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_85032_ar() ? false : super.func_70097_a(source, amount);
    }

    protected void func_82164_bB() {
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
    }

    private boolean isNonNullBreedingItem(Item p_175525_1_) {
        return p_175525_1_ == Items.field_151172_bF || p_175525_1_ == Items.field_151150_bK || p_175525_1_ == Item.func_150898_a((Block)Blocks.field_150327_N);
    }

    public EntityRabbit createChildRabbit(EntityAgeable p_175526_1_) {
        EntityRabbit entityrabbit = new EntityRabbit(this.field_70170_p);
        if (p_175526_1_ instanceof EntityRabbit) {
            entityrabbit.setRabbitType(this.field_70146_Z.nextBoolean() ? this.getRabbitType() : ((EntityRabbit)p_175526_1_).getRabbitType());
        }
        return entityrabbit;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack != null && this.isNonNullBreedingItem(stack.func_77973_b());
    }

    public int getRabbitType() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setRabbitType(int rabbitTypeId) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)rabbitTypeId));
    }

    private boolean func_175534_cv() {
        return this.carrotTicks == 0;
    }

    protected int getCurrentActivityTickLength() {
        return this.moveType.getTickLength();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 1) {
            this.currentActivityTicksToDo = 10;
            this.currentActivityTicksDone = 0;
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return this.createChildRabbit(ageable);
    }

    protected void func_70619_bc() {
        ++this.field_70708_bq;
        this.field_70170_p.field_72984_F.func_76320_a("checkDespawn");
        this.func_70623_bb();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("sensing");
        this.func_70635_at().func_75523_a();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("targetSelector");
        this.field_70715_bh.func_75774_a();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("goalSelector");
        this.field_70714_bg.func_75774_a();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("navigation");
        this.func_70661_as().func_75501_e();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("mob tick");
        this.func_70629_bd();
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("controls");
        this.field_70170_p.field_72984_F.func_76320_a("move");
        this.field_70765_h.func_75641_c();
        this.field_70170_p.field_72984_F.func_76318_c("look");
        this.func_70671_ap().func_75649_a();
        this.field_70170_p.field_72984_F.func_76318_c("jump");
        this.field_70767_i.func_75661_b();
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public EntityJumpHelper func_70683_ar() {
        return this.field_70767_i;
    }

    public EntityMoveHelper func_70605_aq() {
        return this.field_70765_h;
    }

    public static class RabbitTypeData
    implements IEntityLivingData {
        public int field_179427_a;
        private static final String __OBFID = "CL_00002237";

        public RabbitTypeData(int p_i45864_1_) {
            this.field_179427_a = p_i45864_1_;
        }
    }

    class RabbitMoveHelper
    extends EntityMoveHelper {
        private EntityRabbit entity;
        private double posX;
        private double posY;
        private double posZ;
        private EntityMoveHelper otherMoveHelper;

        public RabbitMoveHelper(EntityMoveHelper otherMoveHelper) {
            super((EntityLiving)EntityRabbit.this);
            this.entity = EntityRabbit.this;
            this.posX = EntityRabbit.this.field_70165_t;
            this.posY = EntityRabbit.this.field_70163_u;
            this.posZ = EntityRabbit.this.field_70161_v;
            this.otherMoveHelper = otherMoveHelper;
        }

        public void func_75641_c() {
            if (this.entity.field_70122_E && !this.entity.func_175523_cj()) {
                this.entity.moveWithSpeed(0.0);
            }
            super.func_75641_c();
        }

        public double getX() {
            return this.posX;
        }

        public double getY() {
            return this.posY;
        }

        public double getZ() {
            return this.posZ;
        }

        public void func_75642_a(double p_75642_1_, double p_75642_3_, double p_75642_5_, double p_75642_7_) {
            this.posX = p_75642_1_;
            this.posY = p_75642_3_;
            this.posZ = p_75642_5_;
            super.func_75642_a(p_75642_1_, p_75642_3_, p_75642_5_, p_75642_7_);
        }
    }

    public class RabbitJumpHelper
    extends EntityJumpHelper {
        private EntityRabbit entity;
        private boolean value1;
        protected boolean field_75662_b;
        private EntityJumpHelper otherJumpHelper;

        public RabbitJumpHelper(EntityRabbit entityIn, EntityJumpHelper otherJumpHelper) {
            super((EntityLiving)entityIn);
            this.value1 = false;
            this.entity = entityIn;
            this.otherJumpHelper = otherJumpHelper;
        }

        public boolean isJumping() {
            return this.field_75662_b;
        }

        public boolean getValue1() {
            return this.value1;
        }

        public void setValue1(boolean p_180066_1_) {
            this.value1 = p_180066_1_;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.entity.setNewActivity(EnumMoveType.STEP);
                this.field_75662_b = false;
            }
        }

        public void func_75660_a() {
            this.field_75662_b = true;
        }
    }

    static enum EnumMoveType {
        NONE(0.0f, 0.0f, 30, 1),
        HOP(0.8f, 0.2f, 20, 10),
        STEP(1.0f, 0.45f, 14, 14),
        SPRINT(1.75f, 0.4f, 1, 8),
        ATTACK(2.0f, 0.7f, 7, 8);

        private final float speed;
        private final float jumpHeight;
        private final int tickLength;
        private final int tickCooldownLength;
        private static final String __OBFID = "CL_00002239";

        private EnumMoveType(float p_i45866_3_, float p_i45866_4_, int p_i45866_5_, int p_i45866_6_) {
            this.speed = p_i45866_3_;
            this.jumpHeight = p_i45866_4_;
            this.tickLength = p_i45866_5_;
            this.tickCooldownLength = p_i45866_6_;
        }

        public float getSpeed() {
            return this.speed;
        }

        public float getJumpHeight() {
            return this.jumpHeight;
        }

        public int getTickLength() {
            return this.tickLength;
        }

        public int getTickCooldownLength() {
            return this.tickCooldownLength;
        }
    }

    class AIPanic
    extends EntityAIPanic {
        private EntityRabbit field_179486_b;
        private double speed;

        public AIPanic(double speedIn) {
            super((EntityCreature)EntityRabbit.this, speedIn);
            this.field_179486_b = EntityRabbit.this;
            this.speed = speedIn;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.field_179486_b.moveWithSpeed(this.speed);
        }
    }

    class AIAvoidEntity
    extends EntityAIAvoidEntity {
        private EntityRabbit entityInstance;
        private static final String __OBFID = "CL_00002238";

        public AIAvoidEntity(Predicate avoidPredicate, float p_i45865_3_, double p_i45865_4_, double p_i45865_6_) {
            super((EntityCreature)EntityRabbit.this, EntityWolf.class, p_i45865_3_, p_i45865_4_, p_i45865_6_);
            this.entityInstance = EntityRabbit.this;
        }

        public void func_75246_d() {
            super.func_75246_d();
        }
    }
}

