/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.mobs.renderer;

import com.google.common.collect.Maps;
import com.hackshop.ultimate_unicorn.BreakBlockMessage;
import com.hackshop.ultimate_unicorn.CombinedClientProxy;
import com.hackshop.ultimate_unicorn.custom.HorseLayeredTexture;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.model.ModelMagicalHorse;
import com.hackshop.ultimate_unicorn.util.GlStateManager;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class RenderMagicalHorse
extends RenderLiving {
    private static final Map pathnamesToTextures = Maps.newHashMap();
    private static final ResourceLocation whiteHorseTextures = new ResourceLocation("ultimate_unicorn_mod:textures/entity/unicorn_white.png");
    private static final ResourceLocation rainbowBeamTexture = new ResourceLocation("ultimate_unicorn_mod:textures/entity/rainbow_beam.png");
    private static final String __OBFID = "CL_00001000";
    private MovingObjectPosition lastTarget = null;
    private int lastDamage = 0;
    private int lastDamageCounter = 0;

    public RenderMagicalHorse(ModelMagicalHorse model, float shadowSize) {
        super((ModelBase)model, shadowSize);
    }

    public void func_76979_b(Entity horse, double p_76979_2_, double p_76979_4_, double p_76979_6_, float p_76979_8_, float tickOffset) {
        if (horse instanceof EntityMagicalHorse) {
            this.field_76989_e = ((EntityMagicalHorse)horse).hasDestrierBody() ? 1.4f : 0.7f;
        }
        super.func_76979_b(horse, p_76979_2_, p_76979_4_, p_76979_6_, p_76979_8_, tickOffset);
        this.renderRainbowBeam((EntityMagicalHorse)horse, tickOffset);
    }

    private void renderRainbowBeam(EntityMagicalHorse horse, float tickOffset) {
        GL11.glAlphaFunc((int)516, (float)0.1f);
        float f1 = 1.0f;
        if (horse.getHideType() == 5 && horse.getCharge()) {
            double playerXOffset = horse.field_70165_t - TileEntityRendererDispatcher.field_147554_b;
            double playerYOffset = horse.field_70163_u - TileEntityRendererDispatcher.field_147555_c;
            double playerZOffset = horse.field_70161_v - TileEntityRendererDispatcher.field_147552_d;
            double dist = 60.0;
            MovingObjectPosition target = horse.rayTraceHorn(60.0, tickOffset);
            Vec3 pos = null;
            if (null != target) {
                switch (target.field_72313_a) {
                    case BLOCK: {
                        dist = horse.func_70011_f(target.field_72311_b, target.field_72312_c, target.field_72309_d) + 0.1;
                        pos = Vec3.func_72443_a((double)target.field_72311_b, (double)target.field_72312_c, (double)target.field_72309_d);
                        if (this.lastTarget != null && target.field_72311_b == this.lastTarget.field_72311_b && target.field_72312_c == this.lastTarget.field_72312_c && target.field_72309_d == this.lastTarget.field_72309_d) {
                            ++this.lastDamageCounter;
                            float limit = 2.6f * horse.field_70170_p.func_147439_a(target.field_72311_b, target.field_72312_c, target.field_72309_d).func_149712_f(null, 0, 0, 0);
                            if ((float)this.lastDamageCounter > limit) {
                                EntityClientPlayerMP playerIn;
                                this.lastDamageCounter = 0;
                                ++this.lastDamage;
                                if (this.lastDamage > 9 && (playerIn = Minecraft.func_71410_x().field_71439_g) == horse.field_70153_n) {
                                    CombinedClientProxy.network.sendToServer((IMessage)new BreakBlockMessage(target.field_72311_b, target.field_72312_c, target.field_72309_d));
                                }
                            }
                        } else {
                            this.lastDamageCounter = 0;
                            this.lastDamage = 0;
                        }
                        horse.field_70170_p.func_147443_d(horse.func_145782_y(), target.field_72311_b, target.field_72312_c, target.field_72309_d, this.lastDamage);
                        this.lastTarget = target;
                        break;
                    }
                    case ENTITY: {
                        dist = horse.func_70011_f(target.field_72308_g.field_70165_t, target.field_72308_g.field_70163_u, target.field_72308_g.field_70161_v);
                        pos = Vec3.func_72443_a((double)target.field_72308_g.field_70165_t, (double)target.field_72308_g.field_70163_u, (double)target.field_72308_g.field_70161_v);
                        break;
                    }
                }
            }
            if (null != pos) {
                Random rand = horse.field_70170_p.field_73012_v;
                for (int i = 0; i < 1; ++i) {
                    double d0 = rand.nextGaussian();
                    double d1 = rand.nextGaussian();
                    double d2 = rand.nextGaussian();
                    double d3 = rand.nextGaussian();
                    double d4 = rand.nextGaussian();
                    double d5 = rand.nextGaussian();
                    horse.field_70170_p.func_72869_a("mobSpell", pos.field_72450_a + d0, pos.field_72448_b + d1, pos.field_72449_c + d2, d3, d4, d5);
                }
            }
            Tessellator tessellator = Tessellator.field_78398_a;
            this.func_110776_a(rainbowBeamTexture);
            GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
            GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
            float tickTime = (float)horse.field_70170_p.func_82737_E() + tickOffset;
            float f3 = -tickTime * 0.2f - (float)MathHelper.func_76141_d((float)(-tickTime * 0.1f));
            double d3 = (double)tickTime * 0.025 * -11.5;
            tessellator.func_78382_b();
            tessellator.func_78370_a(255, 255, 255, 32);
            double d5 = 0.2;
            double d7 = 0.0 + Math.cos(d3 + 2.356194490192345) * d5;
            double d9 = 0.0 + Math.sin(d3 + 2.356194490192345) * d5;
            double d11 = 0.0 + Math.cos(d3 + 0.7853981633974483) * d5;
            double d13 = 0.0 + Math.sin(d3 + 0.7853981633974483) * d5;
            double d15 = 0.0 + Math.cos(d3 + 3.9269908169872414) * d5;
            double d17 = 0.0 + Math.sin(d3 + 3.9269908169872414) * d5;
            double d19 = 0.0 + Math.cos(d3 + 5.497787143782138) * d5;
            double zAdd = 0.0 + Math.sin(d3 + 5.497787143782138) * d5;
            double maxY = dist * (double)f1;
            double d25 = 0.0;
            double textureWidth = 1.0;
            double textureHeight2 = -1.0f + f3;
            double textureHeight = (double)(256.0f * f1) * (0.5 / d5) + textureHeight2;
            double horseBodyOffset = 1.5;
            tessellator.func_78374_a(playerXOffset + d7, playerYOffset + maxY, playerZOffset + d9, textureWidth, textureHeight);
            tessellator.func_78374_a(playerXOffset + d7, playerYOffset + horseBodyOffset, playerZOffset + d9, textureWidth, textureHeight2);
            tessellator.func_78374_a(playerXOffset + d11, playerYOffset + horseBodyOffset, playerZOffset + d13, d25, textureHeight2);
            tessellator.func_78374_a(playerXOffset + d11, playerYOffset + maxY, playerZOffset + d13, d25, textureHeight);
            tessellator.func_78374_a(playerXOffset + d19, playerYOffset + maxY, playerZOffset + zAdd, textureWidth, textureHeight);
            tessellator.func_78374_a(playerXOffset + d19, playerYOffset + horseBodyOffset, playerZOffset + zAdd, textureWidth, textureHeight2);
            tessellator.func_78374_a(playerXOffset + d15, playerYOffset + horseBodyOffset, playerZOffset + d17, d25, textureHeight2);
            tessellator.func_78374_a(playerXOffset + d15, playerYOffset + maxY, playerZOffset + d17, d25, textureHeight);
            tessellator.func_78374_a(playerXOffset + d11, playerYOffset + maxY, playerZOffset + d13, textureWidth, textureHeight);
            tessellator.func_78374_a(playerXOffset + d11, playerYOffset + horseBodyOffset, playerZOffset + d13, textureWidth, textureHeight2);
            tessellator.func_78374_a(playerXOffset + d19, playerYOffset + horseBodyOffset, playerZOffset + zAdd, d25, textureHeight2);
            tessellator.func_78374_a(playerXOffset + d19, playerYOffset + maxY, playerZOffset + zAdd, d25, textureHeight);
            tessellator.func_78374_a(playerXOffset + d15, playerYOffset + maxY, playerZOffset + d17, textureWidth, textureHeight);
            tessellator.func_78374_a(playerXOffset + d15, playerYOffset + horseBodyOffset, playerZOffset + d17, textureWidth, textureHeight2);
            tessellator.func_78374_a(playerXOffset + d7, playerYOffset + horseBodyOffset, playerZOffset + d9, d25, textureHeight2);
            tessellator.func_78374_a(playerXOffset + d7, playerYOffset + maxY, playerZOffset + d9, d25, textureHeight);
            GL11.glPushMatrix();
            double beamHeight = 0.6;
            double beamForward = 0.9;
            if (horse.hasDestrierBody()) {
                beamHeight = 1.5;
                beamForward = 2.3;
            }
            GL11.glTranslated((double)playerXOffset, (double)(playerYOffset + beamHeight), (double)playerZOffset);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)horse.field_70177_z, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
            GL11.glTranslated((double)(-playerXOffset), (double)(-playerYOffset + beamForward), (double)(-playerZOffset));
            tessellator.func_78381_a();
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDepthMask((boolean)false);
            tessellator.func_78382_b();
            tessellator.func_78370_a(255, 255, 255, 32);
            double d30 = -0.3;
            double d4 = -0.3;
            double d6 = 0.30000000000000004;
            double d8 = -0.3;
            double d10 = -0.3;
            double d12 = 0.30000000000000004;
            double d14 = 0.30000000000000004;
            double d16 = 0.30000000000000004;
            double maxY2 = dist * (double)f1;
            double d20 = 0.0;
            double d22 = 1.0;
            double d24 = -1.0f + f3;
            double d26 = (double)(256.0f * f1) + d24;
            tessellator.func_78374_a(playerXOffset + d30, playerYOffset + maxY2, playerZOffset + d4, d22, d26);
            tessellator.func_78374_a(playerXOffset + d30, playerYOffset, playerZOffset + d4, d22, d24);
            tessellator.func_78374_a(playerXOffset + d6, playerYOffset, playerZOffset + d8, d20, d24);
            tessellator.func_78374_a(playerXOffset + d6, playerYOffset + maxY2, playerZOffset + d8, d20, d26);
            tessellator.func_78374_a(playerXOffset + d14, playerYOffset + maxY2, playerZOffset + d16, d22, d26);
            tessellator.func_78374_a(playerXOffset + d14, playerYOffset, playerZOffset + d16, d22, d24);
            tessellator.func_78374_a(playerXOffset + d10, playerYOffset, playerZOffset + d12, d20, d24);
            tessellator.func_78374_a(playerXOffset + d10, playerYOffset + maxY2, playerZOffset + d12, d20, d26);
            tessellator.func_78374_a(playerXOffset + d6, playerYOffset + maxY2, playerZOffset + d8, d22, d26);
            tessellator.func_78374_a(playerXOffset + d6, playerYOffset, playerZOffset + d8, d22, d24);
            tessellator.func_78374_a(playerXOffset + d14, playerYOffset, playerZOffset + d16, d20, d24);
            tessellator.func_78374_a(playerXOffset + d14, playerYOffset + maxY2, playerZOffset + d16, d20, d26);
            tessellator.func_78374_a(playerXOffset + d10, playerYOffset + maxY2, playerZOffset + d12, d22, d26);
            tessellator.func_78374_a(playerXOffset + d10, playerYOffset, playerZOffset + d12, d22, d24);
            tessellator.func_78374_a(playerXOffset + d30, playerYOffset, playerZOffset + d4, d20, d24);
            tessellator.func_78374_a(playerXOffset + d30, playerYOffset + maxY2, playerZOffset + d4, d20, d26);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glDepthMask((boolean)true);
        }
    }

    protected void func_180580_a(EntityMagicalHorse horse, float partialTickTime) {
        float f1 = 1.0f;
        int i = horse.func_110265_bP();
        if (i == 1) {
            f1 *= 0.87f;
        } else if (i == 2) {
            f1 *= 0.92f;
        }
        GlStateManager.scale(f1, f1, f1);
        super.func_77041_b((EntityLivingBase)horse, partialTickTime);
    }

    protected ResourceLocation getTextureResource(EntityMagicalHorse horse) {
        return this.getLayeredTextureResource(horse);
    }

    protected ResourceLocation getLayeredTextureResource(EntityMagicalHorse horse) {
        String s = horse.func_110264_co();
        if (!horse.func_175507_cI()) {
            return null;
        }
        ResourceLocation resourcelocation = (ResourceLocation)pathnamesToTextures.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new HorseLayeredTexture(horse.func_94057_bL(), horse.func_110212_cp()));
            pathnamesToTextures.put(s, resourcelocation);
        }
        return resourcelocation;
    }

    protected void func_77041_b(EntityLivingBase entityLivingBase, float p_77041_2_) {
        this.func_180580_a((EntityMagicalHorse)entityLivingBase, p_77041_2_);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getTextureResource((EntityMagicalHorse)entity);
    }
}

