/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.commands;

import com.github.sejoslaw.vanillamagic2.common.quests.Quest;
import com.github.sejoslaw.vanillamagic2.common.registries.QuestRegistry;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;

public class QuestArgumentType
implements ArgumentType<Quest> {
    public Quest parse(StringReader reader) throws CommandSyntaxException {
        return QuestRegistry.getQuest(reader.readString());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197005_b(this.getExamples(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return QuestRegistry.getQuests().stream().map(q -> q.uniqueName).collect(Collectors.toList());
    }

    public static QuestArgumentType get() {
        return new QuestArgumentType();
    }

    public static Quest getQuest(CommandContext<CommandSource> ctx, String questUniqueName) {
        return (Quest)ctx.getArgument(questUniqueName, Quest.class);
    }
}

