/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.explosions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;

public class VMExplosion
extends Explosion {
    public final World field_77287_j;
    public final Entity field_77283_e;
    public final Random field_77290_i = new Random();
    public final DamageSource field_199593_j;
    public final List<EntityDamage> entitiesInRange = new ArrayList<EntityDamage>();
    public final long[][] destroyedBlockPositions;
    public final double maxDistance;
    public final float explosionDropRate = 0.1f;
    public final int mapHeight;
    public final int areaSize;
    public final int areaX;
    public final int areaZ;
    private float power;
    private double explosionX;
    private double explosionY;
    private double explosionZ;

    public VMExplosion(World world, Entity entity, BlockPos position, float power, boolean flaming, Explosion.Mode mode) {
        this(world, entity, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), power, flaming, mode);
    }

    public VMExplosion(World world, Entity entity, double x, double y, double z, float power, boolean flaming, Explosion.Mode mode) {
        super(world, entity, x, y, z, power, flaming, mode);
        this.field_77287_j = world;
        this.field_77283_e = entity;
        this.setNewExplosionPosition(x, y, z);
        this.mapHeight = world.func_217301_I();
        this.power = power;
        this.maxDistance = (double)this.power / 0.4;
        int maxDistanceInt = (int)Math.ceil(this.maxDistance);
        this.areaSize = maxDistanceInt * 2;
        this.areaX = VMExplosion.roundToNegInf(x) - maxDistanceInt;
        this.areaZ = VMExplosion.roundToNegInf(z) - maxDistanceInt;
        this.field_199593_j = DamageSource.func_94539_a((Explosion)this);
        this.destroyedBlockPositions = new long[this.mapHeight][];
    }

    public void setNewExplosionPosition(double x, double y, double z) {
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
    }

    public void doExplosion() {
        boolean entitiesAreInRange;
        if (this.power <= 0.0f) {
            this.power = 1.0f;
        }
        int range = this.areaSize / 2;
        BlockPos pos = new BlockPos(this.getPosition());
        BlockPos start = pos.func_177982_a(-range, -range, -range);
        BlockPos end = pos.func_177982_a(range, range, range);
        List entities = this.field_77287_j.func_72839_b(null, new AxisAlignedBB(start, end));
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) && !(entity instanceof ItemEntity)) continue;
            int distance = (int)(VMExplosion.square(entity.func_226277_ct_() - this.explosionX) + VMExplosion.square(entity.func_226278_cu_() - this.explosionY) + VMExplosion.square(entity.func_226281_cx_() - this.explosionZ));
            double health = VMExplosion.getEntityHealth(entity);
            this.entitiesInRange.add(new EntityDamage(entity, distance, health));
        }
        boolean bl = entitiesAreInRange = !this.entitiesInRange.isEmpty();
        if (entitiesAreInRange) {
            this.entitiesInRange.sort(Comparator.comparingInt(entityDamage -> entityDamage.distance));
        }
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / this.maxDistance));
        BlockPos.Mutable tmpPos = new BlockPos.Mutable();
        for (int phiN = 0; phiN < 2 * steps; ++phiN) {
            for (int thetaN = 0; thetaN < steps; ++thetaN) {
                double phi = Math.PI * 2 / (double)steps * (double)phiN;
                double theta = Math.PI / (double)steps * (double)thetaN;
                this.shootRay(this.explosionX, this.explosionY, this.explosionZ, phi, theta, this.power, entitiesAreInRange && phiN % 8 == 0 && thetaN % 8 == 0, tmpPos);
            }
        }
        for (EntityDamage entityDamage2 : this.entitiesInRange) {
            Entity entity = entityDamage2.entity;
            entity.func_70097_a(this.field_199593_j, (float)entityDamage2.damage);
            double motionSquare = VMExplosion.square(entity.func_213322_ci().func_82615_a()) + VMExplosion.square(entity.func_213322_ci().func_82617_b()) + VMExplosion.square(entity.func_213322_ci().func_82616_c());
            double reduction = motionSquare > 3600.0 ? Math.sqrt(3600.0 / motionSquare) : 1.0;
            Vec3d newMotion = entity.func_213322_ci().func_72441_c(entityDamage2.motionX * reduction, entityDamage2.motionY * reduction, entityDamage2.motionZ * reduction);
            entity.func_213317_d(newMotion);
        }
        Random worldRandom = this.field_77287_j.field_73012_v;
        boolean doDrops = this.field_77287_j.func_82736_K().func_223586_b(new GameRules.RuleKey("doTileDrops"));
        HashMap<PositionXZ, Map> blocksToDrop = new HashMap<PositionXZ, Map>();
        this.field_77287_j.func_184148_a(null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (worldRandom.nextFloat() - worldRandom.nextFloat()) * 0.2f) * 0.7f);
        for (int y = 0; y < this.destroyedBlockPositions.length; ++y) {
            long[] bitSet = this.destroyedBlockPositions[y];
            if (bitSet == null) continue;
            int index = -2;
            while ((index = VMExplosion.nextSetIndex(index + 2, bitSet, 2)) != -1) {
                int realIndex = index / 2;
                int z = realIndex / this.areaSize;
                int x = realIndex - z * this.areaSize;
                tmpPos.func_181079_c(x += this.areaX, y, z += this.areaZ);
                BlockState state = this.field_77287_j.func_180495_p((BlockPos)tmpPos);
                Block block = state.func_177230_c();
                if (this.power >= 20.0f || doDrops && block.func_149659_a((Explosion)this) && VMExplosion.getAtIndex(index, bitSet, 2) == 1) {
                    DimensionType dimensionType = this.field_77287_j.func_201675_m().func_186058_p();
                    state.func_177230_c();
                    List drops = Block.func_220070_a((BlockState)state, (ServerWorld)this.field_77287_j.func_73046_m().func_71218_a(dimensionType), (BlockPos)tmpPos, null);
                    for (ItemStack stack : drops) {
                        if (!(worldRandom.nextFloat() <= this.explosionDropRate)) continue;
                        PositionXZ positionXZ = new PositionXZ(x / 2, z / 2);
                        Map map = blocksToDrop.computeIfAbsent(positionXZ, k -> new HashMap());
                        DropData data = (DropData)map.get(stack);
                        if (data == null) {
                            data = new DropData(stack.func_190916_E(), y);
                            map.put(stack.func_77946_l(), data);
                            continue;
                        }
                        data.add(stack.func_190916_E(), y);
                    }
                }
                BlockState tmpState = this.field_77287_j.func_180495_p((BlockPos)tmpPos);
                block.onBlockExploded(tmpState, this.field_77287_j, (BlockPos)tmpPos, (Explosion)this);
            }
        }
        for (Map.Entry blocksToDropEntry : blocksToDrop.entrySet()) {
            PositionXZ positionXZ = (PositionXZ)blocksToDropEntry.getKey();
            for (Map.Entry entry : ((Map)blocksToDropEntry.getValue()).entrySet()) {
                int stackSize;
                ItemStack entryStack = (ItemStack)entry.getKey();
                for (int entryStackSize = ((DropData)entry.getValue()).stackSize; entryStackSize > 0; entryStackSize -= stackSize) {
                    stackSize = Math.min(entryStackSize, 64);
                    ItemEntity itemEntity = new ItemEntity(this.field_77287_j, (double)(((float)positionXZ.x + this.field_77287_j.field_73012_v.nextFloat()) * 2.0f), (double)((DropData)entry.getValue()).maxY + 0.5, (double)(((float)positionXZ.z + this.field_77287_j.field_73012_v.nextFloat()) * 2.0f), entryStack);
                    itemEntity.func_174869_p();
                    this.field_77287_j.func_217376_c((Entity)itemEntity);
                }
            }
        }
    }

    private void destroyUnchecked(int x, int y, int z, boolean noDrop) {
        int index = ((z - this.areaZ) * this.areaSize + (x - this.areaX)) * 2;
        long[] array = this.destroyedBlockPositions[y];
        if (array == null) {
            array = VMExplosion.makeArray(VMExplosion.square(this.areaSize), 2);
            this.destroyedBlockPositions[y] = array;
        }
        if (noDrop) {
            VMExplosion.setAtIndex(index, array, 3);
        } else {
            VMExplosion.setAtIndex(index, array, 1);
        }
    }

    private void shootRay(double x, double y, double z, double phi, double theta, double power, boolean killEntities, BlockPos.Mutable tmpPos) {
        int blockY;
        double deltaX = Math.sin(theta) * Math.cos(phi);
        double deltaY = Math.cos(theta);
        double deltaZ = Math.sin(theta) * Math.sin(phi);
        int step = 0;
        while ((blockY = VMExplosion.roundToNegInf(y)) >= 0 && blockY < this.mapHeight) {
            int blockX = VMExplosion.roundToNegInf(x);
            int blockZ = VMExplosion.roundToNegInf(z);
            tmpPos.func_181079_c(blockX, blockY, blockZ);
            BlockState state = this.field_77287_j.func_180495_p((BlockPos)tmpPos);
            Block block = state.func_177230_c();
            double absorption = this.getAbsorption(block, (BlockPos)tmpPos);
            if (absorption < 0.0) break;
            if (absorption > 1000.0) {
                absorption = 0.5;
            } else {
                if (absorption > power) break;
                if (block == Blocks.field_150348_b || block != Blocks.field_150350_a && !block.isAir(state, (IBlockReader)this.field_77287_j, (BlockPos)tmpPos)) {
                    this.destroyUnchecked(blockX, blockY, blockZ, power > 8.0);
                }
            }
            if (killEntities && (step + 4) % 8 == 0 && !this.entitiesInRange.isEmpty() && power >= 0.25) {
                this.damageEntities(x, y, z, step, power);
            }
            if (absorption > 10.0) {
                for (int i = 0; i < 5; ++i) {
                    this.shootRay(x, y, z, this.field_77290_i.nextDouble() * 2.0 * Math.PI, this.field_77290_i.nextDouble() * Math.PI, absorption * 0.4, false, tmpPos);
                }
            }
            power -= absorption;
            x += deltaX;
            y += deltaY;
            z += deltaZ;
            ++step;
        }
    }

    private double getAbsorption(Block block, BlockPos pos) {
        double ret = 0.5;
        if (block == Blocks.field_150350_a || block.isAir(block.func_176223_P(), (IBlockReader)this.field_77287_j, pos)) {
            return ret;
        }
        if (block == Blocks.field_150357_h) {
            return ret += 800.0;
        }
        if (block == Blocks.field_150355_j) {
            ret += 1.0;
        } else {
            BlockState state = this.field_77287_j.func_180495_p(pos);
            float resistance = block.getExplosionResistance(state, (IWorldReader)this.field_77287_j, pos, this.field_77283_e, (Explosion)this);
            if (resistance < 0.0f) {
                return resistance;
            }
        }
        return ret;
    }

    private void damageEntities(double x, double y, double z, int step, double power) {
        int index;
        if (step != 4) {
            int distanceMin = VMExplosion.square(step - 5);
            int indexStart = 0;
            int indexEnd = this.entitiesInRange.size() - 1;
            do {
                index = (indexStart + indexEnd) / 2;
                int distance = this.entitiesInRange.get((int)index).distance;
                if (distance < distanceMin) {
                    indexStart = index + 1;
                    continue;
                }
                indexEnd = distance > distanceMin ? index - 1 : index;
            } while (indexStart < indexEnd);
        } else {
            index = 0;
        }
        int distanceMax = VMExplosion.square(step + 5);
        for (int i = index; i < this.entitiesInRange.size(); ++i) {
            Entity entity;
            EntityDamage entityDamage = this.entitiesInRange.get(i);
            if (entityDamage.distance >= distanceMax || VMExplosion.square((entity = entityDamage.entity).func_226277_ct_() - x) + VMExplosion.square(entity.func_226278_cu_() - y) + VMExplosion.square(entity.func_226281_cx_() - z) > 25.0) continue;
            double damage = 4.0 * power;
            entityDamage.damage += damage;
            entityDamage.health -= damage;
            double deltaX = entity.func_226277_ct_() - this.explosionX;
            double deltaY = entity.func_226278_cu_() - this.explosionY;
            double deltaZ = entity.func_226281_cx_() - this.explosionZ;
            double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            double offset = 0.0875;
            entityDamage.motionX += deltaX / distance * offset * power;
            entityDamage.motionY += deltaY / distance * offset * power;
            entityDamage.motionZ += deltaZ / distance * offset * power;
            if (entityDamage.health > 0.0) continue;
            entity.func_70097_a(this.field_199593_j, (float)entityDamage.damage);
            if (entity.func_70089_S()) continue;
            this.entitiesInRange.remove(i);
            --i;
        }
    }

    private static double getEntityHealth(Entity entity) {
        if (entity instanceof ItemEntity) {
            return 5.0;
        }
        return 1.0;
    }

    private static long[] makeArray(int size, int step) {
        return new long[(size * step + 8 - step) / 8];
    }

    private static int nextSetIndex(int start, long[] array, int step) {
        int offset = start % 8;
        for (int i = start / 8; i < array.length; ++i) {
            long l = array[i];
            for (int j = offset; j < 8; j += step) {
                int val = (int)(l >> j & (long)((1 << step) - 1));
                if (val == 0) continue;
                return i * 8 + j;
            }
            offset = 0;
        }
        return -1;
    }

    private static int getAtIndex(int index, long[] array, int step) {
        return (int)(array[index / 8] >>> index % 8 & (long)((1 << step) - 1));
    }

    private static void setAtIndex(int index, long[] array, int value) {
        int n = index / 8;
        array[n] = array[n] | (long)(value << index % 8);
    }

    public static int roundToNegInf(double x) {
        int ret = (int)x;
        if ((double)ret > x) {
            --ret;
        }
        return ret;
    }

    public static int square(int x) {
        return x * x;
    }

    public static double square(double x) {
        return x * x;
    }

    private static class EntityDamage {
        final Entity entity;
        final int distance;
        double health;
        double damage;
        double motionX;
        double motionY;
        double motionZ;

        EntityDamage(Entity entity, int distance, double health) {
            this.entity = entity;
            this.distance = distance;
            this.health = health;
        }
    }

    private static class DropData {
        int stackSize;
        int maxY;

        DropData(int stackSize, int y) {
            this.stackSize = stackSize;
            this.maxY = y;
        }

        public DropData add(int stackSize, int y) {
            this.stackSize += stackSize;
            if (y > this.maxY) {
                this.maxY = y;
            }
            return this;
        }
    }

    private static class PositionXZ {
        int x;
        int z;

        PositionXZ(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PositionXZ) {
                PositionXZ position = (PositionXZ)obj;
                return position.x == this.x && position.z == this.z;
            }
            return false;
        }

        public int hashCode() {
            return this.x * 31 ^ this.z;
        }
    }
}

