/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.handlers;

import com.github.sejoslaw.vanillamagic2.common.functions.Action;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer2;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer3;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer4;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

public abstract class EventHandler {
    protected final String squareSymbol = "\u25a0";

    public void onItemExpire(ItemExpireEvent event, Consumer4<ItemEntity, ItemStack, World, BlockPos> consumer) {
        ItemEntity entity = event.getEntityItem();
        consumer.accept(entity, entity.func_92059_d(), entity.func_130014_f_(), entity.func_180425_c());
    }

    public void onLivingDeath(LivingDeathEvent event, Consumer2<LivingEntity, DamageSource> consumer) {
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        consumer.accept(entity, source);
    }

    public void onShowTooltip(ItemTooltipEvent event, boolean show, Consumer3<PlayerEntity, ItemStack, List<ITextComponent>> consumer) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        List tooltips = event.getToolTip();
        if (!show) {
            return;
        }
        consumer.accept(player, stack, tooltips);
    }

    public void withFood(ItemStack stack, Consumer<Food> consumer) {
        if (stack.func_77973_b().func_219971_r()) {
            consumer.accept(stack.func_77973_b().func_219967_s());
        }
    }

    public void forDamageable(ItemStack stack, Action action) {
        if (stack.func_77984_f()) {
            action.execute();
        }
    }

    public void onServerStarting(FMLServerStartingEvent event, Consumer2<MinecraftServer, CommandDispatcher<CommandSource>> consumer) {
        MinecraftServer server = event.getServer();
        CommandDispatcher dispatcher = event.getCommandDispatcher();
        consumer.accept(server, (CommandDispatcher<CommandSource>)dispatcher);
    }

    public void registerRenderers(FMLClientSetupEvent event, Consumer<Minecraft> consumer) {
        Minecraft mc = (Minecraft)event.getMinecraftSupplier().get();
        consumer.accept(mc);
    }

    public void onPlayerInteract(PlayerInteractEvent event, Consumer4<PlayerEntity, World, BlockPos, Direction> consumer) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        consumer.accept(player, world, pos, face);
    }
}

