/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.handlers.clients;

import com.github.sejoslaw.vanillamagic2.common.files.VMForgeConfig;
import com.github.sejoslaw.vanillamagic2.common.handlers.EventHandler;
import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ShowDurabilityTooltipHandler
extends EventHandler {
    @SubscribeEvent
    public void showTooltip(ItemTooltipEvent event) {
        this.onShowTooltip(event, (Boolean)VMForgeConfig.SHOW_DURABILITY_TOOLTIP.get(), (player, stack, tooltips) -> this.forDamageable((ItemStack)stack, () -> tooltips.add(TextUtils.toComponent(this.getDurabilityString((ItemStack)stack)))));
    }

    private String getDurabilityString(ItemStack stack) {
        String message = TextUtils.getFormattedText("vm.handler.durability") + " ";
        int max = stack.func_77958_k();
        int damage = stack.func_77952_i();
        float percentage = 1.0f - (float)damage / (float)max;
        message = (double)percentage >= 0.9 ? message + TextFormatting.LIGHT_PURPLE : ((double)percentage >= 0.8 ? message + TextFormatting.DARK_PURPLE : ((double)percentage >= 0.7 ? message + TextFormatting.BLUE : ((double)percentage >= 0.6 ? message + TextFormatting.DARK_AQUA : ((double)percentage >= 0.5 ? message + TextFormatting.DARK_GREEN : ((double)percentage >= 0.4 ? message + TextFormatting.GREEN : ((double)percentage >= 0.3 ? message + TextFormatting.YELLOW : ((double)percentage >= 0.2 ? message + TextFormatting.GOLD : ((double)percentage >= 0.1 ? message + TextFormatting.RED : message + TextFormatting.DARK_RED))))))));
        return message + (max - damage) + " / " + max + TextFormatting.RESET;
    }
}

