/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests;

import com.github.sejoslaw.vanillamagic2.common.functions.Action;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer2;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer3;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer4;
import com.github.sejoslaw.vanillamagic2.common.functions.Consumer5;
import com.github.sejoslaw.vanillamagic2.common.functions.Function2;
import com.github.sejoslaw.vanillamagic2.common.functions.Function3;
import com.github.sejoslaw.vanillamagic2.common.functions.Function4;
import com.github.sejoslaw.vanillamagic2.common.handlers.EventHandler;
import com.github.sejoslaw.vanillamagic2.common.quests.EventCaller;
import com.github.sejoslaw.vanillamagic2.common.quests.Quest;
import com.github.sejoslaw.vanillamagic2.common.recipes.AltarRecipe;
import com.github.sejoslaw.vanillamagic2.common.registries.PlayerQuestProgressRegistry;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.VMTileMachine;
import com.github.sejoslaw.vanillamagic2.common.utils.AltarUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.ItemStackUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.PlayerQuestProgressUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.WorldUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public final class EventExecutor<TQuest extends Quest>
extends EventHandler {
    private final EventCaller<TQuest> caller;

    public EventExecutor(EventCaller<TQuest> caller) {
        this.caller = caller;
    }

    public TQuest click(Block block, World world, BlockPos pos, Supplier<TQuest> action) {
        return (TQuest)(world.func_180495_p(pos).func_177230_c() == block ? (Quest)action.get() : null);
    }

    public void withHands(PlayerEntity player, Consumer2<ItemStack, ItemStack> consumer) {
        consumer.accept(player.func_184592_cb(), player.func_184614_ca());
    }

    public void forQuestWithCheck(Function<TQuest, Boolean> check, Consumer<TQuest> action) {
        this.caller.quests.stream().filter(check::apply).forEach(action);
    }

    public void onAttackEntityNoHandsCheck(AttackEntityEvent event, Function3<PlayerEntity, World, Entity, TQuest> check, Consumer4<PlayerEntity, World, Entity, TQuest> consumer) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        Entity target = event.getTarget();
        this.performCheckNoHandsCheck(player, () -> (Quest)check.apply(player, world, target), quest -> consumer.accept(player, world, target, quest));
    }

    public void onBlockEvent(BlockEvent event, PlayerEntity player, Function3<World, BlockPos, BlockState, TQuest> check, Consumer4<World, BlockPos, BlockState, TQuest> consumer) {
        World world = event.getWorld().func_201672_e();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        this.performCheck(player, () -> (Quest)check.apply(world, pos, state), quest -> consumer.accept(world, pos, state, quest));
    }

    public void onBlockEventNoHandsCheck(BlockEvent event, PlayerEntity player, Function3<World, BlockPos, BlockState, TQuest> check, Consumer4<World, BlockPos, BlockState, TQuest> consumer) {
        World world = event.getWorld().func_201672_e();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        this.performCheckNoHandsCheck(player, () -> (Quest)check.apply(world, pos, state), quest -> consumer.accept(world, pos, state, quest));
    }

    public void onBlockBreak(BlockEvent.BreakEvent event, Function4<PlayerEntity, World, BlockPos, BlockState, TQuest> check, Consumer4<PlayerEntity, World, BlockPos, BlockState> consumer) {
        PlayerEntity player = event.getPlayer();
        this.onBlockEvent((BlockEvent)event, player, (world, pos, state) -> (Quest)check.apply(player, (World)world, (BlockPos)pos, (BlockState)state), (world, pos, state, quest) -> consumer.accept(player, (World)world, (BlockPos)pos, (BlockState)state));
    }

    public void onBlockBreakNoHandsCheck(BlockEvent.BreakEvent event, Function4<PlayerEntity, World, BlockPos, BlockState, TQuest> check, Consumer5<PlayerEntity, World, BlockPos, BlockState, TQuest> consumer) {
        PlayerEntity player = event.getPlayer();
        this.onBlockEventNoHandsCheck((BlockEvent)event, player, (world, pos, state) -> (Quest)check.apply(player, (World)world, (BlockPos)pos, (BlockState)state), (world, pos, state, quest) -> consumer.accept(player, (World)world, (BlockPos)pos, (BlockState)state, (Object)quest));
    }

    @Override
    public void onPlayerInteract(PlayerInteractEvent event, Consumer4<PlayerEntity, World, BlockPos, Direction> consumer) {
        super.onPlayerInteract(event, (player, world, pos, direction) -> this.performCheck((PlayerEntity)player, quest -> consumer.accept((PlayerEntity)player, (World)world, (BlockPos)pos, (Direction)direction)));
    }

    public void onPlayerInteractNoStackSizeCheck(PlayerInteractEvent event, Consumer4<PlayerEntity, World, BlockPos, Direction> consumer) {
        PlayerEntity player = event.getPlayer();
        this.performCheckNoStackSizeCheck(player, quest -> consumer.accept(player, player.field_70170_p, event.getPos(), event.getFace()));
    }

    public void onPlayerInteract(PlayerInteractEvent event, Function4<PlayerEntity, World, BlockPos, Direction, TQuest> check, Consumer5<PlayerEntity, World, BlockPos, Direction, TQuest> consumer) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Direction dir = event.getFace();
        this.performCheck(player, () -> (Quest)check.apply(player, world, pos, dir), quest -> consumer.accept(player, world, pos, dir, quest));
    }

    public void onEntityPlace(BlockEvent.EntityPlaceEvent event, Function4<PlayerEntity, World, BlockState, BlockPos, TQuest> check, Consumer4<PlayerEntity, World, BlockState, BlockPos> consumer) {
        Entity entity = event.getEntity();
        PlayerEntity player = entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
        this.onBlockEvent((BlockEvent)event, player, (world, pos, state) -> (Quest)check.apply(player, (World)world, (BlockState)state, (BlockPos)pos), (world, pos, state, quest) -> consumer.accept(player, (World)world, (BlockState)state, (BlockPos)pos));
    }

    public void onEntityInteract(PlayerInteractEvent.EntityInteract event, Function4<PlayerEntity, Entity, World, BlockPos, TQuest> check, Consumer4<PlayerEntity, Entity, World, BlockPos> consumer) {
        Entity target = event.getTarget();
        this.onPlayerInteract((PlayerInteractEvent)event, (player, world, pos, direction) -> (Quest)check.apply((PlayerEntity)player, target, (World)world, (BlockPos)pos), (player, world, pos, direction, quest) -> consumer.accept((PlayerEntity)player, target, (World)world, (BlockPos)pos));
    }

    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event, Function3<PlayerEntity, ItemStack, IInventory, TQuest> check, Consumer3<PlayerEntity, ItemStack, IInventory> consumer) {
        PlayerEntity player = event.getPlayer();
        ItemStack result = event.getCrafting();
        IInventory inv = event.getInventory();
        this.performCheck(player, () -> (Quest)check.apply(player, result, inv), quest -> consumer.accept(player, result, inv));
    }

    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event, Function<PlayerEntity, TQuest> check, Consumer2<PlayerEntity, TQuest> consumer) {
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        this.performCheck(player, () -> (Quest)check.apply(player), quest -> consumer.accept(player, quest));
    }

    public void onItemPickup(PlayerEvent.ItemPickupEvent event, Function4<PlayerEntity, World, ItemEntity, ItemStack, TQuest> check, Consumer5<PlayerEntity, World, ItemEntity, ItemStack, TQuest> consumer) {
        PlayerEntity player = event.getPlayer();
        ItemEntity originalEntity = event.getOriginalEntity();
        ItemStack pickedStack = event.getStack();
        World world = player.field_70170_p;
        this.performCheck(player, () -> (Quest)check.apply(player, world, originalEntity, pickedStack), quest -> consumer.accept(player, world, originalEntity, pickedStack, quest));
    }

    public void onPlayerTick(TickEvent.PlayerTickEvent event, Consumer3<PlayerEntity, World, TQuest> consumer) {
        PlayerEntity player = event.player;
        World world = player.field_70170_p;
        this.performCheck(player, quest -> consumer.accept(player, world, quest));
    }

    public void onPlayerTick(TickEvent.PlayerTickEvent event, Function2<PlayerEntity, World, TQuest> check, Consumer3<PlayerEntity, World, TQuest> consumer) {
        PlayerEntity player = event.player;
        World world = player.field_70170_p;
        this.performCheck(player, () -> (Quest)check.apply(player, world), quest -> consumer.accept(player, world, quest));
    }

    public void onPlayerTickNoHandsCheck(TickEvent.PlayerTickEvent event, Function2<PlayerEntity, World, TQuest> check, Consumer3<PlayerEntity, World, TQuest> consumer) {
        PlayerEntity player = event.player;
        World world = player.field_70170_p;
        this.performCheckNoHandsCheck(player, () -> (Quest)check.apply(player, world), quest -> consumer.accept(player, world, quest));
    }

    public void craftOnAltar(PlayerInteractEvent event, List<AltarRecipe> recipes, Function2<ItemStack, ItemStack, Boolean> optionalCheck) {
        List[] ingredientsInCauldron = new List[1];
        AltarRecipe[] chosenRecipe = new AltarRecipe[1];
        this.onPlayerInteract(event, (player, world, pos, direction) -> this.click(Blocks.field_150383_bp, (World)world, (BlockPos)pos, () -> {
            if (world.field_72995_K) {
                return null;
            }
            ingredientsInCauldron[0] = WorldUtils.getItems(world, pos);
            if (ingredientsInCauldron[0].size() == 0) {
                return null;
            }
            for (AltarRecipe recipe : recipes) {
                if (!AltarUtils.canCraftOnAltar(recipe.ingredients, ingredientsInCauldron[0], optionalCheck)) continue;
                chosenRecipe[0] = recipe;
                return chosenRecipe[0].quest;
            }
            return null;
        }), (player, world, pos, direction, quest) -> {
            if (world.field_72995_K) {
                return;
            }
            ingredientsInCauldron[0].forEach(Entity::func_70106_y);
            BlockPos newItemPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
            chosenRecipe[0].results.forEach(stack -> Block.func_180635_a((World)world, (BlockPos)newItemPos, (ItemStack)stack.func_77946_l()));
        });
    }

    public void useVMItem(PlayerEntity player, String vmItemUniqueKey, Consumer<ItemStack> consumer) {
        this.withHands(player, (leftHandStack, rightHandStack) -> {
            String key;
            CompoundNBT nbt = rightHandStack.func_196082_o();
            if (nbt.func_74764_b(key = "NBT_VM_ITEM_UNIQUE_NAME") && nbt.func_74779_i(key).equals(vmItemUniqueKey)) {
                consumer.accept((ItemStack)rightHandStack);
                return;
            }
            nbt = leftHandStack.func_196082_o();
            if (nbt.func_74764_b(key) && nbt.func_74779_i(key).equals(vmItemUniqueKey)) {
                consumer.accept((ItemStack)leftHandStack);
            }
        });
    }

    public void addVMTileMachine(PlayerInteractEvent.RightClickBlock event, String moduleKey) {
        this.onPlayerInteract((PlayerInteractEvent)event, (player, world, pos, direction) -> this.click(Blocks.field_150383_bp, (World)world, (BlockPos)pos, () -> (Quest)this.caller.quests.get(0)), (player, world, pos, direction, quest) -> WorldUtils.spawnVMTile(world, pos, new VMTileMachine(), tile -> tile.setModuleKey(moduleKey)));
    }

    public boolean areHeldItemsCorrect(PlayerEntity player, TQuest quest, boolean checkStackSize) {
        if (((Quest)quest).leftHandStack != null && !ItemStackUtils.areEqual(player.func_184592_cb(), ((Quest)quest).leftHandStack, checkStackSize)) {
            return false;
        }
        return ((Quest)quest).rightHandStack == null || ItemStackUtils.areEqual(player.func_184614_ca(), ((Quest)quest).rightHandStack, checkStackSize);
    }

    private void checkRegisteredQuestsCount(Action action) {
        if (this.caller.quests.size() <= 0) {
            return;
        }
        action.execute();
    }

    private void performCheck(PlayerEntity player, Consumer<TQuest> consumer) {
        this.checkRegisteredQuestsCount(() -> this.checkItemsInHands(player, quest -> this.checkQuestProgress(player, quest, consumer), true));
    }

    private void performCheckNoStackSizeCheck(PlayerEntity player, Consumer<TQuest> consumer) {
        this.checkRegisteredQuestsCount(() -> this.checkItemsInHands(player, quest -> this.checkQuestProgress(player, quest, consumer), false));
    }

    private void performCheck(PlayerEntity player, Supplier<TQuest> check, Consumer<TQuest> consumer) {
        this.checkRegisteredQuestsCount(() -> this.checkItemsInHands(player, arg_0 -> this.lambda$null$43((Supplier)check, player, consumer, arg_0), true));
    }

    private void performCheckNoHandsCheck(PlayerEntity player, Supplier<TQuest> check, Consumer<TQuest> consumer) {
        this.checkRegisteredQuestsCount(() -> {
            Quest quest = (Quest)check.get();
            if (quest == null) {
                return;
            }
            this.checkQuestProgress(player, quest, consumer);
        });
    }

    private void checkItemsInHands(PlayerEntity player, Consumer<TQuest> consumer, boolean checkStackSize) {
        for (Quest quest : this.caller.quests) {
            if (!this.areHeldItemsCorrect(player, quest, checkStackSize)) continue;
            consumer.accept(quest);
            return;
        }
    }

    private void checkQuestProgress(PlayerEntity player, TQuest quest, Consumer<TQuest> consumer) {
        String questUniqueName = ((Quest)quest).uniqueName;
        if (!PlayerQuestProgressRegistry.hasPlayerGotQuest(player, questUniqueName)) {
            if (PlayerQuestProgressRegistry.canPlayerGetQuest(player, questUniqueName)) {
                PlayerQuestProgressUtils.givePlayerQuest(player, quest);
            } else {
                return;
            }
        }
        consumer.accept(quest);
    }

    private /* synthetic */ void lambda$null$43(Supplier check, PlayerEntity player, Consumer consumer, Quest skippedQuest) {
        Quest quest = (Quest)check.get();
        if (quest == null || !this.areHeldItemsCorrect(player, quest, true)) {
            return;
        }
        this.checkQuestProgress(player, quest, consumer);
    }
}

