/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests.eventcallers;

import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerCraftable;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestCrystallizedLiquid;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class EventCallerCrystallizedLiquid
extends EventCallerCraftable<QuestCrystallizedLiquid> {
    @Override
    public void fillRecipes() {
        Set entries = ForgeRegistries.FLUIDS.getEntries().stream().filter(entry -> !((ResourceLocation)entry.getKey()).toString().contains("flowing_")).collect(Collectors.toSet());
        this.fillCrystalRecipesFromRegistry(entries, fluid -> new ItemStack((IItemProvider)fluid.func_204524_b()), fluid -> new ItemStack((IItemProvider)Items.field_151156_bN), "vmitem.crystallizedLiquid.namePrefix", entry -> ((Fluid)entry.getValue()).func_207188_f().func_206883_i().func_177230_c().func_200291_n().func_150254_d());
    }

    @SubscribeEvent
    public void spawnLiquid(PlayerInteractEvent.RightClickBlock event) {
        this.executor.onPlayerInteract((PlayerInteractEvent)event, (player, world, pos, direction) -> this.executor.withHands((PlayerEntity)player, (leftHandStack, rightHandStack) -> {
            String fluidKey = rightHandStack.func_196082_o().func_74779_i("NBT_VM_ITEM_UNIQUE_NAME");
            this.executor.useVMItem((PlayerEntity)player, fluidKey, handStack -> {
                TileEntity tile = world.func_175625_s(pos);
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidKey));
                if (tile instanceof IFluidHandler) {
                    ((IFluidHandler)tile).fill(this.getFluidStackToFill(fluid), IFluidHandler.FluidAction.EXECUTE);
                } else if (tile instanceof IFluidTank) {
                    ((IFluidTank)tile).fill(this.getFluidStackToFill(fluid), IFluidHandler.FluidAction.EXECUTE);
                } else if (fluid == Fluids.field_204546_a && world.func_180495_p(pos).func_177230_c() == Blocks.field_150383_bp) {
                    world.func_175656_a(pos, (BlockState)Blocks.field_150383_bp.func_176223_P().func_206870_a((IProperty)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(3)));
                } else if (tile != null) {
                    IFluidHandler fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction).orElse(null);
                    if (fluidHandler != null) {
                        fluidHandler.fill(this.getFluidStackToFill(fluid), IFluidHandler.FluidAction.EXECUTE);
                    }
                } else {
                    world.func_175656_a(pos.func_177972_a(direction), fluid.func_207188_f().func_206883_i());
                }
            });
        }));
    }

    private FluidStack getFluidStackToFill(Fluid fluid) {
        return new FluidStack(fluid, 1000);
    }
}

