/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.quests.eventcallers;

import com.github.sejoslaw.vanillamagic2.common.itemupgrades.BaseItemType;
import com.github.sejoslaw.vanillamagic2.common.itemupgrades.ItemUpgrade;
import com.github.sejoslaw.vanillamagic2.common.quests.eventcallers.EventCallerUpgradable;
import com.github.sejoslaw.vanillamagic2.common.quests.types.QuestItemUpgrade;
import com.github.sejoslaw.vanillamagic2.common.registries.ItemUpgradeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;

public class EventCallerItemUpgrade
extends EventCallerUpgradable<QuestItemUpgrade> {
    public EventCallerItemUpgrade() {
        ItemUpgradeRegistry.forEach(handler -> {
            handler.getItemUpgradeEventCaller().eventCaller = this;
        });
    }

    @Override
    protected boolean isBase(ItemStack stack) {
        return ItemUpgradeRegistry.isBase(stack);
    }

    @Override
    protected boolean isIngredient(ItemStack stack) {
        return ItemUpgradeRegistry.isIngredient(stack);
    }

    @Override
    protected List<ItemStack> getResults(List<ItemEntity> baseItems, List<ItemEntity> ingredients) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (ItemEntity baseEntity : baseItems) {
            ItemStack baseStack = baseEntity.func_92059_d();
            BaseItemType stackItemType = ItemUpgradeRegistry.getBaseItemType(baseStack);
            List<ItemUpgrade> upgrades = ItemUpgradeRegistry.getUpgrades(stackItemType);
            for (ItemUpgrade upgrade : upgrades) {
                ItemEntity ingredient = ingredients.stream().filter(entity -> upgrade.isValidIngredient(entity.func_92059_d())).findFirst().orElse(null);
                if (ingredient == null) continue;
                baseStack.func_196082_o().func_74778_a(upgrade.getUniqueTag(), upgrade.getUniqueTag());
                results.add(baseStack.func_77946_l());
            }
        }
        return results;
    }
}

