/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.registries;

import com.github.sejoslaw.vanillamagic2.common.spells.evokers.EvokerSpell;
import com.github.sejoslaw.vanillamagic2.common.spells.evokers.EvokerSpellFangs;
import com.github.sejoslaw.vanillamagic2.common.spells.evokers.EvokerSpellSummonVex;
import com.github.sejoslaw.vanillamagic2.common.spells.evokers.EvokerSpellWololo;
import com.github.sejoslaw.vanillamagic2.common.utils.EntityUtils;
import com.github.sejoslaw.vanillamagic2.common.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;

public final class EvokerSpellRegistry {
    private static final List<EvokerSpellDefinition> SPELLS = new ArrayList<EvokerSpellDefinition>();

    public static void initialize() {
        SPELLS.add(new EvokerSpellDefinition("spell.evoker.wololo.name", new EvokerSpellWololo()));
        SPELLS.add(new EvokerSpellDefinition("spell.evoker.summonVex.name", new EvokerSpellSummonVex()));
        SPELLS.add(new EvokerSpellDefinition("spell.evoker.fangs.name", new EvokerSpellFangs()));
    }

    public static void changeSpell(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        int spellId = nbt.func_74762_e("NBT_SPELL_ID");
        spellId = spellId + 1 >= SPELLS.size() ? 0 : spellId + 1;
        nbt.func_74768_a("NBT_SPELL_ID", spellId);
        String displayNamePrefix = TextUtils.getFormattedText("vmitem." + nbt.func_74779_i("NBT_VM_ITEM_UNIQUE_NAME") + ".displayName");
        String displayNamePostfix = TextUtils.getFormattedText(EvokerSpellRegistry.SPELLS.get((int)spellId).translationKey);
        stack.func_200302_a(TextUtils.toComponent(displayNamePrefix + ": " + displayNamePostfix));
    }

    public static void castSpell(World world, PlayerEntity player, ItemStack stack) {
        Entity target = EntityUtils.getLookingAt((Entity)player);
        int spellId = stack.func_196082_o().func_74762_e("NBT_SPELL_ID");
        EvokerSpellRegistry.SPELLS.get((int)spellId).spell.cast(world, player, target);
    }

    private static final class EvokerSpellDefinition {
        public final String translationKey;
        public final EvokerSpell spell;

        private EvokerSpellDefinition(String translationKey, EvokerSpell spell) {
            this.translationKey = translationKey;
            this.spell = spell;
        }
    }
}

