/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.registries;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public final class ItemTierRegistry {
    private static final Set<TierEntry> ENTRIES = new HashSet<TierEntry>();
    private static final TierEntry EMPTY = new TierEntry(-1, "EMPTY", new ArrayList<ItemStack>());

    public static void initialize() {
        ItemTierRegistry.add(1, "wooden", Items.field_190931_a);
        ItemTierRegistry.add(2, "stone", Blocks.field_150348_b);
        ItemTierRegistry.add(3, "iron", Items.field_151042_j);
        ItemTierRegistry.add(4, "golden", Items.field_151043_k);
        ItemTierRegistry.add(5, "diamond", Items.field_151045_i);
    }

    public static void add(int tier, String tierType, Block block) {
        ItemTierRegistry.add(tier, tierType, (Item)Item.field_179220_a.get(block));
    }

    public static void add(int tier, String tierType, Item item) {
        ItemTierRegistry.add(tier, tierType, new ItemStack((IItemProvider)item));
    }

    public static void add(int tier, String tierType, ItemStack stack) {
        TierEntry te = ItemTierRegistry.find(tier, tierType);
        if (te == null) {
            te = new TierEntry(tier, tierType, new ArrayList<ItemStack>());
            ENTRIES.add(te);
        }
        te.stacks.add(stack);
    }

    public static boolean isBase(ItemStack item) {
        return ENTRIES.stream().anyMatch(entry -> item.func_77973_b().getRegistryName().func_110623_a().toLowerCase().contains(entry.tierType) && entry.stacks.stream().noneMatch(stack -> stack.func_77973_b() == item.func_77973_b()));
    }

    public static boolean isIngredient(ItemStack item) {
        return !ItemTierRegistry.isBase(item) && ItemTierRegistry.getTier(item) != ItemTierRegistry.EMPTY.tier;
    }

    public static int getTier(ItemStack item) {
        return ItemTierRegistry.ENTRIES.stream().filter((Predicate<TierEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getTier$3(net.minecraft.item.ItemStack com.github.sejoslaw.vanillamagic2.common.registries.ItemTierRegistry$TierEntry ), (Lcom/github/sejoslaw/vanillamagic2/common/registries/ItemTierRegistry$TierEntry;)Z)((ItemStack)item)).findFirst().orElse((TierEntry)ItemTierRegistry.EMPTY).tier;
    }

    public static String getTierType(int tier) {
        return ItemTierRegistry.ENTRIES.stream().filter((Predicate<TierEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getTierType$4(int com.github.sejoslaw.vanillamagic2.common.registries.ItemTierRegistry$TierEntry ), (Lcom/github/sejoslaw/vanillamagic2/common/registries/ItemTierRegistry$TierEntry;)Z)((int)tier)).findFirst().orElse((TierEntry)ItemTierRegistry.EMPTY).tierType;
    }

    public static Map<Integer, List<ItemStack>> getTiers() {
        return ENTRIES.stream().collect(Collectors.toMap(entry -> entry.tier, entry -> entry.stacks));
    }

    public static List<ItemStack> getIngredients(int tier) {
        return ItemTierRegistry.ENTRIES.stream().filter((Predicate<TierEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getIngredients$7(int com.github.sejoslaw.vanillamagic2.common.registries.ItemTierRegistry$TierEntry ), (Lcom/github/sejoslaw/vanillamagic2/common/registries/ItemTierRegistry$TierEntry;)Z)((int)tier)).findFirst().orElse((TierEntry)ItemTierRegistry.EMPTY).stacks;
    }

    private static TierEntry find(int tier, String tierType) {
        return ENTRIES.stream().filter(entry -> entry.tier == tier && entry.tierType.equals(tierType)).findFirst().orElse(null);
    }

    private static /* synthetic */ boolean lambda$getIngredients$7(int tier, TierEntry entry) {
        return entry.tier == tier;
    }

    private static /* synthetic */ boolean lambda$getTierType$4(int tier, TierEntry entry) {
        return entry.tier == tier;
    }

    private static /* synthetic */ boolean lambda$getTier$3(ItemStack item, TierEntry entry) {
        return item.func_77973_b().getRegistryName().func_110623_a().startsWith(entry.tierType) || entry.stacks.stream().anyMatch(ingredient -> ingredient.func_77973_b() == item.func_77973_b());
    }

    private static class TierEntry {
        public final int tier;
        public final String tierType;
        public final List<ItemStack> stacks;

        public TierEntry(int tier, String tierType, List<ItemStack> stacks) {
            this.tier = tier;
            this.tierType = tierType;
            this.stacks = stacks;
        }
    }
}

