/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.registries;

import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.IMachineModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.ForgeCapabilityEnergyModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.ForgeEnergyModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.QuarryLogicModule;
import com.github.sejoslaw.vanillamagic2.common.tileentities.machines.modules.SmeltableTicksEnergyModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MachineModuleRegistry {
    public static final List<IMachineModule> DEFAULT_MODULES = new ArrayList<IMachineModule>();
    public static final Map<String, List<IMachineModule>> MODULES = new HashMap<String, List<IMachineModule>>();
    public static final String QUARRY_KEY = "quarry";
    public static final String FARM_KEY = "farm";

    public static void initialize() {
        DEFAULT_MODULES.add(new SmeltableTicksEnergyModule());
        DEFAULT_MODULES.add(new ForgeEnergyModule());
        DEFAULT_MODULES.add(new ForgeCapabilityEnergyModule());
        MachineModuleRegistry.registerModule(QUARRY_KEY, new QuarryLogicModule());
    }

    private static void registerModule(String key, IMachineModule module) {
        if (!MODULES.containsKey(key)) {
            MODULES.put(key, new ArrayList());
        }
        MODULES.get(key).add(module);
    }
}

