/*
 * Decompiled with CFR 0.152.
 */
package com.github.sejoslaw.vanillamagic2.common.registries;

import com.github.sejoslaw.vanillamagic2.common.quests.Quest;
import com.github.sejoslaw.vanillamagic2.common.registries.QuestRegistry;
import com.github.sejoslaw.vanillamagic2.common.utils.EntityUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;

public final class PlayerQuestProgressRegistry {
    public static final Set<PlayerQuestProgressData> USER_DATA = new HashSet<PlayerQuestProgressData>();

    public static PlayerQuestProgressData getPlayerData(PlayerEntity player) {
        String playerName = EntityUtils.getPlayerName(player);
        return PlayerQuestProgressRegistry.getPlayerData(playerName);
    }

    public static PlayerQuestProgressData getPlayerData(String playerName) {
        return USER_DATA.stream().filter(data -> data.playerName.equals(playerName)).findFirst().orElse(new PlayerQuestProgressData(playerName, new HashSet<String>()));
    }

    public static Set<String> getPlayerQuests(String playerName) {
        return PlayerQuestProgressRegistry.getPlayerData((String)playerName).questUniqueNames;
    }

    public static boolean hasPlayerGotQuest(PlayerEntity player, String questUniqueName) {
        return PlayerQuestProgressRegistry.getPlayerData((PlayerEntity)player).questUniqueNames.stream().anyMatch(name -> name.equals(questUniqueName));
    }

    public static boolean canPlayerGetQuest(PlayerEntity player, String questUniqueName) {
        Quest quest = QuestRegistry.getQuest(questUniqueName);
        if (quest.parent != null) {
            return PlayerQuestProgressRegistry.hasPlayerGotQuest(player, quest.parent.uniqueName);
        }
        return true;
    }

    public static void givePlayerQuest(PlayerEntity player, String questUniqueName) {
        PlayerQuestProgressRegistry.getPlayerData((PlayerEntity)player).questUniqueNames.add(questUniqueName);
    }

    public static void clearData(String playerName) {
        USER_DATA.remove(PlayerQuestProgressRegistry.getPlayerData(playerName));
    }

    public static final class PlayerQuestProgressData {
        public final String playerName;
        public final Set<String> questUniqueNames;

        public PlayerQuestProgressData(String playerName, Set<String> questUniqueNames) {
            this.playerName = playerName;
            this.questUniqueNames = questUniqueNames;
        }
    }
}

